# trentai-sdk
This service serves inference requests for prompt firewall.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.2
- Package version: 0.0.2
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://trent.ai](https://trent.ai)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import trentai
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import trentai
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import trentai
from trentai.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://wbe44bxve7.execute-api.us-west-2.amazonaws.com/development
# See configuration.py for a list of all supported configuration parameters.
configuration = trentai.Configuration(
    host = "https://wbe44bxve7.execute-api.us-west-2.amazonaws.com/development"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: apiKey
configuration.api_key['apiKey'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['apiKey'] = 'Bearer'


# Enter a context with an instance of the API client
with trentai.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = trentai.PromptFirewallApi(api_client)
    prompt_firewall_request = trentai.PromptFirewallRequest() # PromptFirewallRequest | 

    try:
        # Analyze prompt for security threats
        api_response = api_instance.analyze_prompt(prompt_firewall_request)
        print("The response of PromptFirewallApi->analyze_prompt:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling PromptFirewallApi->analyze_prompt: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://wbe44bxve7.execute-api.us-west-2.amazonaws.com/development*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PromptFirewallApi* | [**analyze_prompt**](docs/PromptFirewallApi.md#analyze_prompt) | **POST** /v1/prompt-firewall | Analyze prompt for security threats


## Documentation For Models

 - [Error](docs/Error.md)
 - [PromptFirewallRequest](docs/PromptFirewallRequest.md)
 - [PromptFirewallResponse](docs/PromptFirewallResponse.md)
 - [PromptFirewallResponseRulesInner](docs/PromptFirewallResponseRulesInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="apiKey"></a>
### apiKey

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author

brajesh@trent.ai


