class FATPrinter():
    def __init__(self) -> None:
        pass

    def print(self, fat):
        print("")
        print("FAT Examiner")
        print("------------")
        print("")
        print("--> Boot Code JMP Instruction (0x0000 - 0x0002 | 3 Bytes)")
        print("    --------------")
        print("    " + fat.bootCodeJmpInst.hex(" ").upper())
        print("")
        print("--> File System OEM Name (0x0003 - 0x000A | 8 Bytes)")
        print("    --------------")
        print("    " + fat.fsOemName.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getOEMName())
        print("")
        print("--> Logical Sector Size (0x000B - 0x000C | 2 Bytes)")
        print("    --------------")
        print("    " + fat.sectorSize.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getSectorSize())
        print("")
        print("--> Logical Sectors per Data Unit (0x000D - 0x000D | 1 Byte)")
        print("    --------------")
        print("    " + fat.sectorsPerDataUnit.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getLogicalSectorsPerDataUnit())
        print("")
        print("--> Logical Sectors within Reserved Area (0x000E - 0x000F | 2 Bytes)")
        print("    --------------")
        print("    " + fat.sectorsPerReserved.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getLogicalSectorsPerReservedArea())
        print("")
        print("--> File Allocation Tables in File System (0x0010 - 0x0010 | 1 Byte)")
        print("    --------------")
        print("    " + fat.noOfFATs.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfFATs())
        print("")
        print("--> Max. No. of Files in Root Directory (0x0011 - 0x0012 | 2 Bytes)")
        print("    --------------")
        print("    " + fat.maxFilesInRootDir.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getMaxFilesInRootDir())        
        print("")
        print("--> No. of Logical Sectors in File System (2 Bytes) (0x0013 - 0x0014 | 2 Bytes)")
        print("    --------------")
        print("    " + fat.noOfSectorsInFS.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfSectorsInFS())     
        print("")
        print("--> Disk Type (2 Bytes) (0x0015 - 0x0015 | 1 Byte)")
        print("    --------------")
        print("    " + fat.storageMediaType.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getStorageType())  
        print("")
        print("--> No. of Logical Sectors per File Allocation Table (0x0016 - 0x0017 | 2 Bytes)")
        print("    --------------")
        print("    " + fat.noOfSectorsInFATs.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfSectorsInFATs())  
        print("")
        print("--> No. of Logical Sectors per Track (0x0018 - 0x0019 | 2 Bytes)")
        print("    --------------")
        print("    " + fat.noOfSectorsPerTrack.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfSectorsPerTrack()) 
        print("")
        print("--> No. of Heads (0x001A - 0x001B | 2 Bytes)")
        print("    --------------")
        print("    " + fat.noOfHeads.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfHeads()) 
        print("")
        print("--> No. of Hidden Logical Sectors before Start of Partition (0x001C - 0x001F | 4 Bytes)")
        print("    --------------")
        print("    " + fat.noOfHiddenLS.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfHiddenSectors()) 
        print("")
        print("--> No. of Logical Sectors in File System (4 Bytes) (0x0020 - 0x0023 | 4 Bytes)")
        print("    --------------")
        print("    " + fat.noOfSectorsInFS_long.hex(" ").upper())
        print("    --------------")
        print("    " + fat.getNoOfSectorsInFS_long()) 