## SpecStory

## Adding MIT License to Project Files (2/2/2025, 9:18:10 AM)

_**User**_

could you add MIT licence to the @pyproject.toml and @setup.py 

---

_**Assistant**_

To add the MIT license to both the `pyproject.toml` and `setup.py` files, you can make the following changes:

### `pyproject.toml`
Add the license information under the `[project]` section:

```toml:pyproject.toml
license = { text = "MIT License" }
```

### `setup.py`
Include the license information in the `setup()` function:

```python:setup.py
from setuptools import find_packages, setup

setup(
    name="colored_custom_logger",
    version="1.6.1",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    project_urls={
        "Documentation": "https://robin-collins.github.io/colored_custom_logger/",
        "Source": "https://github.com/robin-collins/colored_custom_logger/",
    },
    license="MIT",
)
```

This will ensure that the MIT license is specified in both configuration files.

---



---

