"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDowntime = exports.toJson_CfnDowntimeProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDowntimeProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDowntimeProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Disabled': obj.disabled,
        'End': obj.end,
        'Message': obj.message,
        'MonitorId': obj.monitorId,
        'MonitorTags': obj.monitorTags?.map(y => y),
        'Scope': obj.scope?.map(y => y),
        'Start': obj.start,
        'Timezone': obj.timezone,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDowntimeProps = toJson_CfnDowntimeProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Datadog::Monitors::Downtime`
 *
 * @cloudformationResource Datadog::Monitors::Downtime
 * @stability external
 * @link http://unknown-url
 */
class CfnDowntime extends cdk.CfnResource {
    /**
     * Create a new `Datadog::Monitors::Downtime`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDowntime.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDowntimeProps(props) });
        this.props = props;
        this.attrActive = this.getAtt('Active');
        this.attrCanceled = cdk.Token.asNumber(this.getAtt('Canceled'));
        this.attrCreatorId = cdk.Token.asNumber(this.getAtt('CreatorId'));
        this.attrDowntimeType = cdk.Token.asNumber(this.getAtt('DowntimeType'));
        this.attrId = cdk.Token.asNumber(this.getAtt('Id'));
        this.attrParentId = cdk.Token.asNumber(this.getAtt('ParentId'));
        this.attrUpdaterId = cdk.Token.asNumber(this.getAtt('UpdaterId'));
    }
}
exports.CfnDowntime = CfnDowntime;
_a = JSII_RTTI_SYMBOL_1;
CfnDowntime[_a] = { fqn: "@cdk-cloudformation/datadog-monitors-downtime.CfnDowntime", version: "3.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDowntime.CFN_RESOURCE_TYPE_NAME = "Datadog::Monitors::Downtime";
//# sourceMappingURL=data:application/json;base64,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