#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pynitrokey', 'pynitrokey.cli', 'pynitrokey.fido2', 'pynitrokey.start']

package_data = \
{'': ['*']}

install_requires = \
['click >= 7.0',
 'cryptography',
 'ecdsa',
 'fido2',
 'intelhex',
 'pyserial',
 'pyusb',
 'requests',
 'pygments',
 'cffi',
 'cbor']

entry_points = \
{'console_scripts': ['nitropy = pynitrokey.cli:nitropy']}

setup(name='pynitrokey',
      version='0.4.0',
      description='Python Library for Nitrokey FIDO2 & Nitrokey Start.',
      author='Nitrokey',
      author_email='pypi@nitrokey.com',
      url='https://github.com/Nitrokey/pynitrokey',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
