/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.Arrays;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.external.OpenTypeLanguageSystemTag;

public class CssFontLanguageOverride
extends org.w3c.css.properties.css.CssFontLanguageOverride {
    public static final CssIdent normal = CssIdent.getIdent("normal");

    public CssFontLanguageOverride() {
        this.value = initial;
    }

    public CssFontLanguageOverride(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 1: {
                CssString s = (CssString)val;
                if (s.toString().length() != 5) {
                    throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
                }
                String tag = s.toString().substring(1, 4).toUpperCase();
                int idx = Arrays.binarySearch(OpenTypeLanguageSystemTag.tags, tag);
                if (idx < 0) {
                    throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
                }
                this.value = s;
                break;
            }
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(ident)) {
                    this.value = inherit;
                    break;
                }
                if (normal.equals(ident)) {
                    this.value = normal;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFontLanguageOverride(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

