# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-27 20:04
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_ca.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now=True)),
                ('expires', models.DateTimeField()),
                ('pub', models.TextField(verbose_name='Public key')),
                ('cn', models.CharField(max_length=64, verbose_name='CommonName')),
                ('serial', models.CharField(max_length=48, unique=True)),
                ('csr', models.TextField(verbose_name='CSR')),
                ('revoked', models.BooleanField(default=False)),
                ('revoked_date', models.DateTimeField(blank=True, null=True, verbose_name='Revoked on')),
                ('revoked_reason', models.CharField(blank=True, choices=[('', 'No reason'), ('unspecified', 'Unspecified'), ('keyCompromise', 'Key compromised'), ('CACompromise', 'CA compromised'), ('affiliationChanged', 'Affiliation changed'), ('superseded', 'Superseded'), ('cessationOfOperation', 'Cessation of operation'), ('certificateHold', 'On Hold')], max_length=32, null=True, verbose_name='Reason for revokation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CertificateAuthority',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now=True)),
                ('expires', models.DateTimeField()),
                ('pub', models.TextField(verbose_name='Public key')),
                ('cn', models.CharField(max_length=64, verbose_name='CommonName')),
                ('serial', models.CharField(max_length=48, unique=True)),
                ('name', models.CharField(help_text='A human-readable name', max_length=32, unique=True)),
                ('enabled', models.BooleanField(default=True)),
                ('private_key_path', models.CharField(help_text='Path to the private key.', max_length=256)),
                ('crl_url', models.TextField(blank=True, help_text='URLs, one per line, where you can retrieve the CRL.', null=True, validators=[django_ca.utils.multiline_url_validator], verbose_name='CRL URLs')),
                ('issuer_url', models.URLField(blank=True, help_text='URL to the certificate of this CA (in DER format).', null=True, verbose_name='Issuer URL')),
                ('ocsp_url', models.URLField(blank=True, help_text='URL of a OCSP responser for the CA.', null=True, verbose_name='OCSP responder URL')),
                ('issuer_alt_name', models.URLField(blank=True, help_text='URL for your CA.', null=True, verbose_name='issuerAltName')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='django_ca.CertificateAuthority')),
            ],
            options={
                'verbose_name': 'Certificate Authority',
                'verbose_name_plural': 'Certificate Authorities',
            },
        ),
        migrations.CreateModel(
            name='Watcher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=64, null=True, verbose_name='CommonName')),
                ('mail', models.EmailField(max_length=254, unique=True, verbose_name='E-Mail')),
            ],
        ),
        migrations.AddField(
            model_name='certificate',
            name='ca',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_ca.CertificateAuthority', verbose_name='Certificate Authority'),
        ),
        migrations.AddField(
            model_name='certificate',
            name='watchers',
            field=models.ManyToManyField(blank=True, related_name='certificates', to='django_ca.Watcher'),
        ),
    ]
