# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import SourceControlConfigurationClientConfiguration
from .operations import SourceControlConfigurationsOperations
from .operations import Operations
from . import models


class SourceControlConfigurationClient(SDKClient):
    """Use these APIs to create Source Control Configuration resources through ARM, for Kubernetes Clusters.

    :ivar config: Configuration for client.
    :vartype config: SourceControlConfigurationClientConfiguration

    :ivar source_control_configurations: SourceControlConfigurations operations
    :vartype source_control_configurations: azure.mgmt.kubernetesconfiguration.operations.SourceControlConfigurationsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.kubernetesconfiguration.operations.Operations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID. This is a
     GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = SourceControlConfigurationClientConfiguration(credentials, subscription_id, base_url)
        super(SourceControlConfigurationClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2021-03-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.source_control_configurations = SourceControlConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
