import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseServiceInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#availability_domain DatabaseServiceInstance#availability_domain}
    */
    readonly availabilityDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#bring_your_own_license DatabaseServiceInstance#bring_your_own_license}
    */
    readonly bringYourOwnLicense?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#description DatabaseServiceInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#desired_state DatabaseServiceInstance#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#edition DatabaseServiceInstance#edition}
    */
    readonly edition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#high_performance_storage DatabaseServiceInstance#high_performance_storage}
    */
    readonly highPerformanceStorage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#id DatabaseServiceInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#ip_network DatabaseServiceInstance#ip_network}
    */
    readonly ipNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#ip_reservations DatabaseServiceInstance#ip_reservations}
    */
    readonly ipReservations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#level DatabaseServiceInstance#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#name DatabaseServiceInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#notification_email DatabaseServiceInstance#notification_email}
    */
    readonly notificationEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#region DatabaseServiceInstance#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#shape DatabaseServiceInstance#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#ssh_public_key DatabaseServiceInstance#ssh_public_key}
    */
    readonly sshPublicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#subnet DatabaseServiceInstance#subnet}
    */
    readonly subnet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#subscription_type DatabaseServiceInstance#subscription_type}
    */
    readonly subscriptionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#version DatabaseServiceInstance#version}
    */
    readonly version: string;
    /**
    * backups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#backups DatabaseServiceInstance#backups}
    */
    readonly backups?: DatabaseServiceInstanceBackups;
    /**
    * database_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#database_configuration DatabaseServiceInstance#database_configuration}
    */
    readonly databaseConfiguration: DatabaseServiceInstanceDatabaseConfiguration;
    /**
    * default_access_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#default_access_rules DatabaseServiceInstance#default_access_rules}
    */
    readonly defaultAccessRules?: DatabaseServiceInstanceDefaultAccessRules;
    /**
    * hybrid_disaster_recovery block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#hybrid_disaster_recovery DatabaseServiceInstance#hybrid_disaster_recovery}
    */
    readonly hybridDisasterRecovery?: DatabaseServiceInstanceHybridDisasterRecovery;
    /**
    * instantiate_from_backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#instantiate_from_backup DatabaseServiceInstance#instantiate_from_backup}
    */
    readonly instantiateFromBackup?: DatabaseServiceInstanceInstantiateFromBackup;
    /**
    * standby block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#standby DatabaseServiceInstance#standby}
    */
    readonly standby?: DatabaseServiceInstanceStandby;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#timeouts DatabaseServiceInstance#timeouts}
    */
    readonly timeouts?: DatabaseServiceInstanceTimeouts;
}
export interface DatabaseServiceInstanceBackups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_container DatabaseServiceInstance#cloud_storage_container}
    */
    readonly cloudStorageContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_password DatabaseServiceInstance#cloud_storage_password}
    */
    readonly cloudStoragePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_username DatabaseServiceInstance#cloud_storage_username}
    */
    readonly cloudStorageUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#create_if_missing DatabaseServiceInstance#create_if_missing}
    */
    readonly createIfMissing?: boolean | cdktf.IResolvable;
}
export declare function databaseServiceInstanceBackupsToTerraform(struct?: DatabaseServiceInstanceBackupsOutputReference | DatabaseServiceInstanceBackups): any;
export declare class DatabaseServiceInstanceBackupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceBackups | undefined;
    set internalValue(value: DatabaseServiceInstanceBackups | undefined);
    private _cloudStorageContainer?;
    get cloudStorageContainer(): string;
    set cloudStorageContainer(value: string);
    get cloudStorageContainerInput(): string | undefined;
    private _cloudStoragePassword?;
    get cloudStoragePassword(): string;
    set cloudStoragePassword(value: string);
    resetCloudStoragePassword(): void;
    get cloudStoragePasswordInput(): string | undefined;
    private _cloudStorageUsername?;
    get cloudStorageUsername(): string;
    set cloudStorageUsername(value: string);
    resetCloudStorageUsername(): void;
    get cloudStorageUsernameInput(): string | undefined;
    private _createIfMissing?;
    get createIfMissing(): boolean | cdktf.IResolvable;
    set createIfMissing(value: boolean | cdktf.IResolvable);
    resetCreateIfMissing(): void;
    get createIfMissingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DatabaseServiceInstanceDatabaseConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#admin_password DatabaseServiceInstance#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#backup_destination DatabaseServiceInstance#backup_destination}
    */
    readonly backupDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#backup_storage_volume_size DatabaseServiceInstance#backup_storage_volume_size}
    */
    readonly backupStorageVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#character_set DatabaseServiceInstance#character_set}
    */
    readonly characterSet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#data_storage_volume_size DatabaseServiceInstance#data_storage_volume_size}
    */
    readonly dataStorageVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#db_demo DatabaseServiceInstance#db_demo}
    */
    readonly dbDemo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#disaster_recovery DatabaseServiceInstance#disaster_recovery}
    */
    readonly disasterRecovery?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#failover_database DatabaseServiceInstance#failover_database}
    */
    readonly failoverDatabase?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#golden_gate DatabaseServiceInstance#golden_gate}
    */
    readonly goldenGate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#is_rac DatabaseServiceInstance#is_rac}
    */
    readonly isRac?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#national_character_set DatabaseServiceInstance#national_character_set}
    */
    readonly nationalCharacterSet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#pdb_name DatabaseServiceInstance#pdb_name}
    */
    readonly pdbName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#sid DatabaseServiceInstance#sid}
    */
    readonly sid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#snapshot_name DatabaseServiceInstance#snapshot_name}
    */
    readonly snapshotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#source_service_name DatabaseServiceInstance#source_service_name}
    */
    readonly sourceServiceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#timezone DatabaseServiceInstance#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#type DatabaseServiceInstance#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#usable_storage DatabaseServiceInstance#usable_storage}
    */
    readonly usableStorage: number;
}
export declare function databaseServiceInstanceDatabaseConfigurationToTerraform(struct?: DatabaseServiceInstanceDatabaseConfigurationOutputReference | DatabaseServiceInstanceDatabaseConfiguration): any;
export declare class DatabaseServiceInstanceDatabaseConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceDatabaseConfiguration | undefined;
    set internalValue(value: DatabaseServiceInstanceDatabaseConfiguration | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    private _backupDestination?;
    get backupDestination(): string;
    set backupDestination(value: string);
    resetBackupDestination(): void;
    get backupDestinationInput(): string | undefined;
    private _backupStorageVolumeSize?;
    get backupStorageVolumeSize(): number;
    set backupStorageVolumeSize(value: number);
    resetBackupStorageVolumeSize(): void;
    get backupStorageVolumeSizeInput(): number | undefined;
    private _characterSet?;
    get characterSet(): string;
    set characterSet(value: string);
    resetCharacterSet(): void;
    get characterSetInput(): string | undefined;
    private _dataStorageVolumeSize?;
    get dataStorageVolumeSize(): number;
    set dataStorageVolumeSize(value: number);
    resetDataStorageVolumeSize(): void;
    get dataStorageVolumeSizeInput(): number | undefined;
    private _dbDemo?;
    get dbDemo(): string;
    set dbDemo(value: string);
    resetDbDemo(): void;
    get dbDemoInput(): string | undefined;
    private _disasterRecovery?;
    get disasterRecovery(): boolean | cdktf.IResolvable;
    set disasterRecovery(value: boolean | cdktf.IResolvable);
    resetDisasterRecovery(): void;
    get disasterRecoveryInput(): boolean | cdktf.IResolvable | undefined;
    private _failoverDatabase?;
    get failoverDatabase(): boolean | cdktf.IResolvable;
    set failoverDatabase(value: boolean | cdktf.IResolvable);
    resetFailoverDatabase(): void;
    get failoverDatabaseInput(): boolean | cdktf.IResolvable | undefined;
    private _goldenGate?;
    get goldenGate(): boolean | cdktf.IResolvable;
    set goldenGate(value: boolean | cdktf.IResolvable);
    resetGoldenGate(): void;
    get goldenGateInput(): boolean | cdktf.IResolvable | undefined;
    private _isRac?;
    get isRac(): boolean | cdktf.IResolvable;
    set isRac(value: boolean | cdktf.IResolvable);
    resetIsRac(): void;
    get isRacInput(): boolean | cdktf.IResolvable | undefined;
    private _nationalCharacterSet?;
    get nationalCharacterSet(): string;
    set nationalCharacterSet(value: string);
    resetNationalCharacterSet(): void;
    get nationalCharacterSetInput(): string | undefined;
    private _pdbName?;
    get pdbName(): string;
    set pdbName(value: string);
    resetPdbName(): void;
    get pdbNameInput(): string | undefined;
    private _sid?;
    get sid(): string;
    set sid(value: string);
    resetSid(): void;
    get sidInput(): string | undefined;
    private _snapshotName?;
    get snapshotName(): string;
    set snapshotName(value: string);
    resetSnapshotName(): void;
    get snapshotNameInput(): string | undefined;
    private _sourceServiceName?;
    get sourceServiceName(): string;
    set sourceServiceName(value: string);
    resetSourceServiceName(): void;
    get sourceServiceNameInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _usableStorage?;
    get usableStorage(): number;
    set usableStorage(value: number);
    get usableStorageInput(): number | undefined;
}
export interface DatabaseServiceInstanceDefaultAccessRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_db_console DatabaseServiceInstance#enable_db_console}
    */
    readonly enableDbConsole?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_db_express DatabaseServiceInstance#enable_db_express}
    */
    readonly enableDbExpress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_db_listener DatabaseServiceInstance#enable_db_listener}
    */
    readonly enableDbListener?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_em_console DatabaseServiceInstance#enable_em_console}
    */
    readonly enableEmConsole?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_http DatabaseServiceInstance#enable_http}
    */
    readonly enableHttp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_http_ssl DatabaseServiceInstance#enable_http_ssl}
    */
    readonly enableHttpSsl?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_rac_db_listener DatabaseServiceInstance#enable_rac_db_listener}
    */
    readonly enableRacDbListener?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_rac_ons DatabaseServiceInstance#enable_rac_ons}
    */
    readonly enableRacOns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_scan_listener DatabaseServiceInstance#enable_scan_listener}
    */
    readonly enableScanListener?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#enable_ssh DatabaseServiceInstance#enable_ssh}
    */
    readonly enableSsh?: boolean | cdktf.IResolvable;
}
export declare function databaseServiceInstanceDefaultAccessRulesToTerraform(struct?: DatabaseServiceInstanceDefaultAccessRulesOutputReference | DatabaseServiceInstanceDefaultAccessRules): any;
export declare class DatabaseServiceInstanceDefaultAccessRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceDefaultAccessRules | undefined;
    set internalValue(value: DatabaseServiceInstanceDefaultAccessRules | undefined);
    private _enableDbConsole?;
    get enableDbConsole(): boolean | cdktf.IResolvable;
    set enableDbConsole(value: boolean | cdktf.IResolvable);
    resetEnableDbConsole(): void;
    get enableDbConsoleInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDbExpress?;
    get enableDbExpress(): boolean | cdktf.IResolvable;
    set enableDbExpress(value: boolean | cdktf.IResolvable);
    resetEnableDbExpress(): void;
    get enableDbExpressInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDbListener?;
    get enableDbListener(): boolean | cdktf.IResolvable;
    set enableDbListener(value: boolean | cdktf.IResolvable);
    resetEnableDbListener(): void;
    get enableDbListenerInput(): boolean | cdktf.IResolvable | undefined;
    private _enableEmConsole?;
    get enableEmConsole(): boolean | cdktf.IResolvable;
    set enableEmConsole(value: boolean | cdktf.IResolvable);
    resetEnableEmConsole(): void;
    get enableEmConsoleInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttp?;
    get enableHttp(): boolean | cdktf.IResolvable;
    set enableHttp(value: boolean | cdktf.IResolvable);
    resetEnableHttp(): void;
    get enableHttpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttpSsl?;
    get enableHttpSsl(): boolean | cdktf.IResolvable;
    set enableHttpSsl(value: boolean | cdktf.IResolvable);
    resetEnableHttpSsl(): void;
    get enableHttpSslInput(): boolean | cdktf.IResolvable | undefined;
    private _enableRacDbListener?;
    get enableRacDbListener(): boolean | cdktf.IResolvable;
    set enableRacDbListener(value: boolean | cdktf.IResolvable);
    resetEnableRacDbListener(): void;
    get enableRacDbListenerInput(): boolean | cdktf.IResolvable | undefined;
    private _enableRacOns?;
    get enableRacOns(): boolean | cdktf.IResolvable;
    set enableRacOns(value: boolean | cdktf.IResolvable);
    resetEnableRacOns(): void;
    get enableRacOnsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableScanListener?;
    get enableScanListener(): boolean | cdktf.IResolvable;
    set enableScanListener(value: boolean | cdktf.IResolvable);
    resetEnableScanListener(): void;
    get enableScanListenerInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSsh?;
    get enableSsh(): boolean | cdktf.IResolvable;
    set enableSsh(value: boolean | cdktf.IResolvable);
    resetEnableSsh(): void;
    get enableSshInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DatabaseServiceInstanceHybridDisasterRecovery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_container DatabaseServiceInstance#cloud_storage_container}
    */
    readonly cloudStorageContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_password DatabaseServiceInstance#cloud_storage_password}
    */
    readonly cloudStoragePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_username DatabaseServiceInstance#cloud_storage_username}
    */
    readonly cloudStorageUsername?: string;
}
export declare function databaseServiceInstanceHybridDisasterRecoveryToTerraform(struct?: DatabaseServiceInstanceHybridDisasterRecoveryOutputReference | DatabaseServiceInstanceHybridDisasterRecovery): any;
export declare class DatabaseServiceInstanceHybridDisasterRecoveryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceHybridDisasterRecovery | undefined;
    set internalValue(value: DatabaseServiceInstanceHybridDisasterRecovery | undefined);
    private _cloudStorageContainer?;
    get cloudStorageContainer(): string;
    set cloudStorageContainer(value: string);
    get cloudStorageContainerInput(): string | undefined;
    private _cloudStoragePassword?;
    get cloudStoragePassword(): string;
    set cloudStoragePassword(value: string);
    resetCloudStoragePassword(): void;
    get cloudStoragePasswordInput(): string | undefined;
    private _cloudStorageUsername?;
    get cloudStorageUsername(): string;
    set cloudStorageUsername(value: string);
    resetCloudStorageUsername(): void;
    get cloudStorageUsernameInput(): string | undefined;
}
export interface DatabaseServiceInstanceInstantiateFromBackup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_container DatabaseServiceInstance#cloud_storage_container}
    */
    readonly cloudStorageContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_password DatabaseServiceInstance#cloud_storage_password}
    */
    readonly cloudStoragePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#cloud_storage_username DatabaseServiceInstance#cloud_storage_username}
    */
    readonly cloudStorageUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#database_id DatabaseServiceInstance#database_id}
    */
    readonly databaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#decryption_key DatabaseServiceInstance#decryption_key}
    */
    readonly decryptionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#on_premise DatabaseServiceInstance#on_premise}
    */
    readonly onPremise?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#service_id DatabaseServiceInstance#service_id}
    */
    readonly serviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#wallet_file_content DatabaseServiceInstance#wallet_file_content}
    */
    readonly walletFileContent?: string;
}
export declare function databaseServiceInstanceInstantiateFromBackupToTerraform(struct?: DatabaseServiceInstanceInstantiateFromBackupOutputReference | DatabaseServiceInstanceInstantiateFromBackup): any;
export declare class DatabaseServiceInstanceInstantiateFromBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceInstantiateFromBackup | undefined;
    set internalValue(value: DatabaseServiceInstanceInstantiateFromBackup | undefined);
    private _cloudStorageContainer?;
    get cloudStorageContainer(): string;
    set cloudStorageContainer(value: string);
    get cloudStorageContainerInput(): string | undefined;
    private _cloudStoragePassword?;
    get cloudStoragePassword(): string;
    set cloudStoragePassword(value: string);
    resetCloudStoragePassword(): void;
    get cloudStoragePasswordInput(): string | undefined;
    private _cloudStorageUsername?;
    get cloudStorageUsername(): string;
    set cloudStorageUsername(value: string);
    resetCloudStorageUsername(): void;
    get cloudStorageUsernameInput(): string | undefined;
    private _databaseId?;
    get databaseId(): string;
    set databaseId(value: string);
    get databaseIdInput(): string | undefined;
    private _decryptionKey?;
    get decryptionKey(): string;
    set decryptionKey(value: string);
    resetDecryptionKey(): void;
    get decryptionKeyInput(): string | undefined;
    private _onPremise?;
    get onPremise(): boolean | cdktf.IResolvable;
    set onPremise(value: boolean | cdktf.IResolvable);
    resetOnPremise(): void;
    get onPremiseInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    resetServiceId(): void;
    get serviceIdInput(): string | undefined;
    private _walletFileContent?;
    get walletFileContent(): string;
    set walletFileContent(value: string);
    resetWalletFileContent(): void;
    get walletFileContentInput(): string | undefined;
}
export interface DatabaseServiceInstanceStandby {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#availability_domain DatabaseServiceInstance#availability_domain}
    */
    readonly availabilityDomain: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#subnet DatabaseServiceInstance#subnet}
    */
    readonly subnet: string;
}
export declare function databaseServiceInstanceStandbyToTerraform(struct?: DatabaseServiceInstanceStandbyOutputReference | DatabaseServiceInstanceStandby): any;
export declare class DatabaseServiceInstanceStandbyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceStandby | undefined;
    set internalValue(value: DatabaseServiceInstanceStandby | undefined);
    private _availabilityDomain?;
    get availabilityDomain(): string;
    set availabilityDomain(value: string);
    get availabilityDomainInput(): string | undefined;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    get subnetInput(): string | undefined;
}
export interface DatabaseServiceInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#create DatabaseServiceInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#delete DatabaseServiceInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance#update DatabaseServiceInstance#update}
    */
    readonly update?: string;
}
export declare function databaseServiceInstanceTimeoutsToTerraform(struct?: DatabaseServiceInstanceTimeoutsOutputReference | DatabaseServiceInstanceTimeouts | cdktf.IResolvable): any;
export declare class DatabaseServiceInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseServiceInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseServiceInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance oraclepaas_database_service_instance}
*/
export declare class DatabaseServiceInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "oraclepaas_database_service_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance oraclepaas_database_service_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseServiceInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseServiceInstanceConfig);
    private _availabilityDomain?;
    get availabilityDomain(): string;
    set availabilityDomain(value: string);
    resetAvailabilityDomain(): void;
    get availabilityDomainInput(): string | undefined;
    private _bringYourOwnLicense?;
    get bringYourOwnLicense(): boolean | cdktf.IResolvable;
    set bringYourOwnLicense(value: boolean | cdktf.IResolvable);
    resetBringYourOwnLicense(): void;
    get bringYourOwnLicenseInput(): boolean | cdktf.IResolvable | undefined;
    get cloudStorageContainer(): string;
    get computeSiteName(): string;
    get dbaasMonitorUrl(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    get editionInput(): string | undefined;
    get emUrl(): string;
    get glassfishUrl(): string;
    private _highPerformanceStorage?;
    get highPerformanceStorage(): boolean | cdktf.IResolvable;
    set highPerformanceStorage(value: boolean | cdktf.IResolvable);
    resetHighPerformanceStorage(): void;
    get highPerformanceStorageInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identityDomain(): string;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    resetIpNetwork(): void;
    get ipNetworkInput(): string | undefined;
    private _ipReservations?;
    get ipReservations(): string[];
    set ipReservations(value: string[]);
    resetIpReservations(): void;
    get ipReservationsInput(): string[] | undefined;
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationEmail?;
    get notificationEmail(): string;
    set notificationEmail(value: string);
    resetNotificationEmail(): void;
    get notificationEmailInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    get sshPublicKeyInput(): string | undefined;
    get status(): string;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _subscriptionType?;
    get subscriptionType(): string;
    set subscriptionType(value: string);
    get subscriptionTypeInput(): string | undefined;
    get uri(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _backups;
    get backups(): DatabaseServiceInstanceBackupsOutputReference;
    putBackups(value: DatabaseServiceInstanceBackups): void;
    resetBackups(): void;
    get backupsInput(): DatabaseServiceInstanceBackups | undefined;
    private _databaseConfiguration;
    get databaseConfiguration(): DatabaseServiceInstanceDatabaseConfigurationOutputReference;
    putDatabaseConfiguration(value: DatabaseServiceInstanceDatabaseConfiguration): void;
    get databaseConfigurationInput(): DatabaseServiceInstanceDatabaseConfiguration | undefined;
    private _defaultAccessRules;
    get defaultAccessRules(): DatabaseServiceInstanceDefaultAccessRulesOutputReference;
    putDefaultAccessRules(value: DatabaseServiceInstanceDefaultAccessRules): void;
    resetDefaultAccessRules(): void;
    get defaultAccessRulesInput(): DatabaseServiceInstanceDefaultAccessRules | undefined;
    private _hybridDisasterRecovery;
    get hybridDisasterRecovery(): DatabaseServiceInstanceHybridDisasterRecoveryOutputReference;
    putHybridDisasterRecovery(value: DatabaseServiceInstanceHybridDisasterRecovery): void;
    resetHybridDisasterRecovery(): void;
    get hybridDisasterRecoveryInput(): DatabaseServiceInstanceHybridDisasterRecovery | undefined;
    private _instantiateFromBackup;
    get instantiateFromBackup(): DatabaseServiceInstanceInstantiateFromBackupOutputReference;
    putInstantiateFromBackup(value: DatabaseServiceInstanceInstantiateFromBackup): void;
    resetInstantiateFromBackup(): void;
    get instantiateFromBackupInput(): DatabaseServiceInstanceInstantiateFromBackup | undefined;
    private _standby;
    get standby(): DatabaseServiceInstanceStandbyOutputReference;
    putStandby(value: DatabaseServiceInstanceStandby): void;
    resetStandby(): void;
    get standbyInput(): DatabaseServiceInstanceStandby | undefined;
    private _timeouts;
    get timeouts(): DatabaseServiceInstanceTimeoutsOutputReference;
    putTimeouts(value: DatabaseServiceInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabaseServiceInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
