# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *
from ._inputs import *
import pulumi_aws

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 dead_letter_queue_type_args: Optional[pulumi.Input['DeadLetterQueueTypeArgsArgs']] = None,
                 is_fifo: Optional[pulumi.Input[bool]] = None,
                 max_message_size: Optional[pulumi.Input[float]] = None,
                 message_retention_seconds: Optional[pulumi.Input[float]] = None,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input['DeadLetterQueueTypeArgsArgs'] dead_letter_queue_type_args: Dead Letter Queue attached to the component to create.
        :param pulumi.Input[bool] is_fifo: Set to true to create the Queue as FiFo. False for a Standard Queue.
        :param pulumi.Input[float] max_message_size: The limit for a Queue message size in bytes. Minimum is 1 byte (1 character) and Maximum 262,144 bytes (256 KiB). By default a message can be 256 KiB large.
        :param pulumi.Input[float] message_retention_seconds: The amount of time that a message will be stored in the Queue without being deleted. Minimum is 60 seconds (1 minutes) and Maximum 1,209,600 (14 days) seconds. By default a message is retained 4 days.
        :param pulumi.Input[str] policy: Custom policy for the Queue.
        """
        if dead_letter_queue_type_args is not None:
            pulumi.set(__self__, "dead_letter_queue_type_args", dead_letter_queue_type_args)
        if is_fifo is not None:
            pulumi.set(__self__, "is_fifo", is_fifo)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if message_retention_seconds is not None:
            pulumi.set(__self__, "message_retention_seconds", message_retention_seconds)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="DeadLetterQueueTypeArgs")
    def dead_letter_queue_type_args(self) -> Optional[pulumi.Input['DeadLetterQueueTypeArgsArgs']]:
        """
        Dead Letter Queue attached to the component to create.
        """
        return pulumi.get(self, "dead_letter_queue_type_args")

    @dead_letter_queue_type_args.setter
    def dead_letter_queue_type_args(self, value: Optional[pulumi.Input['DeadLetterQueueTypeArgsArgs']]):
        pulumi.set(self, "dead_letter_queue_type_args", value)

    @property
    @pulumi.getter(name="isFifo")
    def is_fifo(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to create the Queue as FiFo. False for a Standard Queue.
        """
        return pulumi.get(self, "is_fifo")

    @is_fifo.setter
    def is_fifo(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_fifo", value)

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[float]]:
        """
        The limit for a Queue message size in bytes. Minimum is 1 byte (1 character) and Maximum 262,144 bytes (256 KiB). By default a message can be 256 KiB large.
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_message_size", value)

    @property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of time that a message will be stored in the Queue without being deleted. Minimum is 60 seconds (1 minutes) and Maximum 1,209,600 (14 days) seconds. By default a message is retained 4 days.
        """
        return pulumi.get(self, "message_retention_seconds")

    @message_retention_seconds.setter
    def message_retention_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "message_retention_seconds", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Custom policy for the Queue.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


class Queue(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dead_letter_queue_type_args: Optional[pulumi.Input[pulumi.InputType['DeadLetterQueueTypeArgsArgs']]] = None,
                 is_fifo: Optional[pulumi.Input[bool]] = None,
                 max_message_size: Optional[pulumi.Input[float]] = None,
                 message_retention_seconds: Optional[pulumi.Input[float]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cloud Toolkit component for Queues. Creates a Simple Queue Service Queue alongside a Dead Letter Queue for faulty message deliveries.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeadLetterQueueTypeArgsArgs']] dead_letter_queue_type_args: Dead Letter Queue attached to the component to create.
        :param pulumi.Input[bool] is_fifo: Set to true to create the Queue as FiFo. False for a Standard Queue.
        :param pulumi.Input[float] max_message_size: The limit for a Queue message size in bytes. Minimum is 1 byte (1 character) and Maximum 262,144 bytes (256 KiB). By default a message can be 256 KiB large.
        :param pulumi.Input[float] message_retention_seconds: The amount of time that a message will be stored in the Queue without being deleted. Minimum is 60 seconds (1 minutes) and Maximum 1,209,600 (14 days) seconds. By default a message is retained 4 days.
        :param pulumi.Input[str] policy: Custom policy for the Queue.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QueueArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloud Toolkit component for Queues. Creates a Simple Queue Service Queue alongside a Dead Letter Queue for faulty message deliveries.

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dead_letter_queue_type_args: Optional[pulumi.Input[pulumi.InputType['DeadLetterQueueTypeArgsArgs']]] = None,
                 is_fifo: Optional[pulumi.Input[bool]] = None,
                 max_message_size: Optional[pulumi.Input[float]] = None,
                 message_retention_seconds: Optional[pulumi.Input[float]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            __props__.__dict__["dead_letter_queue_type_args"] = dead_letter_queue_type_args
            __props__.__dict__["is_fifo"] = is_fifo
            __props__.__dict__["max_message_size"] = max_message_size
            __props__.__dict__["message_retention_seconds"] = message_retention_seconds
            __props__.__dict__["policy"] = policy
            __props__.__dict__["dead_letter_queue"] = None
            __props__.__dict__["sqs_queue"] = None
        super(Queue, __self__).__init__(
            'cloud-toolkit-aws:serverless:Queue',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> pulumi.Output[Optional['pulumi_aws.sqs.Queue']]:
        """
        Dead Letter Queue associated with the component. Messages that were not delivered will be sent here.
        """
        return pulumi.get(self, "dead_letter_queue")

    @property
    @pulumi.getter(name="sqsQueue")
    def sqs_queue(self) -> pulumi.Output['pulumi_aws.sqs.Queue']:
        """
        Simple Queue Service Queue underline the component.
        """
        return pulumi.get(self, "sqs_queue")

