# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._inputs import *
import pulumi_aws

__all__ = ['AccountIamArgs', 'AccountIam']

@pulumi.input_type
class AccountIamArgs:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input['AccountPasswordPolicyArgsArgs']] = None):
        """
        The set of arguments for constructing a AccountIam resource.
        :param pulumi.Input[str] alias: The alias to be used for IAM.
        :param pulumi.Input['AccountPasswordPolicyArgsArgs'] password_policy: The IAM password policy configuration.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias to be used for IAM.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['AccountPasswordPolicyArgsArgs']]:
        """
        The IAM password policy configuration.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['AccountPasswordPolicyArgsArgs']]):
        pulumi.set(self, "password_policy", value)


class AccountIam(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['AccountPasswordPolicyArgsArgs']]] = None,
                 __props__=None):
        """
        Cluster is a component that configure the IAM service for a given account.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: The alias to be used for IAM.
        :param pulumi.Input[pulumi.InputType['AccountPasswordPolicyArgsArgs']] password_policy: The IAM password policy configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccountIamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cluster is a component that configure the IAM service for a given account.

        :param str resource_name: The name of the resource.
        :param AccountIamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountIamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['AccountPasswordPolicyArgsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountIamArgs.__new__(AccountIamArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["password_policy"] = password_policy
        super(AccountIam, __self__).__init__(
            'cloud-toolkit-aws:landingzone:AccountIam',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional['pulumi_aws.iam.AccountAlias']]:
        """
        The IAM Account Alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Output[Optional['pulumi_aws.iam.AccountPasswordPolicy']]:
        """
        The IAM Account Password policy.
        """
        return pulumi.get(self, "password_policy")

