# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
import pulumi_kubernetes
import pulumi_random

__all__ = ['ArgoCDArgs', 'ArgoCD']

@pulumi.input_type
class ArgoCDArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ArgoCD resource.
        :param pulumi.Input[str] hostname: The hostname to be used to expose ArgoCD with an Ingress.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to be used to expose ArgoCD with an Ingress.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


class ArgoCD(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ArgoCD is a component that deploy the ArgoCD application in the cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The hostname to be used to expose ArgoCD with an Ingress.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ArgoCDArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ArgoCD is a component that deploy the ArgoCD application in the cluster.

        :param str resource_name: The name of the resource.
        :param ArgoCDArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArgoCDArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArgoCDArgs.__new__(ArgoCDArgs)

            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["admin_password"] = None
            __props__.__dict__["chart"] = None
            __props__.__dict__["namespace"] = None
        super(ArgoCD, __self__).__init__(
            'cloud-toolkit-aws:kubernetes:ArgoCD',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output['pulumi_random.RandomPassword']:
        """
        The inital admin password.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter
    def chart(self) -> pulumi.Output['pulumi_kubernetes.helm.v3.Chart']:
        """
        The Helm Chart used to deploy ArgoCD.
        """
        return pulumi.get(self, "chart")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output['pulumi_kubernetes.core.v1.Namespace']:
        """
        The Namespace used to deploy the component.
        """
        return pulumi.get(self, "namespace")

