"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMethodsSequenceType(str, Enum):
    r"""Set this parameter to `first` to only return the enabled methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.
    """

    ONEOFF = "oneoff"
    FIRST = "first"
    RECURRING = "recurring"


class ListMethodsLocale(str, Enum):
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class ListMethodsAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class Resource(str, Enum):
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order)
    or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods
    that are only available for payments created via the Orders API.
    """

    PAYMENTS = "payments"
    ORDERS = "orders"


class IncludeWallets(str, Enum):
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code
    to check if they are available on the shoppers device, hence the need to indicate your support.
    """

    APPLEPAY = "applepay"


class OrderLineCategories(str, Enum):
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`
    """

    ECO = "eco"
    GIFT = "gift"
    MEAL = "meal"
    SPORT_CULTURE = "sport_culture"
    ADDITIONAL = "additional"
    CONSUME = "consume"


class ListMethodsInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    ISSUERS = "issuers"


class ListMethodsRequestTypedDict(TypedDict):
    sequence_type: NotRequired[ListMethodsSequenceType]
    r"""Set this parameter to `first` to only return the enabled methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.
    """
    locale: NotRequired[ListMethodsLocale]
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """
    amount: NotRequired[ListMethodsAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """
    resource: NotRequired[Resource]
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order)
    or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods
    that are only available for payments created via the Orders API.
    """
    billing_country: NotRequired[str]
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used
    to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """
    include_wallets: NotRequired[IncludeWallets]
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code
    to check if they are available on the shoppers device, hence the need to indicate your support.
    """
    order_line_categories: NotRequired[OrderLineCategories]
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[ListMethodsInclude]]
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListMethodsRequest(BaseModel):
    sequence_type: Annotated[
        Optional[ListMethodsSequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the enabled methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.
    """

    locale: Annotated[
        Optional[ListMethodsLocale],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    amount: Annotated[
        Optional[ListMethodsAmount],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """

    resource: Annotated[
        Optional[Resource],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order)
    or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods
    that are only available for payments created via the Orders API.
    """

    billing_country: Annotated[
        Optional[str],
        pydantic.Field(alias="billingCountry"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used
    to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """

    include_wallets: Annotated[
        Optional[IncludeWallets],
        pydantic.Field(alias="includeWallets"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code
    to check if they are available on the shoppers device, hence the need to indicate your support.
    """

    order_line_categories: Annotated[
        Optional[OrderLineCategories],
        pydantic.Field(alias="orderLineCategories"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[ListMethodsInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sequenceType",
            "locale",
            "amount",
            "resource",
            "billingCountry",
            "includeWallets",
            "orderLineCategories",
            "profileId",
            "include",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMethodsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMethodsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMethodsBadRequestLinksTypedDict(TypedDict):
    documentation: ListMethodsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsBadRequestLinks(BaseModel):
    documentation: ListMethodsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListMethodsBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListMethodsHalJSONError(ClientError):
    r"""An error response object."""

    data: ListMethodsHalJSONErrorData

    def __init__(
        self,
        data: ListMethodsHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListMethodsID(str, Enum):
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ListMethodsMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListMethodsImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListMethodsStatus(str, Enum):
    r"""The payment method's activation status for this profile."""

    ACTIVATED = "activated"
    PENDING_BOARDING = "pending-boarding"
    PENDING_REVIEW = "pending-review"
    PENDING_EXTERNAL = "pending-external"
    REJECTED = "rejected"


class ListMethodsIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListMethodsIssuerImage(BaseModel):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListMethodsIssuerTypedDict(TypedDict):
    resource: str
    id: str
    name: str
    r"""The full name of the issuer."""
    image: ListMethodsIssuerImageTypedDict
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class ListMethodsIssuer(BaseModel):
    resource: str

    id: str

    name: str
    r"""The full name of the issuer."""

    image: ListMethodsIssuerImage
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class ListMethodsMethodSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListMethodsMethodSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListMethodsMethodDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListMethodsMethodSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListMethodsMethodDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsMethodTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """
    id: ListMethodsID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """
    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: ListMethodsMinimumAmountTypedDict
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: Nullable[ListMethodsMaximumAmountTypedDict]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """
    image: ListMethodsImageTypedDict
    r"""URLs of images representing the payment method."""
    status: ListMethodsStatus
    r"""The payment method's activation status for this profile."""
    links: ListMethodsMethodLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    issuers: NotRequired[List[ListMethodsIssuerTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """


class ListMethodsMethod(BaseModel):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """

    id: ListMethodsID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        ListMethodsMinimumAmount, pydantic.Field(alias="minimumAmount")
    ]
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        Nullable[ListMethodsMaximumAmount], pydantic.Field(alias="maximumAmount")
    ]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    image: ListMethodsImage
    r"""URLs of images representing the payment method."""

    status: ListMethodsStatus
    r"""The payment method's activation status for this profile."""

    links: Annotated[ListMethodsMethodLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    issuers: Optional[List[ListMethodsIssuer]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["issuers"]
        nullable_fields = ["maximumAmount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMethodsEmbeddedTypedDict(TypedDict):
    methods: List[ListMethodsMethodTypedDict]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer
    to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListMethodsEmbedded(BaseModel):
    methods: List[ListMethodsMethod]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer
    to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsLinksTypedDict(TypedDict):
    self_: ListMethodsSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: ListMethodsDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsLinks(BaseModel):
    self_: Annotated[ListMethodsSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: ListMethodsDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsResponseTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set.
    Results are **not** paginated.
    """
    embedded: ListMethodsEmbeddedTypedDict
    links: ListMethodsLinksTypedDict


class ListMethodsResponse(BaseModel):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set.
    Results are **not** paginated.
    """

    embedded: Annotated[ListMethodsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListMethodsLinks, pydantic.Field(alias="_links")]
