"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListBalanceTransactionsRequestTypedDict(TypedDict):
    balance_id: str
    r"""Provide the ID of the related balance."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListBalanceTransactionsRequest(BaseModel):
    balance_id: Annotated[
        str,
        pydantic.Field(alias="balanceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related balance."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TooManyRequestsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class TooManyRequestsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class TooManyRequestsLinksTypedDict(TypedDict):
    documentation: TooManyRequestsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class TooManyRequestsLinks(BaseModel):
    documentation: TooManyRequestsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class TooManyRequestsHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[TooManyRequestsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class TooManyRequestsHalJSONError(ClientError):
    r"""An error response object."""

    data: TooManyRequestsHalJSONErrorData

    def __init__(
        self,
        data: TooManyRequestsHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListBalanceTransactionsNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListBalanceTransactionsNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListBalanceTransactionsNotFoundLinksTypedDict(TypedDict):
    documentation: ListBalanceTransactionsNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsNotFoundLinks(BaseModel):
    documentation: ListBalanceTransactionsNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListBalanceTransactionsNotFoundLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListBalanceTransactionsNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListBalanceTransactionsNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListBalanceTransactionsNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListBalanceTransactionsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListBalanceTransactionsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListBalanceTransactionsBadRequestLinksTypedDict(TypedDict):
    documentation: ListBalanceTransactionsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBadRequestLinks(BaseModel):
    documentation: ListBalanceTransactionsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListBalanceTransactionsBadRequestLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListBalanceTransactionsBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListBalanceTransactionsBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListBalanceTransactionsBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListBalanceTransactionsType(str, Enum):
    r"""The type of transaction, for example `payment` or `refund`. Values include the below examples, although this list
    is not definitive.

    * Regular payment processing: `payment` `capture` `unauthorized-direct-debit` `failed-payment`
    * Refunds and chargebacks: `refund` `returned-refund` `chargeback` `chargeback-reversal`
    * Settlements: `outgoing-transfer` `canceled-outgoing-transfer` `returned-transfer`
    * Invoicing: `invoice-compensation` `balance-correction`
    * Mollie Connect: `application-fee` `split-payment` `platform-payment-refund` `platform-payment-chargeback`
    """

    APPLICATION_FEE = "application-fee"
    CAPTURE = "capture"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    FAILED_PAYMENT_FEE = "failed-payment-fee"
    FAILED_PAYMENT = "failed-payment"
    INVOICE_COMPENSATION = "invoice-compensation"
    PAYMENT = "payment"
    PAYMENT_FEE = "payment-fee"
    PAYMENT_COMMISSION = "payment-commission"
    REFUND = "refund"
    RETURNED_REFUND = "returned-refund"
    RETURNED_TRANSFER = "returned-transfer"
    SPLIT_PAYMENT = "split-payment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    CAPTURE_COMMISSION = "capture-commission"
    CANCELED_OUTGOING_TRANSFER = "canceled-outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    API_PAYMENT_ROLLING_RESERVE_RELEASE = "api-payment-rolling-reserve-release"
    CAPTURE_ROLLING_RESERVE_RELEASE = "capture-rolling-reserve-release"
    REIMBURSEMENT_FEE = "reimbursement-fee"
    BALANCE_CORRECTION = "balance-correction"
    UNAUTHORIZED_DIRECT_DEBIT = "unauthorized-direct-debit"
    BANK_CHARGED_FAILURE_FEE = "bank-charged-failure-fee"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    FAILED_SPLIT_PAYMENT_PLATFORM = "failed-split-payment-platform"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CASH_ADVANCE_LOAN = "cash-advance-loan"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    SPLIT_TRANSACTION = "split-transaction"
    MANAGED_FEE = "managed-fee"
    RETURNED_MANAGED_FEE = "returned-managed-fee"
    TOPUP = "topup"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    MOVEMENT = "movement"
    POST_PAYMENT_SPLIT_PAYMENT = "post-payment-split-payment"
    CASH_COLLATERAL_ISSUANCE = "cash-collateral-issuance"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"


class ResultAmountTypedDict(TypedDict):
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for
    example when it concerns a refund, the amount will be negative.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ResultAmount(BaseModel):
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for
    example when it concerns a refund, the amount will be negative.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class InitialAmountTypedDict(TypedDict):
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away
    from the balance, for example when it concerns a refund, the amount will be negative.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class InitialAmount(BaseModel):
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away
    from the balance, for example when it concerns a refund, the amount will be negative.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DeductionsTypedDict(TypedDict):
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment,
    the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these
    real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class Deductions(BaseModel):
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment,
    the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these
    real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListBalanceTransactionsPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class ListBalanceTransactionsPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class ListBalanceTransactionsCaptureTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class ListBalanceTransactionsCapture(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class CaptureCommisionTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class CaptureCommision(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class CaptureRollingReserveReleaseTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class CaptureRollingReserveRelease(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class UnauthorizedDirectDebitTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class UnauthorizedDirectDebit(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class FailedPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class FailedPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class ListBalanceTransactionsRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ListBalanceTransactionsRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class RefundCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class RefundCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedRefundCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedRefundCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ListBalanceTransactionsChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ListBalanceTransactionsChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ChargebackReversalTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ChargebackReversal(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ChargebackCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ChargebackCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ReversedChargebackCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ReversedChargebackCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class OutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class OutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class CanceledOutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class CanceledOutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class ReturnedTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class ReturnedTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class InvoiceCompensationTypedDict(TypedDict):
    invoice_id: NotRequired[str]


class InvoiceCompensation(BaseModel):
    invoice_id: Annotated[Optional[str], pydantic.Field(alias="invoiceId")] = None


class ListBalanceTransactionsApplicationFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    paying_owner: NotRequired[str]


class ListBalanceTransactionsApplicationFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    paying_owner: Annotated[Optional[str], pydantic.Field(alias="payingOwner")] = None


class SplitPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    payment_onwer: NotRequired[str]


class SplitPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    payment_onwer: Annotated[Optional[str], pydantic.Field(alias="paymentOnwer")] = None


class PlatformPaymentRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class PlatformPaymentRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedPlatformPaymentRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedPlatformPaymentRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class PlatformPaymentChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class PlatformPaymentChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ReversedPlatformPaymentChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ReversedPlatformPaymentChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class PaymentCommissionTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    organization_id: NotRequired[str]


class PaymentCommission(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None


class ReimbursementFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class ReimbursementFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class FailedPaymentFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class FailedPaymentFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class PaymentFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class PaymentFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class ManagedFeeTypedDict(TypedDict):
    fee_type: NotRequired[str]
    fee_id: NotRequired[str]


class ManagedFee(BaseModel):
    fee_type: Annotated[Optional[str], pydantic.Field(alias="feeType")] = None

    fee_id: Annotated[Optional[str], pydantic.Field(alias="feeId")] = None


class ReturnedManagedFeeTypedDict(TypedDict):
    fee_type: NotRequired[str]
    fee_id: NotRequired[str]


class ReturnedManagedFee(BaseModel):
    fee_type: Annotated[Optional[str], pydantic.Field(alias="feeType")] = None

    fee_id: Annotated[Optional[str], pydantic.Field(alias="feeId")] = None


class PostPaymentSplitPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]


class PostPaymentSplitPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None


class ContextTypedDict(TypedDict):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    payment: NotRequired[Nullable[ListBalanceTransactionsPaymentTypedDict]]
    capture: NotRequired[Nullable[ListBalanceTransactionsCaptureTypedDict]]
    capture_commision: NotRequired[Nullable[CaptureCommisionTypedDict]]
    capture_rolling_reserve_release: NotRequired[
        Nullable[CaptureRollingReserveReleaseTypedDict]
    ]
    unauthorized_direct_debit: NotRequired[Nullable[UnauthorizedDirectDebitTypedDict]]
    failed_payment: NotRequired[Nullable[FailedPaymentTypedDict]]
    refund: NotRequired[Nullable[ListBalanceTransactionsRefundTypedDict]]
    refund_compensation: NotRequired[Nullable[RefundCompensationTypedDict]]
    returned_refund: NotRequired[Nullable[ReturnedRefundTypedDict]]
    returned_refund_compensation: NotRequired[
        Nullable[ReturnedRefundCompensationTypedDict]
    ]
    chargeback: NotRequired[Nullable[ListBalanceTransactionsChargebackTypedDict]]
    chargeback_reversal: NotRequired[Nullable[ChargebackReversalTypedDict]]
    chargeback_compensation: NotRequired[Nullable[ChargebackCompensationTypedDict]]
    reversed_chargeback_compensation: NotRequired[
        Nullable[ReversedChargebackCompensationTypedDict]
    ]
    outgoing_transfer: NotRequired[Nullable[OutgoingTransferTypedDict]]
    canceled_outgoing_transfer: NotRequired[Nullable[CanceledOutgoingTransferTypedDict]]
    returned_transfer: NotRequired[Nullable[ReturnedTransferTypedDict]]
    invoice_compensation: NotRequired[Nullable[InvoiceCompensationTypedDict]]
    application_fee: NotRequired[
        Nullable[ListBalanceTransactionsApplicationFeeTypedDict]
    ]
    split_payment: NotRequired[Nullable[SplitPaymentTypedDict]]
    platform_payment_refund: NotRequired[Nullable[PlatformPaymentRefundTypedDict]]
    returned_platform_payment_refund: NotRequired[
        Nullable[ReturnedPlatformPaymentRefundTypedDict]
    ]
    platform_payment_chargeback: NotRequired[
        Nullable[PlatformPaymentChargebackTypedDict]
    ]
    reversed_platform_payment_chargeback: NotRequired[
        Nullable[ReversedPlatformPaymentChargebackTypedDict]
    ]
    payment_commission: NotRequired[Nullable[PaymentCommissionTypedDict]]
    reimbursement_fee: NotRequired[Nullable[ReimbursementFeeTypedDict]]
    failed_payment_fee: NotRequired[Nullable[FailedPaymentFeeTypedDict]]
    payment_fee: NotRequired[Nullable[PaymentFeeTypedDict]]
    managed_fee: NotRequired[Nullable[ManagedFeeTypedDict]]
    returned_managed_fee: NotRequired[Nullable[ReturnedManagedFeeTypedDict]]
    post_payment_split_payment: NotRequired[Nullable[PostPaymentSplitPaymentTypedDict]]


class Context(BaseModel):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    payment: OptionalNullable[ListBalanceTransactionsPayment] = UNSET

    capture: OptionalNullable[ListBalanceTransactionsCapture] = UNSET

    capture_commision: Annotated[
        OptionalNullable[CaptureCommision], pydantic.Field(alias="capture-commision")
    ] = UNSET

    capture_rolling_reserve_release: Annotated[
        OptionalNullable[CaptureRollingReserveRelease],
        pydantic.Field(alias="capture-rolling-reserve-release"),
    ] = UNSET

    unauthorized_direct_debit: Annotated[
        OptionalNullable[UnauthorizedDirectDebit],
        pydantic.Field(alias="unauthorized-direct-debit"),
    ] = UNSET

    failed_payment: Annotated[
        OptionalNullable[FailedPayment], pydantic.Field(alias="failed-payment")
    ] = UNSET

    refund: OptionalNullable[ListBalanceTransactionsRefund] = UNSET

    refund_compensation: Annotated[
        OptionalNullable[RefundCompensation],
        pydantic.Field(alias="refund-compensation"),
    ] = UNSET

    returned_refund: Annotated[
        OptionalNullable[ReturnedRefund], pydantic.Field(alias="returned-refund")
    ] = UNSET

    returned_refund_compensation: Annotated[
        OptionalNullable[ReturnedRefundCompensation],
        pydantic.Field(alias="returned-refund-compensation"),
    ] = UNSET

    chargeback: OptionalNullable[ListBalanceTransactionsChargeback] = UNSET

    chargeback_reversal: Annotated[
        OptionalNullable[ChargebackReversal],
        pydantic.Field(alias="chargeback-reversal"),
    ] = UNSET

    chargeback_compensation: Annotated[
        OptionalNullable[ChargebackCompensation],
        pydantic.Field(alias="chargeback-compensation"),
    ] = UNSET

    reversed_chargeback_compensation: Annotated[
        OptionalNullable[ReversedChargebackCompensation],
        pydantic.Field(alias="reversed-chargeback-compensation"),
    ] = UNSET

    outgoing_transfer: Annotated[
        OptionalNullable[OutgoingTransfer], pydantic.Field(alias="outgoing-transfer")
    ] = UNSET

    canceled_outgoing_transfer: Annotated[
        OptionalNullable[CanceledOutgoingTransfer],
        pydantic.Field(alias="canceled-outgoing-transfer"),
    ] = UNSET

    returned_transfer: Annotated[
        OptionalNullable[ReturnedTransfer], pydantic.Field(alias="returned-transfer")
    ] = UNSET

    invoice_compensation: Annotated[
        OptionalNullable[InvoiceCompensation],
        pydantic.Field(alias="invoice-compensation"),
    ] = UNSET

    application_fee: Annotated[
        OptionalNullable[ListBalanceTransactionsApplicationFee],
        pydantic.Field(alias="application-fee"),
    ] = UNSET

    split_payment: Annotated[
        OptionalNullable[SplitPayment], pydantic.Field(alias="split-payment")
    ] = UNSET

    platform_payment_refund: Annotated[
        OptionalNullable[PlatformPaymentRefund],
        pydantic.Field(alias="platform-payment-refund"),
    ] = UNSET

    returned_platform_payment_refund: Annotated[
        OptionalNullable[ReturnedPlatformPaymentRefund],
        pydantic.Field(alias="returned-platform-payment-refund"),
    ] = UNSET

    platform_payment_chargeback: Annotated[
        OptionalNullable[PlatformPaymentChargeback],
        pydantic.Field(alias="platform-payment-chargeback"),
    ] = UNSET

    reversed_platform_payment_chargeback: Annotated[
        OptionalNullable[ReversedPlatformPaymentChargeback],
        pydantic.Field(alias="reversed-platform-payment-chargeback"),
    ] = UNSET

    payment_commission: Annotated[
        OptionalNullable[PaymentCommission], pydantic.Field(alias="payment-commission")
    ] = UNSET

    reimbursement_fee: Annotated[
        OptionalNullable[ReimbursementFee], pydantic.Field(alias="reimbursement-fee")
    ] = UNSET

    failed_payment_fee: Annotated[
        OptionalNullable[FailedPaymentFee], pydantic.Field(alias="failed-payment-fee")
    ] = UNSET

    payment_fee: Annotated[
        OptionalNullable[PaymentFee], pydantic.Field(alias="payment-fee")
    ] = UNSET

    managed_fee: Annotated[
        OptionalNullable[ManagedFee], pydantic.Field(alias="managed-fee")
    ] = UNSET

    returned_managed_fee: Annotated[
        OptionalNullable[ReturnedManagedFee],
        pydantic.Field(alias="returned-managed-fee"),
    ] = UNSET

    post_payment_split_payment: Annotated[
        OptionalNullable[PostPaymentSplitPayment],
        pydantic.Field(alias="post-payment-split-payment"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "payment",
            "capture",
            "capture-commision",
            "capture-rolling-reserve-release",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "refund-compensation",
            "returned-refund",
            "returned-refund-compensation",
            "chargeback",
            "chargeback-reversal",
            "chargeback-compensation",
            "reversed-chargeback-compensation",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "returned-platform-payment-refund",
            "platform-payment-chargeback",
            "reversed-platform-payment-chargeback",
            "payment-commission",
            "reimbursement-fee",
            "failed-payment-fee",
            "payment-fee",
            "managed-fee",
            "returned-managed-fee",
            "post-payment-split-payment",
        ]
        nullable_fields = [
            "payment",
            "capture",
            "capture-commision",
            "capture-rolling-reserve-release",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "refund-compensation",
            "returned-refund",
            "returned-refund-compensation",
            "chargeback",
            "chargeback-reversal",
            "chargeback-compensation",
            "reversed-chargeback-compensation",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "returned-platform-payment-refund",
            "platform-payment-chargeback",
            "reversed-platform-payment-chargeback",
            "payment-commission",
            "reimbursement-fee",
            "failed-payment-fee",
            "payment-fee",
            "managed-fee",
            "returned-managed-fee",
            "post-payment-split-payment",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BalanceTransactionTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance-transaction`
    for this endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this balance transaction."""
    type: NotRequired[ListBalanceTransactionsType]
    r"""The type of transaction, for example `payment` or `refund`. Values include the below examples, although this list
    is not definitive.

    * Regular payment processing: `payment` `capture` `unauthorized-direct-debit` `failed-payment`
    * Refunds and chargebacks: `refund` `returned-refund` `chargeback` `chargeback-reversal`
    * Settlements: `outgoing-transfer` `canceled-outgoing-transfer` `returned-transfer`
    * Invoicing: `invoice-compensation` `balance-correction`
    * Mollie Connect: `application-fee` `split-payment` `platform-payment-refund` `platform-payment-chargeback`
    """
    result_amount: NotRequired[ResultAmountTypedDict]
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for
    example when it concerns a refund, the amount will be negative.
    """
    initial_amount: NotRequired[InitialAmountTypedDict]
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away
    from the balance, for example when it concerns a refund, the amount will be negative.
    """
    deductions: NotRequired[Nullable[DeductionsTypedDict]]
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment,
    the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these
    real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """
    context: NotRequired[ContextTypedDict]
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class BalanceTransaction(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance-transaction`
    for this endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this balance transaction."""

    type: Optional[ListBalanceTransactionsType] = None
    r"""The type of transaction, for example `payment` or `refund`. Values include the below examples, although this list
    is not definitive.

    * Regular payment processing: `payment` `capture` `unauthorized-direct-debit` `failed-payment`
    * Refunds and chargebacks: `refund` `returned-refund` `chargeback` `chargeback-reversal`
    * Settlements: `outgoing-transfer` `canceled-outgoing-transfer` `returned-transfer`
    * Invoicing: `invoice-compensation` `balance-correction`
    * Mollie Connect: `application-fee` `split-payment` `platform-payment-refund` `platform-payment-chargeback`
    """

    result_amount: Annotated[
        Optional[ResultAmount], pydantic.Field(alias="resultAmount")
    ] = None
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for
    example when it concerns a refund, the amount will be negative.
    """

    initial_amount: Annotated[
        Optional[InitialAmount], pydantic.Field(alias="initialAmount")
    ] = None
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away
    from the balance, for example when it concerns a refund, the amount will be negative.
    """

    deductions: OptionalNullable[Deductions] = UNSET
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment,
    the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these
    real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    context: Optional[Context] = None
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "type",
            "resultAmount",
            "initialAmount",
            "deductions",
            "context",
            "createdAt",
        ]
        nullable_fields = ["deductions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListBalanceTransactionsEmbeddedTypedDict(TypedDict):
    balance_transactions: NotRequired[List[BalanceTransactionTypedDict]]
    r"""An array of balance transaction objects."""


class ListBalanceTransactionsEmbedded(BaseModel):
    balance_transactions: Optional[List[BalanceTransaction]] = None
    r"""An array of balance transaction objects."""


class ListBalanceTransactionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListBalanceTransactionsSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListBalanceTransactionsPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListBalanceTransactionsNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListBalanceTransactionsDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListBalanceTransactionsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListBalanceTransactionsSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListBalanceTransactionsPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListBalanceTransactionsNext]
    r"""The next set of items, if available."""

    documentation: ListBalanceTransactionsDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListBalanceTransactionsResponseTypedDict(TypedDict):
    r"""A list of balance transaction objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListBalanceTransactionsEmbeddedTypedDict]
    links: NotRequired[ListBalanceTransactionsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListBalanceTransactionsResponse(BaseModel):
    r"""A list of balance transaction objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListBalanceTransactionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListBalanceTransactionsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
