# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/04_wandb_viz.ipynb (unless otherwise specified).

__all__ = ['log_images']

# Cell
import os
import wandb
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

# Cell
def log_images(
    images:list, # List of image array/PIL Images or image files to log.
    log_as_sequence:bool=False,):
    '''
    Log images to wandb. You can pass in list of images as ndarray, PIL Image, or filepath.

    #### Examples
    --------
    **Log images as sequence**
    log_images(images=["image1.png", "image2.png"], log_as_sequence=True)
    log_images(images=[image1, image2], log_as_sequence=True)


    **Log images as grid**
    log_images(images=["image1.png", "image2.png", "image3.png"], log_as_sequence=False)
    log_images(images=[image1.png, image2.png, image3], log_as_sequence=False)
    '''

    if log_as_sequence: # The images are logged with a *slider*. Ideal for visualizing sequences.
        for image in images:
            wandb.log({"image": wandb.Image(image)})
    else: # The images are logged as grid. Ideal for visualizing single images.
        wandb.log({"image" : [wandb.Image(image) for image in images]})