# mypy-boto3-iot1click-devices

[![PyPI - mypy-boto3-iot1click-devices](https://img.shields.io/pypi/v/mypy-boto3-iot1click-devices.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-devices)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iot1click-devices.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-devices)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoT1ClickDevicesService 1.14.16](https://boto3.amazonaws.com/v1/documentation/api/1.14.16/reference/services/iot1click-devices.html#IoT1ClickDevicesService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `IoT1ClickDevicesService` service.

```bash
python -m pip install boto3-stubs[iot1click-devices]
```

## How to use

### Client annotations

`IoT1ClickDevicesServiceClient` provides annotations for `boto3.client("iot1click-devices")`.

```python
import boto3

from mypy_boto3_iot1click_devices import IoT1ClickDevicesServiceClient
from mypy_boto3_iot1click_devices.paginator import ListDeviceEventsPaginator, ListDevicesPaginator
from mypy_boto3_iot1click_devices.type_defs import DeviceDescriptionTypeDef, ...

client: IoT1ClickDevicesServiceClient = boto3.client("iot1click-devices")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoT1ClickDevicesServiceClient = session.client("iot1click-devices")
```

### Paginators annotations

`mypy_boto3_iot1click_devices.paginator` module contains type annotations for all paginators.

```python

client: IoT1ClickDevicesServiceClient = boto3.client("iot1click-devices")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_device_events_paginator: ListDeviceEventsPaginator = client.get_paginator("list_device_events")
list_devices_paginator: ListDevicesPaginator = client.get_paginator("list_devices")
```







### Typed dictionations

`mypy_boto3_iot1click_devices.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> DeviceDescriptionTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_iot1click_devices` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("iot1click-devices")

session_client = boto3.Session().client("iot1click-devices")
```
