/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class PointRoi
extends PolygonRoi {
    public static final String[] sizes = new String[]{"Tiny", "Small", "Mediam", "Large"};
    private static final String SIZE_KEY = "point.size";
    private static final String CROSS_COLOR_KEY = "point.cross.color";
    private static final int TINY = 1;
    private static final int SMALL = 3;
    private static final int MEDIAM = 5;
    private static final int LARGE = 7;
    private static int markerSize = 3;
    private static Font font;
    private static Color defaultCrossColor;
    private static int fontSize;
    private double saveMag;
    private boolean hideLabels;

    public PointRoi(int[] ox, int[] oy, int points) {
        super(PointRoi.itof(ox), PointRoi.itof(oy), points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy) {
        this(ox, oy, ox.length);
    }

    public PointRoi(FloatPolygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public PointRoi(Polygon poly) {
        this(PointRoi.itof(poly.xpoints), PointRoi.itof(poly.ypoints), poly.npoints);
    }

    public PointRoi(int ox, int oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(double ox, double oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        if (imp != null) {
            imp.draw(this.x - 10, this.y - 10, 20, 20);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static float[] itof(int[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] temp = new float[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = arr[i];
        }
        return temp;
    }

    static float[] makeXArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenXD((int)value) : value)};
        return array;
    }

    static float[] makeYArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenYD((int)value) : value)};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    public void draw(Graphics g) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            fontSize = 9;
            if (this.mag > 1.0) {
                fontSize = (int)(((this.mag - 1.0) / 3.0 + 1.0) * 9.0);
            }
            if (fontSize > 18) {
                fontSize = 18;
            }
            if (font == null || this.mag != this.saveMag) {
                font = new Font("SansSerif", 0, fontSize);
            }
            g.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(g, true);
            }
            this.saveMag = this.mag;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.drawPoint(g, this.xp2[i], this.yp2[i], i + 1);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics g, int x, int y, int n) {
        Color cc = this.fillColor != null ? this.fillColor : defaultCrossColor;
        int size = markerSize;
        int size2 = size / 2;
        if (cc != null) {
            g.setColor(cc);
            g.drawLine(x - (size + 2), y, x + size + 2, y);
            g.drawLine(x, y - (size + 2), x, y + size + 2);
        }
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        g.fillRect(x - size2, y - size2, size, size);
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            g.drawString("" + n, x + 4, y + fontSize + 2);
        }
        if (markerSize > 1) {
            g.setColor(Color.black);
            g.drawOval(x - (size2 + 1), y - (size2 + 1), size + 1, size + 1);
        }
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        for (int i = 0; i < this.nPoints; ++i) {
            ip.moveTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
            ip.lineTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
        }
    }

    public PointRoi addPoint(double x, double y) {
        FloatPolygon poly = this.getFloatPolygon();
        poly.addPoint(x, y);
        PointRoi p = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        p.setHideLabels(this.hideLabels);
        IJ.showStatus("count=" + poly.npoints);
        p.setStrokeColor(this.getStrokeColor());
        p.setFillColor(this.getFillColor());
        return p;
    }

    public PointRoi addPoint(int x, int y) {
        return this.addPoint((double)x, (double)y);
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        for (int i = 0; i < points.npoints; ++i) {
            if (poly.contains(points.xpoints[i], points.ypoints[i])) continue;
            points2.addPoint(points.xpoints[i], points.ypoints[i]);
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        for (int i = 0; i < this.nPoints; ++i) {
            ((ImageProcessor)mask).putPixel((int)this.xpf[i], (int)this.ypf[i], 255);
        }
        this.cachedMask = mask;
        return mask;
    }

    public boolean contains(int x, int y) {
        for (int i = 0; i < this.nPoints; ++i) {
            if ((float)x != (float)this.x + this.xpf[i] || (float)y != (float)this.y + this.ypf[i]) continue;
            return true;
        }
        return false;
    }

    public void setHideLabels(boolean hideLabels) {
        this.hideLabels = hideLabels;
    }

    public static void setDefaultMarkerSize(String size) {
        boolean set = false;
        if (sizes[0].equals(size)) {
            markerSize = 1;
            set = true;
        } else if (sizes[1].equals(size)) {
            markerSize = 3;
            set = true;
        } else if (sizes[2].equals(size)) {
            markerSize = 5;
            set = true;
        } else if (sizes[3].equals(size)) {
            markerSize = 7;
            set = true;
        }
        if (set) {
            Prefs.set(SIZE_KEY, size);
        }
    }

    public static String getDefaultMarkerSize() {
        switch (markerSize) {
            case 1: {
                return sizes[0];
            }
            case 3: {
                return sizes[1];
            }
            case 5: {
                return sizes[2];
            }
            case 7: {
                return sizes[3];
            }
        }
        return null;
    }

    public static void setDefaultCrossColor(Color color) {
        if (defaultCrossColor != color) {
            Prefs.set(CROSS_COLOR_KEY, Colors.getColorName(color, "None"));
        }
        defaultCrossColor = color;
    }

    public static Color getDefaultCrossColor() {
        return defaultCrossColor;
    }

    public boolean subPixelResolution() {
        return true;
    }

    public String toString() {
        if (this.nPoints > 1) {
            return "Roi[Points, count=" + this.nPoints + "]";
        }
        return "Roi[Point, x=" + this.x + ", y=" + this.y + "]";
    }

    static {
        defaultCrossColor = Color.white;
        fontSize = 9;
        PointRoi.setDefaultMarkerSize(Prefs.get(SIZE_KEY, sizes[1]));
        PointRoi.setDefaultCrossColor(Colors.getColor(Prefs.get(CROSS_COLOR_KEY, "white"), null));
    }
}

