# Python Motor Driver for Mini Cheetah Actuator: T-Motor AK80-6

This driver was developed at Robotics Innovation Center at DFKI GmbH, Bremen.

It assumes the use of PEAK System's PCAN-USB adapter connected to a linux (tested on Ubuntu) computer. The SocketCAN inteface is used, thus allowing the use of Python Socket library.

# Dependencies:

* bitstring

Install via:

`pip3 install bitstring`

# Documentation

- Useful videos: 
    - [From T-Motor](https://www.youtube.com/watch?v=hbqQCgebaF8)
    - [From Skyentific](https://www.youtube.com/watch?v=HzY9vzgPZkA)
- [Datasheet](https://store-en.tmotor.com/goods.php?id=981)
- [Documentation from Ben Katz](https://docs.google.com/document/d/1dzNVzblz6mqB3eZVEMyi2MtSngALHdgpTaDJIW_BpS4/edit)

# Pre-requisites:

* Setting up the CAN interface:

  * Run this command and make sure that `can0` (or any other can interface depending on the system)shows up as an interface after connecting the USB cable to your laptop: `ip link show`

  * Configure the `can0` interface to have a 1 Mbaud communication frequency: `sudo ip link set can0 type can bitrate 1000000`

  * To bring up the `can0` interface, run: `sudo ip link set up can0`

* To change motor parameters such as CAN ID or to calibrate the encoder, a serial connection is used. The serial terminal that can be used on linux for this purpose is `cutecom`.

# Usage:

Import: `from motor_driver.canmotorlib import CanMotorController`

Example Motor Initialization: `motor = CanMotorController(can_socket='can0', motor_id=0x01, socket_timeout=0.5)`

Available Functions:

- `enable_motor()`
- `disable_motor()`
- `set_zero_position()`
- `send_deg_command(position_in_degrees, velocity_in_degrees, Kp, Kd, tau_ff):`
- `send_rad_command(position_in_radians, velocity_in_radians, Kp, Kd, tau_ff):`
- `change_motor_constants(P_MIN_NEW, P_MAX_NEW, V_MIN_NEW, V_MAX_NEW, KP_MIN_NEW, KP_MAX_NEW, KD_MIN_NEW, KD_MAX_NEW, T_MIN_NEW, T_MAX_NEW)`

All functions return current position, velocity, torque in SI units except for `send_deg_command`. `change_motor_constants` does not return anything.
