import unittest
import numpy as np
# noinspection PyProtectedMember
from flowkit import _utils

fcs_spill = '13,B515-A,R780-A,R710-A,R660-A,V800-A,V655-A,V585-A,V450-A,G780-A,G710-A,G660-A,G610-A,G560-A,'\
    '1,0,0,0.00008841570561316703,0.0002494559842740046,0.0006451591561972469,0.007198401782797728,0,0,'\
    '0.00013132619816952714,0.0000665251222573374,0.0005815839652764308,0.0025201730479353047,0,1,'\
    '0.07118758880093266,0.14844804153215532,0.3389031912802132,0.00971660311243448,0,0,0.3013801753249257,'\
    '0.007477611134717788,0.0123543122066652,0,0,0,0.33140488468849205,1,0.0619647566095391,0.12097867005182314,'\
    '0.004052554840959644,0,0,0.1091165124197372,0.10031383324016652,0.005831773047424356,0,0,0,'\
    '0.08862108746390694,0.38942413967608824,1,0.029758767352535288,0.06555281586224636,0,0,0.03129393154653089,'\
    '0.039305936245674286,0.09137451237674046,0.00039591122341817164,0.000056659766405160846,0,'\
    '0.13661791418865094,0.010757316236957385,0,1,0.00015647113960278087,0,0,0.48323487842103036,'\
    '0.01485813345103798,0,0,0,0,0.00012365104122837034,0.019462610460087203,0.2182062762553545,'\
    '0.004953221988365214,1,0.003582785726251024,0,0.0013106968243292993,0.029645575685206288,0.4089015923558522,'\
    '0.006505826616588717,0.00011917703878954761,0,0,0,0,0.001055595075733903,0.002287122431059274,1,0,'\
    '0.0003885172922042414,0.0001942589956485108,0,0.06255131165904257,0.13248446095817049,0,0,0,0,0,'\
    '0.008117870042687002,0.17006643956891296,1,0,0,0,0,0,0.003122390646560834,0.008525685683831916,'\
    '0.001024237027323255,0.0011626412849951272,0.12540105131097395,0.018142202256893485,0.19364562239714117,'\
    '0,1,0.06689784643460173,0.16145640353506588,0.2868231743828476,1.2380368696528024,0.002015498041918758,'\
    '0.06964529385206036,0.19471548842271394,0.0010077719457714136,0.15161117217667686,0.0012703511702660231,'\
    '0.007133491446011225,0,1.1500323358669722,1,0.016076827046672983,0.014674146885307975,0.055351746085494,'\
    '0.001685226072130514,0.05433993817875603,0.27785224557295884,0.34300826602551504,0.06175281041168121,'\
    '0.07752283973796613,0.0042628794531131406,0,0.49748791920091034,0.7439226300384197,1,0.010329232815907474,'\
    '0.03763461149817695,0,0.008713148000954844,0.04821275078920058,0.07319044343609345,0.1505631929508567,'\
    '0.3862934410767249,0.10189631814602482,0,0.3702770755789083,0.6134900271606913,1.2180240147472128,1,'\
    '0.06521131251063482,0.0016842378874079343,0,0,0.00009533732312150527,0.0034630076700367675,'\
    '0.01571183587491517,0.17412189188164517,0,0.023802192010810994,0.049474451704249904,0.13251071256825273,'\
    '0.23921555785727822,1'

fcs_spill_header = [
    'B515-A', 'R780-A', 'R710-A', 'R660-A',
    'V800-A', 'V655-A', 'V585-A', 'V450-A',
    'G780-A', 'G710-A', 'G660-A', 'G610-A',
    'G560-A'
]


class MatrixTestCase(unittest.TestCase):
    """Tests related to compensation matrices and the Matrix class"""
    def test_parse_fcs_spill_value(self):
        matrix_array = _utils.parse_compensation_matrix(fcs_spill, fcs_spill_header)

        self.assertIsInstance(matrix_array, np.ndarray)
