# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from sys import stderr
from msrest.service_client import ServiceClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class AccountConfiguration(Configuration):
    """Configuration for Account
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param api_version: Version of the API to use.  This should be set to
     '3.2-preview' to use this version of the api.
    :type api_version: str
    :param str base_url: Service URL
    """

    def __init__(
            self, api_version, base_url=None):

        if api_version is None:
            raise ValueError("Parameter 'api_version' must not be None.")
        if not isinstance(api_version, str):
            raise TypeError("Parameter 'api_version' must be str.")
        if not base_url:
            base_url = 'https://fabrikam-fiber-inc.visualstudio.com/'

        super(AccountConfiguration, self).__init__(base_url)

        self.add_user_agent('account/{}'.format(VERSION))

        self.api_version = api_version


class Account(object):
    """Account

    :ivar config: Configuration for client.
    :vartype config: AccountConfiguration

    :param api_version: Version of the API to use.  This should be set to
     '3.2-preview' to use this version of the api.
    :type api_version: str
    :param str base_url: Service URL
    """

    def __init__(
            self, api_version, base_url=None, creds=None):

        self.config = AccountConfiguration(api_version, base_url)
        self._client = ServiceClient(creds, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '3.2' if not api_version else api_version
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def is_valid_account_name(
            self, account_name, custom_headers=None, raw=False, **operation_config):
        """IsValidAccountName.

        :param account_name:
        :type account_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AccountNameAvailability
         <vsts.accounts.models.AccountNameAvailability>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/account/availability/{accountName}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            print("GET", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AccountNameAvailability', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_regions(
            self, custom_headers=None, raw=False, **operation_config):
        """GetRegions.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`AccountRegion
         <vsts.accounts.models.AccountRegion>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/account/regions'

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            print("GET", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AccountRegion]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_account_settings(
            self, custom_headers=None, raw=False, **operation_config):
        """GetAccountSettings.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: dict
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/account/settings'

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            print("GET", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('{str}', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def create_account(
            self, body, use_precreated=None, custom_headers=None, raw=False, **operation_config):
        """CreateAccount.

        :param body:
        :type body: :class:`AccountCreateInfoInternal
         <vsts.accounts.models.AccountCreateInfoInternal>`
        :param use_precreated:
        :type use_precreated: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AccountModel <vsts.accounts.models.AccountModel>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/accounts'

        # Construct parameters
        query_parameters = {}
        if use_precreated is not None:
            query_parameters['usePrecreated'] = self._serialize.query("use_precreated", use_precreated, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'AccountCreateInfoInternal')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code == 409:
            # Return none to let the caller know that an account already exists with that name
            return None

        if response.status_code not in [200]:
            print("POST", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AccountModel', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_accounts(
            self, owner_id=None, member_id=None, properties=None, custom_headers=None, raw=False, **operation_config):
        """GetAccounts.

        A new version GetAccounts API. Only supports limited set of parameters,
        returns a list of account ref objects that only contains AccountUrl,
        AccountName and AccountId information, will use collection host Id as
        the AccountId.

        :param owner_id: Owner Id to query for
        :type owner_id: str
        :param member_id: Member Id to query for
        :type member_id: str
        :param properties: Only support service URL properties
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`AccountModel
         <vsts.accounts.models.AccountModel>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/accounts'

        # Construct parameters
        query_parameters = {}
        if owner_id is not None:
            query_parameters['ownerId'] = self._serialize.query("owner_id", owner_id, 'str')
        if member_id is not None:
            query_parameters['memberId'] = self._serialize.query("member_id", member_id, 'str')
        if properties is not None:
            query_parameters['properties'] = self._serialize.query("properties", properties, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            print("GET", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AccountModel]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_account(
            self, account_id, properties=None, custom_headers=None, raw=False, **operation_config):
        """GetAccount.

        :param account_id:
        :type account_id: str
        :param properties:
        :type properties: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AccountModel <vsts.accounts.models.AccountModel>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = '/_apis/accounts/{accountId}'
        path_format_arguments = {
            'accountId': self._serialize.url("account_id", account_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if properties is not None:
            query_parameters['properties'] = self._serialize.query("properties", properties, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            print("GET", request.url, file=stderr)
            print("response:", response.status_code, file=stderr)
            print(response.text, file=stderr)
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AccountModel', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
