import pandas as pd

def sheet_by_name(book, sheet_name):
    if sheet_name not in [sheet.name for sheet in book.sheets]:
        sheet = book.sheets.add(sheet_name)
    else:
        sheet = book.sheets[sheet_name]

    return sheet


def get_config(book):
    sheet = sheet_by_name(book, 'Config')

    config = {}

    data = sheet.range("A1").expand().value

    for entry in data:
        key, value = entry[0], entry[1]

        config[str(key).lower()] = str(value)

    return config

def fill_sheet_and_result_json(book, sheet_name: str, df: pd.DataFrame):
    report_sheet = sheet_by_name(book, sheet_name)

    report_cell = report_sheet["A1"]
    report_cell.expand().clear_contents()
    report_cell.options(index=False).value = df
    report_cell.offset(row_offset=1).columns.autofit()

    book_json = book.json()
    
    return book_json

def fill_report_sheet_and_result_json(book, df: pd.DataFrame):
    book_config = get_config(book)
    
    return fill_sheet_and_result_json(book, book_config['sheet'], df)