import { Construct } from '@aws-cdk/core';
import { IAlarm } from './alarm-base';
/**
 * Interface for objects that can be the targets of CloudWatch alarm actions.
 *
 * @stability stable
 */
export interface IAlarmAction {
    /**
     * Return the properties required to send alarm actions to this CloudWatch alarm.
     *
     * @param scope root Construct that allows creating new Constructs.
     * @param alarm CloudWatch alarm that the action will target.
     * @stability stable
     */
    bind(scope: Construct, alarm: IAlarm): AlarmActionConfig;
}
/**
 * Properties for an alarm action.
 *
 * @stability stable
 */
export interface AlarmActionConfig {
    /**
     * Return the ARN that should be used for a CloudWatch Alarm action.
     *
     * @stability stable
     */
    readonly alarmActionArn: string;
}
