# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-01-10 10:16
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import questionnaire_core.fields

try:
    # there is no difference in the (postgres) schema, so we can easily swap between the two
    from django.db.models import JSONField
except ImportError:
    from django.contrib.postgres.fields.jsonb import JSONField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AnswerFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('file', questionnaire_core.fields.DynamicStorageFileField()),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('question_text', models.CharField(max_length=5000)),
                ('question_type', questionnaire_core.fields.QuestionTypeField(max_length=32)),
                ('question_options', JSONField(blank=True, default=dict)),
                ('required', models.BooleanField(default=True)),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='QuestionAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('answer_data', JSONField(db_index=True, null=True)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='questionnaire_core.Question')),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Questionnaire',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='QuestionnaireResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('result_meta', JSONField(default=dict, help_text='Optional JSON field for application specific meta data')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('questionnaire', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaire_core.Questionnaire')),
            ],
        ),
        migrations.AddField(
            model_name='questionanswer',
            name='result_set',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='questionnaire_core.QuestionnaireResult'),
        ),
        migrations.AddField(
            model_name='question',
            name='questionnaire',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='questionnaire_core.Questionnaire'),
        ),
        migrations.AddField(
            model_name='answerfile',
            name='answer',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='file_upload', to='questionnaire_core.QuestionAnswer'),
        ),
    ]
