/* Copyright 2020 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_METADATASCHEMA_TFLITE_H_
#define FLATBUFFERS_GENERATED_METADATASCHEMA_TFLITE_H_

#include "flatbuffers/flatbuffers.h"

namespace tflite {

struct AssociatedFile;
struct AssociatedFileT;

struct FeatureProperties;
struct FeaturePropertiesT;

struct ImageSize;
struct ImageSizeT;

struct ImageProperties;
struct ImagePropertiesT;

struct BoundingBoxProperties;
struct BoundingBoxPropertiesT;

struct ValueRange;
struct ValueRangeT;

struct Content;
struct ContentT;

struct NormalizationOptions;
struct NormalizationOptionsT;

struct ScoreCalibrationOptions;
struct ScoreCalibrationOptionsT;

struct ScoreThresholdingOptions;
struct ScoreThresholdingOptionsT;

struct ProcessUnit;
struct ProcessUnitT;

struct Stats;
struct StatsT;

struct TensorMetadata;
struct TensorMetadataT;

struct SubGraphMetadata;
struct SubGraphMetadataT;

struct ModelMetadata;
struct ModelMetadataT;

enum AssociatedFileType {
  AssociatedFileType_UNKNOWN = 0,
  AssociatedFileType_DESCRIPTIONS = 1,
  AssociatedFileType_TENSOR_AXIS_LABELS = 2,
  AssociatedFileType_TENSOR_VALUE_LABELS = 3,
  AssociatedFileType_TENSOR_AXIS_SCORE_CALIBRATION = 4,
  AssociatedFileType_MIN = AssociatedFileType_UNKNOWN,
  AssociatedFileType_MAX = AssociatedFileType_TENSOR_AXIS_SCORE_CALIBRATION
};

inline const AssociatedFileType (&EnumValuesAssociatedFileType())[5] {
  static const AssociatedFileType values[] = {
    AssociatedFileType_UNKNOWN,
    AssociatedFileType_DESCRIPTIONS,
    AssociatedFileType_TENSOR_AXIS_LABELS,
    AssociatedFileType_TENSOR_VALUE_LABELS,
    AssociatedFileType_TENSOR_AXIS_SCORE_CALIBRATION
  };
  return values;
}

inline const char * const *EnumNamesAssociatedFileType() {
  static const char * const names[] = {
    "UNKNOWN",
    "DESCRIPTIONS",
    "TENSOR_AXIS_LABELS",
    "TENSOR_VALUE_LABELS",
    "TENSOR_AXIS_SCORE_CALIBRATION",
    nullptr
  };
  return names;
}

inline const char *EnumNameAssociatedFileType(AssociatedFileType e) {
  if (e < AssociatedFileType_UNKNOWN || e > AssociatedFileType_TENSOR_AXIS_SCORE_CALIBRATION) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesAssociatedFileType()[index];
}

enum ColorSpaceType {
  ColorSpaceType_UNKNOWN = 0,
  ColorSpaceType_RGB = 1,
  ColorSpaceType_GRAYSCALE = 2,
  ColorSpaceType_MIN = ColorSpaceType_UNKNOWN,
  ColorSpaceType_MAX = ColorSpaceType_GRAYSCALE
};

inline const ColorSpaceType (&EnumValuesColorSpaceType())[3] {
  static const ColorSpaceType values[] = {
    ColorSpaceType_UNKNOWN,
    ColorSpaceType_RGB,
    ColorSpaceType_GRAYSCALE
  };
  return values;
}

inline const char * const *EnumNamesColorSpaceType() {
  static const char * const names[] = {
    "UNKNOWN",
    "RGB",
    "GRAYSCALE",
    nullptr
  };
  return names;
}

inline const char *EnumNameColorSpaceType(ColorSpaceType e) {
  if (e < ColorSpaceType_UNKNOWN || e > ColorSpaceType_GRAYSCALE) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesColorSpaceType()[index];
}

enum BoundingBoxType {
  BoundingBoxType_UNKNOWN = 0,
  BoundingBoxType_BOUNDARIES = 1,
  BoundingBoxType_UPPER_LEFT = 2,
  BoundingBoxType_CENTER = 3,
  BoundingBoxType_MIN = BoundingBoxType_UNKNOWN,
  BoundingBoxType_MAX = BoundingBoxType_CENTER
};

inline const BoundingBoxType (&EnumValuesBoundingBoxType())[4] {
  static const BoundingBoxType values[] = {
    BoundingBoxType_UNKNOWN,
    BoundingBoxType_BOUNDARIES,
    BoundingBoxType_UPPER_LEFT,
    BoundingBoxType_CENTER
  };
  return values;
}

inline const char * const *EnumNamesBoundingBoxType() {
  static const char * const names[] = {
    "UNKNOWN",
    "BOUNDARIES",
    "UPPER_LEFT",
    "CENTER",
    nullptr
  };
  return names;
}

inline const char *EnumNameBoundingBoxType(BoundingBoxType e) {
  if (e < BoundingBoxType_UNKNOWN || e > BoundingBoxType_CENTER) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesBoundingBoxType()[index];
}

enum CoordinateType {
  CoordinateType_RATIO = 0,
  CoordinateType_PIXEL = 1,
  CoordinateType_MIN = CoordinateType_RATIO,
  CoordinateType_MAX = CoordinateType_PIXEL
};

inline const CoordinateType (&EnumValuesCoordinateType())[2] {
  static const CoordinateType values[] = {
    CoordinateType_RATIO,
    CoordinateType_PIXEL
  };
  return values;
}

inline const char * const *EnumNamesCoordinateType() {
  static const char * const names[] = {
    "RATIO",
    "PIXEL",
    nullptr
  };
  return names;
}

inline const char *EnumNameCoordinateType(CoordinateType e) {
  if (e < CoordinateType_RATIO || e > CoordinateType_PIXEL) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCoordinateType()[index];
}

enum ContentProperties {
  ContentProperties_NONE = 0,
  ContentProperties_FeatureProperties = 1,
  ContentProperties_ImageProperties = 2,
  ContentProperties_BoundingBoxProperties = 3,
  ContentProperties_MIN = ContentProperties_NONE,
  ContentProperties_MAX = ContentProperties_BoundingBoxProperties
};

inline const ContentProperties (&EnumValuesContentProperties())[4] {
  static const ContentProperties values[] = {
    ContentProperties_NONE,
    ContentProperties_FeatureProperties,
    ContentProperties_ImageProperties,
    ContentProperties_BoundingBoxProperties
  };
  return values;
}

inline const char * const *EnumNamesContentProperties() {
  static const char * const names[] = {
    "NONE",
    "FeatureProperties",
    "ImageProperties",
    "BoundingBoxProperties",
    nullptr
  };
  return names;
}

inline const char *EnumNameContentProperties(ContentProperties e) {
  if (e < ContentProperties_NONE || e > ContentProperties_BoundingBoxProperties) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesContentProperties()[index];
}

template<typename T> struct ContentPropertiesTraits {
  static const ContentProperties enum_value = ContentProperties_NONE;
};

template<> struct ContentPropertiesTraits<FeatureProperties> {
  static const ContentProperties enum_value = ContentProperties_FeatureProperties;
};

template<> struct ContentPropertiesTraits<ImageProperties> {
  static const ContentProperties enum_value = ContentProperties_ImageProperties;
};

template<> struct ContentPropertiesTraits<BoundingBoxProperties> {
  static const ContentProperties enum_value = ContentProperties_BoundingBoxProperties;
};

struct ContentPropertiesUnion {
  ContentProperties type;
  void *value;

  ContentPropertiesUnion() : type(ContentProperties_NONE), value(nullptr) {}
  ContentPropertiesUnion(ContentPropertiesUnion&& u) FLATBUFFERS_NOEXCEPT :
    type(ContentProperties_NONE), value(nullptr)
    { std::swap(type, u.type); std::swap(value, u.value); }
  ContentPropertiesUnion(const ContentPropertiesUnion &) FLATBUFFERS_NOEXCEPT;
  ContentPropertiesUnion &operator=(const ContentPropertiesUnion &u) FLATBUFFERS_NOEXCEPT
    { ContentPropertiesUnion t(u); std::swap(type, t.type); std::swap(value, t.value); return *this; }
  ContentPropertiesUnion &operator=(ContentPropertiesUnion &&u) FLATBUFFERS_NOEXCEPT
    { std::swap(type, u.type); std::swap(value, u.value); return *this; }
  ~ContentPropertiesUnion() { Reset(); }

  void Reset();

#ifndef FLATBUFFERS_CPP98_STL
  template <typename T>
  void Set(T&& val) {
    using RT = typename std::remove_reference<T>::type;
    Reset();
    type = ContentPropertiesTraits<typename RT::TableType>::enum_value;
    if (type != ContentProperties_NONE) {
      value = new RT(std::forward<T>(val));
    }
  }
#endif  // FLATBUFFERS_CPP98_STL

  static void *UnPack(const void *obj, ContentProperties type, const flatbuffers::resolver_function_t *resolver);
  flatbuffers::Offset<void> Pack(flatbuffers::FlatBufferBuilder &_fbb, const flatbuffers::rehasher_function_t *_rehasher = nullptr) const;

  FeaturePropertiesT *AsFeatureProperties() {
    return type == ContentProperties_FeatureProperties ?
      reinterpret_cast<FeaturePropertiesT *>(value) : nullptr;
  }
  const FeaturePropertiesT *AsFeatureProperties() const {
    return type == ContentProperties_FeatureProperties ?
      reinterpret_cast<const FeaturePropertiesT *>(value) : nullptr;
  }
  ImagePropertiesT *AsImageProperties() {
    return type == ContentProperties_ImageProperties ?
      reinterpret_cast<ImagePropertiesT *>(value) : nullptr;
  }
  const ImagePropertiesT *AsImageProperties() const {
    return type == ContentProperties_ImageProperties ?
      reinterpret_cast<const ImagePropertiesT *>(value) : nullptr;
  }
  BoundingBoxPropertiesT *AsBoundingBoxProperties() {
    return type == ContentProperties_BoundingBoxProperties ?
      reinterpret_cast<BoundingBoxPropertiesT *>(value) : nullptr;
  }
  const BoundingBoxPropertiesT *AsBoundingBoxProperties() const {
    return type == ContentProperties_BoundingBoxProperties ?
      reinterpret_cast<const BoundingBoxPropertiesT *>(value) : nullptr;
  }
};

bool VerifyContentProperties(flatbuffers::Verifier &verifier, const void *obj, ContentProperties type);
bool VerifyContentPropertiesVector(flatbuffers::Verifier &verifier, const flatbuffers::Vector<flatbuffers::Offset<void>> *values, const flatbuffers::Vector<uint8_t> *types);

enum ScoreTransformationType {
  ScoreTransformationType_IDENTITY = 0,
  ScoreTransformationType_LOG = 1,
  ScoreTransformationType_INVERSE_LOGISTIC = 2,
  ScoreTransformationType_MIN = ScoreTransformationType_IDENTITY,
  ScoreTransformationType_MAX = ScoreTransformationType_INVERSE_LOGISTIC
};

inline const ScoreTransformationType (&EnumValuesScoreTransformationType())[3] {
  static const ScoreTransformationType values[] = {
    ScoreTransformationType_IDENTITY,
    ScoreTransformationType_LOG,
    ScoreTransformationType_INVERSE_LOGISTIC
  };
  return values;
}

inline const char * const *EnumNamesScoreTransformationType() {
  static const char * const names[] = {
    "IDENTITY",
    "LOG",
    "INVERSE_LOGISTIC",
    nullptr
  };
  return names;
}

inline const char *EnumNameScoreTransformationType(ScoreTransformationType e) {
  if (e < ScoreTransformationType_IDENTITY || e > ScoreTransformationType_INVERSE_LOGISTIC) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesScoreTransformationType()[index];
}

enum ProcessUnitOptions {
  ProcessUnitOptions_NONE = 0,
  ProcessUnitOptions_NormalizationOptions = 1,
  ProcessUnitOptions_ScoreCalibrationOptions = 2,
  ProcessUnitOptions_ScoreThresholdingOptions = 3,
  ProcessUnitOptions_MIN = ProcessUnitOptions_NONE,
  ProcessUnitOptions_MAX = ProcessUnitOptions_ScoreThresholdingOptions
};

inline const ProcessUnitOptions (&EnumValuesProcessUnitOptions())[4] {
  static const ProcessUnitOptions values[] = {
    ProcessUnitOptions_NONE,
    ProcessUnitOptions_NormalizationOptions,
    ProcessUnitOptions_ScoreCalibrationOptions,
    ProcessUnitOptions_ScoreThresholdingOptions
  };
  return values;
}

inline const char * const *EnumNamesProcessUnitOptions() {
  static const char * const names[] = {
    "NONE",
    "NormalizationOptions",
    "ScoreCalibrationOptions",
    "ScoreThresholdingOptions",
    nullptr
  };
  return names;
}

inline const char *EnumNameProcessUnitOptions(ProcessUnitOptions e) {
  if (e < ProcessUnitOptions_NONE || e > ProcessUnitOptions_ScoreThresholdingOptions) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesProcessUnitOptions()[index];
}

template<typename T> struct ProcessUnitOptionsTraits {
  static const ProcessUnitOptions enum_value = ProcessUnitOptions_NONE;
};

template<> struct ProcessUnitOptionsTraits<NormalizationOptions> {
  static const ProcessUnitOptions enum_value = ProcessUnitOptions_NormalizationOptions;
};

template<> struct ProcessUnitOptionsTraits<ScoreCalibrationOptions> {
  static const ProcessUnitOptions enum_value = ProcessUnitOptions_ScoreCalibrationOptions;
};

template<> struct ProcessUnitOptionsTraits<ScoreThresholdingOptions> {
  static const ProcessUnitOptions enum_value = ProcessUnitOptions_ScoreThresholdingOptions;
};

struct ProcessUnitOptionsUnion {
  ProcessUnitOptions type;
  void *value;

  ProcessUnitOptionsUnion() : type(ProcessUnitOptions_NONE), value(nullptr) {}
  ProcessUnitOptionsUnion(ProcessUnitOptionsUnion&& u) FLATBUFFERS_NOEXCEPT :
    type(ProcessUnitOptions_NONE), value(nullptr)
    { std::swap(type, u.type); std::swap(value, u.value); }
  ProcessUnitOptionsUnion(const ProcessUnitOptionsUnion &) FLATBUFFERS_NOEXCEPT;
  ProcessUnitOptionsUnion &operator=(const ProcessUnitOptionsUnion &u) FLATBUFFERS_NOEXCEPT
    { ProcessUnitOptionsUnion t(u); std::swap(type, t.type); std::swap(value, t.value); return *this; }
  ProcessUnitOptionsUnion &operator=(ProcessUnitOptionsUnion &&u) FLATBUFFERS_NOEXCEPT
    { std::swap(type, u.type); std::swap(value, u.value); return *this; }
  ~ProcessUnitOptionsUnion() { Reset(); }

  void Reset();

#ifndef FLATBUFFERS_CPP98_STL
  template <typename T>
  void Set(T&& val) {
    using RT = typename std::remove_reference<T>::type;
    Reset();
    type = ProcessUnitOptionsTraits<typename RT::TableType>::enum_value;
    if (type != ProcessUnitOptions_NONE) {
      value = new RT(std::forward<T>(val));
    }
  }
#endif  // FLATBUFFERS_CPP98_STL

  static void *UnPack(const void *obj, ProcessUnitOptions type, const flatbuffers::resolver_function_t *resolver);
  flatbuffers::Offset<void> Pack(flatbuffers::FlatBufferBuilder &_fbb, const flatbuffers::rehasher_function_t *_rehasher = nullptr) const;

  NormalizationOptionsT *AsNormalizationOptions() {
    return type == ProcessUnitOptions_NormalizationOptions ?
      reinterpret_cast<NormalizationOptionsT *>(value) : nullptr;
  }
  const NormalizationOptionsT *AsNormalizationOptions() const {
    return type == ProcessUnitOptions_NormalizationOptions ?
      reinterpret_cast<const NormalizationOptionsT *>(value) : nullptr;
  }
  ScoreCalibrationOptionsT *AsScoreCalibrationOptions() {
    return type == ProcessUnitOptions_ScoreCalibrationOptions ?
      reinterpret_cast<ScoreCalibrationOptionsT *>(value) : nullptr;
  }
  const ScoreCalibrationOptionsT *AsScoreCalibrationOptions() const {
    return type == ProcessUnitOptions_ScoreCalibrationOptions ?
      reinterpret_cast<const ScoreCalibrationOptionsT *>(value) : nullptr;
  }
  ScoreThresholdingOptionsT *AsScoreThresholdingOptions() {
    return type == ProcessUnitOptions_ScoreThresholdingOptions ?
      reinterpret_cast<ScoreThresholdingOptionsT *>(value) : nullptr;
  }
  const ScoreThresholdingOptionsT *AsScoreThresholdingOptions() const {
    return type == ProcessUnitOptions_ScoreThresholdingOptions ?
      reinterpret_cast<const ScoreThresholdingOptionsT *>(value) : nullptr;
  }
};

bool VerifyProcessUnitOptions(flatbuffers::Verifier &verifier, const void *obj, ProcessUnitOptions type);
bool VerifyProcessUnitOptionsVector(flatbuffers::Verifier &verifier, const flatbuffers::Vector<flatbuffers::Offset<void>> *values, const flatbuffers::Vector<uint8_t> *types);

struct AssociatedFileT : public flatbuffers::NativeTable {
  typedef AssociatedFile TableType;
  std::string name;
  std::string description;
  AssociatedFileType type;
  std::string locale;
  AssociatedFileT()
      : type(AssociatedFileType_UNKNOWN) {
  }
};

struct AssociatedFile FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef AssociatedFileT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_DESCRIPTION = 6,
    VT_TYPE = 8,
    VT_LOCALE = 10
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *description() const {
    return GetPointer<const flatbuffers::String *>(VT_DESCRIPTION);
  }
  AssociatedFileType type() const {
    return static_cast<AssociatedFileType>(GetField<int8_t>(VT_TYPE, 0));
  }
  const flatbuffers::String *locale() const {
    return GetPointer<const flatbuffers::String *>(VT_LOCALE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_DESCRIPTION) &&
           verifier.VerifyString(description()) &&
           VerifyField<int8_t>(verifier, VT_TYPE) &&
           VerifyOffset(verifier, VT_LOCALE) &&
           verifier.VerifyString(locale()) &&
           verifier.EndTable();
  }
  AssociatedFileT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(AssociatedFileT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<AssociatedFile> Pack(flatbuffers::FlatBufferBuilder &_fbb, const AssociatedFileT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct AssociatedFileBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(AssociatedFile::VT_NAME, name);
  }
  void add_description(flatbuffers::Offset<flatbuffers::String> description) {
    fbb_.AddOffset(AssociatedFile::VT_DESCRIPTION, description);
  }
  void add_type(AssociatedFileType type) {
    fbb_.AddElement<int8_t>(AssociatedFile::VT_TYPE, static_cast<int8_t>(type), 0);
  }
  void add_locale(flatbuffers::Offset<flatbuffers::String> locale) {
    fbb_.AddOffset(AssociatedFile::VT_LOCALE, locale);
  }
  explicit AssociatedFileBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  AssociatedFileBuilder &operator=(const AssociatedFileBuilder &);
  flatbuffers::Offset<AssociatedFile> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<AssociatedFile>(end);
    return o;
  }
};

inline flatbuffers::Offset<AssociatedFile> CreateAssociatedFile(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    AssociatedFileType type = AssociatedFileType_UNKNOWN,
    flatbuffers::Offset<flatbuffers::String> locale = 0) {
  AssociatedFileBuilder builder_(_fbb);
  builder_.add_locale(locale);
  builder_.add_description(description);
  builder_.add_name(name);
  builder_.add_type(type);
  return builder_.Finish();
}

inline flatbuffers::Offset<AssociatedFile> CreateAssociatedFileDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const char *description = nullptr,
    AssociatedFileType type = AssociatedFileType_UNKNOWN,
    const char *locale = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto description__ = description ? _fbb.CreateString(description) : 0;
  auto locale__ = locale ? _fbb.CreateString(locale) : 0;
  return tflite::CreateAssociatedFile(
      _fbb,
      name__,
      description__,
      type,
      locale__);
}

flatbuffers::Offset<AssociatedFile> CreateAssociatedFile(flatbuffers::FlatBufferBuilder &_fbb, const AssociatedFileT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct FeaturePropertiesT : public flatbuffers::NativeTable {
  typedef FeatureProperties TableType;
  FeaturePropertiesT() {
  }
};

struct FeatureProperties FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef FeaturePropertiesT NativeTableType;
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           verifier.EndTable();
  }
  FeaturePropertiesT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(FeaturePropertiesT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<FeatureProperties> Pack(flatbuffers::FlatBufferBuilder &_fbb, const FeaturePropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct FeaturePropertiesBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  explicit FeaturePropertiesBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  FeaturePropertiesBuilder &operator=(const FeaturePropertiesBuilder &);
  flatbuffers::Offset<FeatureProperties> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FeatureProperties>(end);
    return o;
  }
};

inline flatbuffers::Offset<FeatureProperties> CreateFeatureProperties(
    flatbuffers::FlatBufferBuilder &_fbb) {
  FeaturePropertiesBuilder builder_(_fbb);
  return builder_.Finish();
}

flatbuffers::Offset<FeatureProperties> CreateFeatureProperties(flatbuffers::FlatBufferBuilder &_fbb, const FeaturePropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ImageSizeT : public flatbuffers::NativeTable {
  typedef ImageSize TableType;
  uint32_t width;
  uint32_t height;
  ImageSizeT()
      : width(0),
        height(0) {
  }
};

struct ImageSize FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ImageSizeT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_WIDTH = 4,
    VT_HEIGHT = 6
  };
  uint32_t width() const {
    return GetField<uint32_t>(VT_WIDTH, 0);
  }
  uint32_t height() const {
    return GetField<uint32_t>(VT_HEIGHT, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_WIDTH) &&
           VerifyField<uint32_t>(verifier, VT_HEIGHT) &&
           verifier.EndTable();
  }
  ImageSizeT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ImageSizeT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ImageSize> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ImageSizeT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ImageSizeBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_width(uint32_t width) {
    fbb_.AddElement<uint32_t>(ImageSize::VT_WIDTH, width, 0);
  }
  void add_height(uint32_t height) {
    fbb_.AddElement<uint32_t>(ImageSize::VT_HEIGHT, height, 0);
  }
  explicit ImageSizeBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ImageSizeBuilder &operator=(const ImageSizeBuilder &);
  flatbuffers::Offset<ImageSize> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ImageSize>(end);
    return o;
  }
};

inline flatbuffers::Offset<ImageSize> CreateImageSize(
    flatbuffers::FlatBufferBuilder &_fbb,
    uint32_t width = 0,
    uint32_t height = 0) {
  ImageSizeBuilder builder_(_fbb);
  builder_.add_height(height);
  builder_.add_width(width);
  return builder_.Finish();
}

flatbuffers::Offset<ImageSize> CreateImageSize(flatbuffers::FlatBufferBuilder &_fbb, const ImageSizeT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ImagePropertiesT : public flatbuffers::NativeTable {
  typedef ImageProperties TableType;
  ColorSpaceType color_space;
  std::unique_ptr<ImageSizeT> default_size;
  ImagePropertiesT()
      : color_space(ColorSpaceType_UNKNOWN) {
  }
};

struct ImageProperties FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ImagePropertiesT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_COLOR_SPACE = 4,
    VT_DEFAULT_SIZE = 6
  };
  ColorSpaceType color_space() const {
    return static_cast<ColorSpaceType>(GetField<int8_t>(VT_COLOR_SPACE, 0));
  }
  const ImageSize *default_size() const {
    return GetPointer<const ImageSize *>(VT_DEFAULT_SIZE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_COLOR_SPACE) &&
           VerifyOffset(verifier, VT_DEFAULT_SIZE) &&
           verifier.VerifyTable(default_size()) &&
           verifier.EndTable();
  }
  ImagePropertiesT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ImagePropertiesT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ImageProperties> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ImagePropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ImagePropertiesBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_color_space(ColorSpaceType color_space) {
    fbb_.AddElement<int8_t>(ImageProperties::VT_COLOR_SPACE, static_cast<int8_t>(color_space), 0);
  }
  void add_default_size(flatbuffers::Offset<ImageSize> default_size) {
    fbb_.AddOffset(ImageProperties::VT_DEFAULT_SIZE, default_size);
  }
  explicit ImagePropertiesBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ImagePropertiesBuilder &operator=(const ImagePropertiesBuilder &);
  flatbuffers::Offset<ImageProperties> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ImageProperties>(end);
    return o;
  }
};

inline flatbuffers::Offset<ImageProperties> CreateImageProperties(
    flatbuffers::FlatBufferBuilder &_fbb,
    ColorSpaceType color_space = ColorSpaceType_UNKNOWN,
    flatbuffers::Offset<ImageSize> default_size = 0) {
  ImagePropertiesBuilder builder_(_fbb);
  builder_.add_default_size(default_size);
  builder_.add_color_space(color_space);
  return builder_.Finish();
}

flatbuffers::Offset<ImageProperties> CreateImageProperties(flatbuffers::FlatBufferBuilder &_fbb, const ImagePropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct BoundingBoxPropertiesT : public flatbuffers::NativeTable {
  typedef BoundingBoxProperties TableType;
  std::vector<uint32_t> index;
  BoundingBoxType type;
  CoordinateType coordinate_type;
  BoundingBoxPropertiesT()
      : type(BoundingBoxType_UNKNOWN),
        coordinate_type(CoordinateType_RATIO) {
  }
};

struct BoundingBoxProperties FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BoundingBoxPropertiesT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_INDEX = 4,
    VT_TYPE = 6,
    VT_COORDINATE_TYPE = 8
  };
  const flatbuffers::Vector<uint32_t> *index() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_INDEX);
  }
  BoundingBoxType type() const {
    return static_cast<BoundingBoxType>(GetField<int8_t>(VT_TYPE, 0));
  }
  CoordinateType coordinate_type() const {
    return static_cast<CoordinateType>(GetField<int8_t>(VT_COORDINATE_TYPE, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_INDEX) &&
           verifier.VerifyVector(index()) &&
           VerifyField<int8_t>(verifier, VT_TYPE) &&
           VerifyField<int8_t>(verifier, VT_COORDINATE_TYPE) &&
           verifier.EndTable();
  }
  BoundingBoxPropertiesT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(BoundingBoxPropertiesT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<BoundingBoxProperties> Pack(flatbuffers::FlatBufferBuilder &_fbb, const BoundingBoxPropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct BoundingBoxPropertiesBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_index(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> index) {
    fbb_.AddOffset(BoundingBoxProperties::VT_INDEX, index);
  }
  void add_type(BoundingBoxType type) {
    fbb_.AddElement<int8_t>(BoundingBoxProperties::VT_TYPE, static_cast<int8_t>(type), 0);
  }
  void add_coordinate_type(CoordinateType coordinate_type) {
    fbb_.AddElement<int8_t>(BoundingBoxProperties::VT_COORDINATE_TYPE, static_cast<int8_t>(coordinate_type), 0);
  }
  explicit BoundingBoxPropertiesBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  BoundingBoxPropertiesBuilder &operator=(const BoundingBoxPropertiesBuilder &);
  flatbuffers::Offset<BoundingBoxProperties> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<BoundingBoxProperties>(end);
    return o;
  }
};

inline flatbuffers::Offset<BoundingBoxProperties> CreateBoundingBoxProperties(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> index = 0,
    BoundingBoxType type = BoundingBoxType_UNKNOWN,
    CoordinateType coordinate_type = CoordinateType_RATIO) {
  BoundingBoxPropertiesBuilder builder_(_fbb);
  builder_.add_index(index);
  builder_.add_coordinate_type(coordinate_type);
  builder_.add_type(type);
  return builder_.Finish();
}

inline flatbuffers::Offset<BoundingBoxProperties> CreateBoundingBoxPropertiesDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<uint32_t> *index = nullptr,
    BoundingBoxType type = BoundingBoxType_UNKNOWN,
    CoordinateType coordinate_type = CoordinateType_RATIO) {
  auto index__ = index ? _fbb.CreateVector<uint32_t>(*index) : 0;
  return tflite::CreateBoundingBoxProperties(
      _fbb,
      index__,
      type,
      coordinate_type);
}

flatbuffers::Offset<BoundingBoxProperties> CreateBoundingBoxProperties(flatbuffers::FlatBufferBuilder &_fbb, const BoundingBoxPropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ValueRangeT : public flatbuffers::NativeTable {
  typedef ValueRange TableType;
  int32_t min;
  int32_t max;
  ValueRangeT()
      : min(0),
        max(0) {
  }
};

struct ValueRange FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ValueRangeT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_MIN = 4,
    VT_MAX = 6
  };
  int32_t min() const {
    return GetField<int32_t>(VT_MIN, 0);
  }
  int32_t max() const {
    return GetField<int32_t>(VT_MAX, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_MIN) &&
           VerifyField<int32_t>(verifier, VT_MAX) &&
           verifier.EndTable();
  }
  ValueRangeT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ValueRangeT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ValueRange> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ValueRangeT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ValueRangeBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_min(int32_t min) {
    fbb_.AddElement<int32_t>(ValueRange::VT_MIN, min, 0);
  }
  void add_max(int32_t max) {
    fbb_.AddElement<int32_t>(ValueRange::VT_MAX, max, 0);
  }
  explicit ValueRangeBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ValueRangeBuilder &operator=(const ValueRangeBuilder &);
  flatbuffers::Offset<ValueRange> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ValueRange>(end);
    return o;
  }
};

inline flatbuffers::Offset<ValueRange> CreateValueRange(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t min = 0,
    int32_t max = 0) {
  ValueRangeBuilder builder_(_fbb);
  builder_.add_max(max);
  builder_.add_min(min);
  return builder_.Finish();
}

flatbuffers::Offset<ValueRange> CreateValueRange(flatbuffers::FlatBufferBuilder &_fbb, const ValueRangeT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ContentT : public flatbuffers::NativeTable {
  typedef Content TableType;
  ContentPropertiesUnion content_properties;
  std::unique_ptr<ValueRangeT> range;
  ContentT() {
  }
};

struct Content FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ContentT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_CONTENT_PROPERTIES_TYPE = 4,
    VT_CONTENT_PROPERTIES = 6,
    VT_RANGE = 8
  };
  ContentProperties content_properties_type() const {
    return static_cast<ContentProperties>(GetField<uint8_t>(VT_CONTENT_PROPERTIES_TYPE, 0));
  }
  const void *content_properties() const {
    return GetPointer<const void *>(VT_CONTENT_PROPERTIES);
  }
  template<typename T> const T *content_properties_as() const;
  const FeatureProperties *content_properties_as_FeatureProperties() const {
    return content_properties_type() == ContentProperties_FeatureProperties ? static_cast<const FeatureProperties *>(content_properties()) : nullptr;
  }
  const ImageProperties *content_properties_as_ImageProperties() const {
    return content_properties_type() == ContentProperties_ImageProperties ? static_cast<const ImageProperties *>(content_properties()) : nullptr;
  }
  const BoundingBoxProperties *content_properties_as_BoundingBoxProperties() const {
    return content_properties_type() == ContentProperties_BoundingBoxProperties ? static_cast<const BoundingBoxProperties *>(content_properties()) : nullptr;
  }
  const ValueRange *range() const {
    return GetPointer<const ValueRange *>(VT_RANGE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_CONTENT_PROPERTIES_TYPE) &&
           VerifyOffset(verifier, VT_CONTENT_PROPERTIES) &&
           VerifyContentProperties(verifier, content_properties(), content_properties_type()) &&
           VerifyOffset(verifier, VT_RANGE) &&
           verifier.VerifyTable(range()) &&
           verifier.EndTable();
  }
  ContentT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ContentT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Content> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ContentT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

template<> inline const FeatureProperties *Content::content_properties_as<FeatureProperties>() const {
  return content_properties_as_FeatureProperties();
}

template<> inline const ImageProperties *Content::content_properties_as<ImageProperties>() const {
  return content_properties_as_ImageProperties();
}

template<> inline const BoundingBoxProperties *Content::content_properties_as<BoundingBoxProperties>() const {
  return content_properties_as_BoundingBoxProperties();
}

struct ContentBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_content_properties_type(ContentProperties content_properties_type) {
    fbb_.AddElement<uint8_t>(Content::VT_CONTENT_PROPERTIES_TYPE, static_cast<uint8_t>(content_properties_type), 0);
  }
  void add_content_properties(flatbuffers::Offset<void> content_properties) {
    fbb_.AddOffset(Content::VT_CONTENT_PROPERTIES, content_properties);
  }
  void add_range(flatbuffers::Offset<ValueRange> range) {
    fbb_.AddOffset(Content::VT_RANGE, range);
  }
  explicit ContentBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ContentBuilder &operator=(const ContentBuilder &);
  flatbuffers::Offset<Content> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Content>(end);
    return o;
  }
};

inline flatbuffers::Offset<Content> CreateContent(
    flatbuffers::FlatBufferBuilder &_fbb,
    ContentProperties content_properties_type = ContentProperties_NONE,
    flatbuffers::Offset<void> content_properties = 0,
    flatbuffers::Offset<ValueRange> range = 0) {
  ContentBuilder builder_(_fbb);
  builder_.add_range(range);
  builder_.add_content_properties(content_properties);
  builder_.add_content_properties_type(content_properties_type);
  return builder_.Finish();
}

flatbuffers::Offset<Content> CreateContent(flatbuffers::FlatBufferBuilder &_fbb, const ContentT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct NormalizationOptionsT : public flatbuffers::NativeTable {
  typedef NormalizationOptions TableType;
  std::vector<float> mean;
  std::vector<float> std;
  NormalizationOptionsT() {
  }
};

struct NormalizationOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef NormalizationOptionsT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_MEAN = 4,
    VT_STD = 6
  };
  const flatbuffers::Vector<float> *mean() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_MEAN);
  }
  const flatbuffers::Vector<float> *std() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_STD);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_MEAN) &&
           verifier.VerifyVector(mean()) &&
           VerifyOffset(verifier, VT_STD) &&
           verifier.VerifyVector(std()) &&
           verifier.EndTable();
  }
  NormalizationOptionsT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(NormalizationOptionsT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<NormalizationOptions> Pack(flatbuffers::FlatBufferBuilder &_fbb, const NormalizationOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct NormalizationOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_mean(flatbuffers::Offset<flatbuffers::Vector<float>> mean) {
    fbb_.AddOffset(NormalizationOptions::VT_MEAN, mean);
  }
  void add_std(flatbuffers::Offset<flatbuffers::Vector<float>> std) {
    fbb_.AddOffset(NormalizationOptions::VT_STD, std);
  }
  explicit NormalizationOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  NormalizationOptionsBuilder &operator=(const NormalizationOptionsBuilder &);
  flatbuffers::Offset<NormalizationOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<NormalizationOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<NormalizationOptions> CreateNormalizationOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<float>> mean = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> std = 0) {
  NormalizationOptionsBuilder builder_(_fbb);
  builder_.add_std(std);
  builder_.add_mean(mean);
  return builder_.Finish();
}

inline flatbuffers::Offset<NormalizationOptions> CreateNormalizationOptionsDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<float> *mean = nullptr,
    const std::vector<float> *std = nullptr) {
  auto mean__ = mean ? _fbb.CreateVector<float>(*mean) : 0;
  auto std__ = std ? _fbb.CreateVector<float>(*std) : 0;
  return tflite::CreateNormalizationOptions(
      _fbb,
      mean__,
      std__);
}

flatbuffers::Offset<NormalizationOptions> CreateNormalizationOptions(flatbuffers::FlatBufferBuilder &_fbb, const NormalizationOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ScoreCalibrationOptionsT : public flatbuffers::NativeTable {
  typedef ScoreCalibrationOptions TableType;
  ScoreTransformationType score_transformation;
  float default_score;
  ScoreCalibrationOptionsT()
      : score_transformation(ScoreTransformationType_IDENTITY),
        default_score(0.0f) {
  }
};

struct ScoreCalibrationOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ScoreCalibrationOptionsT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_SCORE_TRANSFORMATION = 4,
    VT_DEFAULT_SCORE = 6
  };
  ScoreTransformationType score_transformation() const {
    return static_cast<ScoreTransformationType>(GetField<int8_t>(VT_SCORE_TRANSFORMATION, 0));
  }
  float default_score() const {
    return GetField<float>(VT_DEFAULT_SCORE, 0.0f);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_SCORE_TRANSFORMATION) &&
           VerifyField<float>(verifier, VT_DEFAULT_SCORE) &&
           verifier.EndTable();
  }
  ScoreCalibrationOptionsT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ScoreCalibrationOptionsT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ScoreCalibrationOptions> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ScoreCalibrationOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ScoreCalibrationOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_score_transformation(ScoreTransformationType score_transformation) {
    fbb_.AddElement<int8_t>(ScoreCalibrationOptions::VT_SCORE_TRANSFORMATION, static_cast<int8_t>(score_transformation), 0);
  }
  void add_default_score(float default_score) {
    fbb_.AddElement<float>(ScoreCalibrationOptions::VT_DEFAULT_SCORE, default_score, 0.0f);
  }
  explicit ScoreCalibrationOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ScoreCalibrationOptionsBuilder &operator=(const ScoreCalibrationOptionsBuilder &);
  flatbuffers::Offset<ScoreCalibrationOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ScoreCalibrationOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ScoreCalibrationOptions> CreateScoreCalibrationOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ScoreTransformationType score_transformation = ScoreTransformationType_IDENTITY,
    float default_score = 0.0f) {
  ScoreCalibrationOptionsBuilder builder_(_fbb);
  builder_.add_default_score(default_score);
  builder_.add_score_transformation(score_transformation);
  return builder_.Finish();
}

flatbuffers::Offset<ScoreCalibrationOptions> CreateScoreCalibrationOptions(flatbuffers::FlatBufferBuilder &_fbb, const ScoreCalibrationOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ScoreThresholdingOptionsT : public flatbuffers::NativeTable {
  typedef ScoreThresholdingOptions TableType;
  float global_score_threshold;
  ScoreThresholdingOptionsT()
      : global_score_threshold(0.0f) {
  }
};

struct ScoreThresholdingOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ScoreThresholdingOptionsT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_GLOBAL_SCORE_THRESHOLD = 4
  };
  float global_score_threshold() const {
    return GetField<float>(VT_GLOBAL_SCORE_THRESHOLD, 0.0f);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<float>(verifier, VT_GLOBAL_SCORE_THRESHOLD) &&
           verifier.EndTable();
  }
  ScoreThresholdingOptionsT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ScoreThresholdingOptionsT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ScoreThresholdingOptions> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ScoreThresholdingOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ScoreThresholdingOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_global_score_threshold(float global_score_threshold) {
    fbb_.AddElement<float>(ScoreThresholdingOptions::VT_GLOBAL_SCORE_THRESHOLD, global_score_threshold, 0.0f);
  }
  explicit ScoreThresholdingOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ScoreThresholdingOptionsBuilder &operator=(const ScoreThresholdingOptionsBuilder &);
  flatbuffers::Offset<ScoreThresholdingOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ScoreThresholdingOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ScoreThresholdingOptions> CreateScoreThresholdingOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    float global_score_threshold = 0.0f) {
  ScoreThresholdingOptionsBuilder builder_(_fbb);
  builder_.add_global_score_threshold(global_score_threshold);
  return builder_.Finish();
}

flatbuffers::Offset<ScoreThresholdingOptions> CreateScoreThresholdingOptions(flatbuffers::FlatBufferBuilder &_fbb, const ScoreThresholdingOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ProcessUnitT : public flatbuffers::NativeTable {
  typedef ProcessUnit TableType;
  ProcessUnitOptionsUnion options;
  ProcessUnitT() {
  }
};

struct ProcessUnit FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ProcessUnitT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_OPTIONS_TYPE = 4,
    VT_OPTIONS = 6
  };
  ProcessUnitOptions options_type() const {
    return static_cast<ProcessUnitOptions>(GetField<uint8_t>(VT_OPTIONS_TYPE, 0));
  }
  const void *options() const {
    return GetPointer<const void *>(VT_OPTIONS);
  }
  template<typename T> const T *options_as() const;
  const NormalizationOptions *options_as_NormalizationOptions() const {
    return options_type() == ProcessUnitOptions_NormalizationOptions ? static_cast<const NormalizationOptions *>(options()) : nullptr;
  }
  const ScoreCalibrationOptions *options_as_ScoreCalibrationOptions() const {
    return options_type() == ProcessUnitOptions_ScoreCalibrationOptions ? static_cast<const ScoreCalibrationOptions *>(options()) : nullptr;
  }
  const ScoreThresholdingOptions *options_as_ScoreThresholdingOptions() const {
    return options_type() == ProcessUnitOptions_ScoreThresholdingOptions ? static_cast<const ScoreThresholdingOptions *>(options()) : nullptr;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_OPTIONS_TYPE) &&
           VerifyOffset(verifier, VT_OPTIONS) &&
           VerifyProcessUnitOptions(verifier, options(), options_type()) &&
           verifier.EndTable();
  }
  ProcessUnitT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ProcessUnitT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ProcessUnit> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ProcessUnitT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

template<> inline const NormalizationOptions *ProcessUnit::options_as<NormalizationOptions>() const {
  return options_as_NormalizationOptions();
}

template<> inline const ScoreCalibrationOptions *ProcessUnit::options_as<ScoreCalibrationOptions>() const {
  return options_as_ScoreCalibrationOptions();
}

template<> inline const ScoreThresholdingOptions *ProcessUnit::options_as<ScoreThresholdingOptions>() const {
  return options_as_ScoreThresholdingOptions();
}

struct ProcessUnitBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_options_type(ProcessUnitOptions options_type) {
    fbb_.AddElement<uint8_t>(ProcessUnit::VT_OPTIONS_TYPE, static_cast<uint8_t>(options_type), 0);
  }
  void add_options(flatbuffers::Offset<void> options) {
    fbb_.AddOffset(ProcessUnit::VT_OPTIONS, options);
  }
  explicit ProcessUnitBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ProcessUnitBuilder &operator=(const ProcessUnitBuilder &);
  flatbuffers::Offset<ProcessUnit> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ProcessUnit>(end);
    return o;
  }
};

inline flatbuffers::Offset<ProcessUnit> CreateProcessUnit(
    flatbuffers::FlatBufferBuilder &_fbb,
    ProcessUnitOptions options_type = ProcessUnitOptions_NONE,
    flatbuffers::Offset<void> options = 0) {
  ProcessUnitBuilder builder_(_fbb);
  builder_.add_options(options);
  builder_.add_options_type(options_type);
  return builder_.Finish();
}

flatbuffers::Offset<ProcessUnit> CreateProcessUnit(flatbuffers::FlatBufferBuilder &_fbb, const ProcessUnitT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct StatsT : public flatbuffers::NativeTable {
  typedef Stats TableType;
  std::vector<float> max;
  std::vector<float> min;
  StatsT() {
  }
};

struct Stats FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef StatsT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_MAX = 4,
    VT_MIN = 6
  };
  const flatbuffers::Vector<float> *max() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_MAX);
  }
  const flatbuffers::Vector<float> *min() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_MIN);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_MAX) &&
           verifier.VerifyVector(max()) &&
           VerifyOffset(verifier, VT_MIN) &&
           verifier.VerifyVector(min()) &&
           verifier.EndTable();
  }
  StatsT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(StatsT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Stats> Pack(flatbuffers::FlatBufferBuilder &_fbb, const StatsT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct StatsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_max(flatbuffers::Offset<flatbuffers::Vector<float>> max) {
    fbb_.AddOffset(Stats::VT_MAX, max);
  }
  void add_min(flatbuffers::Offset<flatbuffers::Vector<float>> min) {
    fbb_.AddOffset(Stats::VT_MIN, min);
  }
  explicit StatsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  StatsBuilder &operator=(const StatsBuilder &);
  flatbuffers::Offset<Stats> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Stats>(end);
    return o;
  }
};

inline flatbuffers::Offset<Stats> CreateStats(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<float>> max = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> min = 0) {
  StatsBuilder builder_(_fbb);
  builder_.add_min(min);
  builder_.add_max(max);
  return builder_.Finish();
}

inline flatbuffers::Offset<Stats> CreateStatsDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<float> *max = nullptr,
    const std::vector<float> *min = nullptr) {
  auto max__ = max ? _fbb.CreateVector<float>(*max) : 0;
  auto min__ = min ? _fbb.CreateVector<float>(*min) : 0;
  return tflite::CreateStats(
      _fbb,
      max__,
      min__);
}

flatbuffers::Offset<Stats> CreateStats(flatbuffers::FlatBufferBuilder &_fbb, const StatsT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct TensorMetadataT : public flatbuffers::NativeTable {
  typedef TensorMetadata TableType;
  std::string name;
  std::string description;
  std::vector<std::string> dimension_names;
  std::unique_ptr<ContentT> content;
  std::vector<std::unique_ptr<ProcessUnitT>> process_units;
  std::unique_ptr<StatsT> stats;
  std::vector<std::unique_ptr<AssociatedFileT>> associated_files;
  TensorMetadataT() {
  }
};

struct TensorMetadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorMetadataT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_DESCRIPTION = 6,
    VT_DIMENSION_NAMES = 8,
    VT_CONTENT = 10,
    VT_PROCESS_UNITS = 12,
    VT_STATS = 14,
    VT_ASSOCIATED_FILES = 16
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *description() const {
    return GetPointer<const flatbuffers::String *>(VT_DESCRIPTION);
  }
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *dimension_names() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(VT_DIMENSION_NAMES);
  }
  const Content *content() const {
    return GetPointer<const Content *>(VT_CONTENT);
  }
  const flatbuffers::Vector<flatbuffers::Offset<ProcessUnit>> *process_units() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<ProcessUnit>> *>(VT_PROCESS_UNITS);
  }
  const Stats *stats() const {
    return GetPointer<const Stats *>(VT_STATS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *associated_files() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *>(VT_ASSOCIATED_FILES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_DESCRIPTION) &&
           verifier.VerifyString(description()) &&
           VerifyOffset(verifier, VT_DIMENSION_NAMES) &&
           verifier.VerifyVector(dimension_names()) &&
           verifier.VerifyVectorOfStrings(dimension_names()) &&
           VerifyOffset(verifier, VT_CONTENT) &&
           verifier.VerifyTable(content()) &&
           VerifyOffset(verifier, VT_PROCESS_UNITS) &&
           verifier.VerifyVector(process_units()) &&
           verifier.VerifyVectorOfTables(process_units()) &&
           VerifyOffset(verifier, VT_STATS) &&
           verifier.VerifyTable(stats()) &&
           VerifyOffset(verifier, VT_ASSOCIATED_FILES) &&
           verifier.VerifyVector(associated_files()) &&
           verifier.VerifyVectorOfTables(associated_files()) &&
           verifier.EndTable();
  }
  TensorMetadataT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(TensorMetadataT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<TensorMetadata> Pack(flatbuffers::FlatBufferBuilder &_fbb, const TensorMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct TensorMetadataBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(TensorMetadata::VT_NAME, name);
  }
  void add_description(flatbuffers::Offset<flatbuffers::String> description) {
    fbb_.AddOffset(TensorMetadata::VT_DESCRIPTION, description);
  }
  void add_dimension_names(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> dimension_names) {
    fbb_.AddOffset(TensorMetadata::VT_DIMENSION_NAMES, dimension_names);
  }
  void add_content(flatbuffers::Offset<Content> content) {
    fbb_.AddOffset(TensorMetadata::VT_CONTENT, content);
  }
  void add_process_units(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<ProcessUnit>>> process_units) {
    fbb_.AddOffset(TensorMetadata::VT_PROCESS_UNITS, process_units);
  }
  void add_stats(flatbuffers::Offset<Stats> stats) {
    fbb_.AddOffset(TensorMetadata::VT_STATS, stats);
  }
  void add_associated_files(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files) {
    fbb_.AddOffset(TensorMetadata::VT_ASSOCIATED_FILES, associated_files);
  }
  explicit TensorMetadataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  TensorMetadataBuilder &operator=(const TensorMetadataBuilder &);
  flatbuffers::Offset<TensorMetadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TensorMetadata>(end);
    return o;
  }
};

inline flatbuffers::Offset<TensorMetadata> CreateTensorMetadata(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> dimension_names = 0,
    flatbuffers::Offset<Content> content = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<ProcessUnit>>> process_units = 0,
    flatbuffers::Offset<Stats> stats = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files = 0) {
  TensorMetadataBuilder builder_(_fbb);
  builder_.add_associated_files(associated_files);
  builder_.add_stats(stats);
  builder_.add_process_units(process_units);
  builder_.add_content(content);
  builder_.add_dimension_names(dimension_names);
  builder_.add_description(description);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<TensorMetadata> CreateTensorMetadataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const char *description = nullptr,
    const std::vector<flatbuffers::Offset<flatbuffers::String>> *dimension_names = nullptr,
    flatbuffers::Offset<Content> content = 0,
    const std::vector<flatbuffers::Offset<ProcessUnit>> *process_units = nullptr,
    flatbuffers::Offset<Stats> stats = 0,
    const std::vector<flatbuffers::Offset<AssociatedFile>> *associated_files = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto description__ = description ? _fbb.CreateString(description) : 0;
  auto dimension_names__ = dimension_names ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*dimension_names) : 0;
  auto process_units__ = process_units ? _fbb.CreateVector<flatbuffers::Offset<ProcessUnit>>(*process_units) : 0;
  auto associated_files__ = associated_files ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>>(*associated_files) : 0;
  return tflite::CreateTensorMetadata(
      _fbb,
      name__,
      description__,
      dimension_names__,
      content,
      process_units__,
      stats,
      associated_files__);
}

flatbuffers::Offset<TensorMetadata> CreateTensorMetadata(flatbuffers::FlatBufferBuilder &_fbb, const TensorMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SubGraphMetadataT : public flatbuffers::NativeTable {
  typedef SubGraphMetadata TableType;
  std::string name;
  std::string description;
  std::vector<std::unique_ptr<TensorMetadataT>> input_tensor_metadata;
  std::vector<std::unique_ptr<TensorMetadataT>> output_tensor_metadata;
  std::vector<std::unique_ptr<AssociatedFileT>> associated_files;
  SubGraphMetadataT() {
  }
};

struct SubGraphMetadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SubGraphMetadataT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_DESCRIPTION = 6,
    VT_INPUT_TENSOR_METADATA = 8,
    VT_OUTPUT_TENSOR_METADATA = 10,
    VT_ASSOCIATED_FILES = 12
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *description() const {
    return GetPointer<const flatbuffers::String *>(VT_DESCRIPTION);
  }
  const flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>> *input_tensor_metadata() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>> *>(VT_INPUT_TENSOR_METADATA);
  }
  const flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>> *output_tensor_metadata() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>> *>(VT_OUTPUT_TENSOR_METADATA);
  }
  const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *associated_files() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *>(VT_ASSOCIATED_FILES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_DESCRIPTION) &&
           verifier.VerifyString(description()) &&
           VerifyOffset(verifier, VT_INPUT_TENSOR_METADATA) &&
           verifier.VerifyVector(input_tensor_metadata()) &&
           verifier.VerifyVectorOfTables(input_tensor_metadata()) &&
           VerifyOffset(verifier, VT_OUTPUT_TENSOR_METADATA) &&
           verifier.VerifyVector(output_tensor_metadata()) &&
           verifier.VerifyVectorOfTables(output_tensor_metadata()) &&
           VerifyOffset(verifier, VT_ASSOCIATED_FILES) &&
           verifier.VerifyVector(associated_files()) &&
           verifier.VerifyVectorOfTables(associated_files()) &&
           verifier.EndTable();
  }
  SubGraphMetadataT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(SubGraphMetadataT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SubGraphMetadata> Pack(flatbuffers::FlatBufferBuilder &_fbb, const SubGraphMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SubGraphMetadataBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(SubGraphMetadata::VT_NAME, name);
  }
  void add_description(flatbuffers::Offset<flatbuffers::String> description) {
    fbb_.AddOffset(SubGraphMetadata::VT_DESCRIPTION, description);
  }
  void add_input_tensor_metadata(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>>> input_tensor_metadata) {
    fbb_.AddOffset(SubGraphMetadata::VT_INPUT_TENSOR_METADATA, input_tensor_metadata);
  }
  void add_output_tensor_metadata(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>>> output_tensor_metadata) {
    fbb_.AddOffset(SubGraphMetadata::VT_OUTPUT_TENSOR_METADATA, output_tensor_metadata);
  }
  void add_associated_files(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files) {
    fbb_.AddOffset(SubGraphMetadata::VT_ASSOCIATED_FILES, associated_files);
  }
  explicit SubGraphMetadataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SubGraphMetadataBuilder &operator=(const SubGraphMetadataBuilder &);
  flatbuffers::Offset<SubGraphMetadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SubGraphMetadata>(end);
    return o;
  }
};

inline flatbuffers::Offset<SubGraphMetadata> CreateSubGraphMetadata(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>>> input_tensor_metadata = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<TensorMetadata>>> output_tensor_metadata = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files = 0) {
  SubGraphMetadataBuilder builder_(_fbb);
  builder_.add_associated_files(associated_files);
  builder_.add_output_tensor_metadata(output_tensor_metadata);
  builder_.add_input_tensor_metadata(input_tensor_metadata);
  builder_.add_description(description);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<SubGraphMetadata> CreateSubGraphMetadataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const char *description = nullptr,
    const std::vector<flatbuffers::Offset<TensorMetadata>> *input_tensor_metadata = nullptr,
    const std::vector<flatbuffers::Offset<TensorMetadata>> *output_tensor_metadata = nullptr,
    const std::vector<flatbuffers::Offset<AssociatedFile>> *associated_files = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto description__ = description ? _fbb.CreateString(description) : 0;
  auto input_tensor_metadata__ = input_tensor_metadata ? _fbb.CreateVector<flatbuffers::Offset<TensorMetadata>>(*input_tensor_metadata) : 0;
  auto output_tensor_metadata__ = output_tensor_metadata ? _fbb.CreateVector<flatbuffers::Offset<TensorMetadata>>(*output_tensor_metadata) : 0;
  auto associated_files__ = associated_files ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>>(*associated_files) : 0;
  return tflite::CreateSubGraphMetadata(
      _fbb,
      name__,
      description__,
      input_tensor_metadata__,
      output_tensor_metadata__,
      associated_files__);
}

flatbuffers::Offset<SubGraphMetadata> CreateSubGraphMetadata(flatbuffers::FlatBufferBuilder &_fbb, const SubGraphMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ModelMetadataT : public flatbuffers::NativeTable {
  typedef ModelMetadata TableType;
  std::string name;
  std::string description;
  std::string version;
  std::vector<std::unique_ptr<SubGraphMetadataT>> subgraph_metadata;
  std::string author;
  std::string license;
  std::vector<std::unique_ptr<AssociatedFileT>> associated_files;
  ModelMetadataT() {
  }
};

struct ModelMetadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ModelMetadataT NativeTableType;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_DESCRIPTION = 6,
    VT_VERSION = 8,
    VT_SUBGRAPH_METADATA = 10,
    VT_AUTHOR = 12,
    VT_LICENSE = 14,
    VT_ASSOCIATED_FILES = 16
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *description() const {
    return GetPointer<const flatbuffers::String *>(VT_DESCRIPTION);
  }
  const flatbuffers::String *version() const {
    return GetPointer<const flatbuffers::String *>(VT_VERSION);
  }
  const flatbuffers::Vector<flatbuffers::Offset<SubGraphMetadata>> *subgraph_metadata() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<SubGraphMetadata>> *>(VT_SUBGRAPH_METADATA);
  }
  const flatbuffers::String *author() const {
    return GetPointer<const flatbuffers::String *>(VT_AUTHOR);
  }
  const flatbuffers::String *license() const {
    return GetPointer<const flatbuffers::String *>(VT_LICENSE);
  }
  const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *associated_files() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>> *>(VT_ASSOCIATED_FILES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_DESCRIPTION) &&
           verifier.VerifyString(description()) &&
           VerifyOffset(verifier, VT_VERSION) &&
           verifier.VerifyString(version()) &&
           VerifyOffset(verifier, VT_SUBGRAPH_METADATA) &&
           verifier.VerifyVector(subgraph_metadata()) &&
           verifier.VerifyVectorOfTables(subgraph_metadata()) &&
           VerifyOffset(verifier, VT_AUTHOR) &&
           verifier.VerifyString(author()) &&
           VerifyOffset(verifier, VT_LICENSE) &&
           verifier.VerifyString(license()) &&
           VerifyOffset(verifier, VT_ASSOCIATED_FILES) &&
           verifier.VerifyVector(associated_files()) &&
           verifier.VerifyVectorOfTables(associated_files()) &&
           verifier.EndTable();
  }
  ModelMetadataT *UnPack(const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ModelMetadataT *_o, const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ModelMetadata> Pack(flatbuffers::FlatBufferBuilder &_fbb, const ModelMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ModelMetadataBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(ModelMetadata::VT_NAME, name);
  }
  void add_description(flatbuffers::Offset<flatbuffers::String> description) {
    fbb_.AddOffset(ModelMetadata::VT_DESCRIPTION, description);
  }
  void add_version(flatbuffers::Offset<flatbuffers::String> version) {
    fbb_.AddOffset(ModelMetadata::VT_VERSION, version);
  }
  void add_subgraph_metadata(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraphMetadata>>> subgraph_metadata) {
    fbb_.AddOffset(ModelMetadata::VT_SUBGRAPH_METADATA, subgraph_metadata);
  }
  void add_author(flatbuffers::Offset<flatbuffers::String> author) {
    fbb_.AddOffset(ModelMetadata::VT_AUTHOR, author);
  }
  void add_license(flatbuffers::Offset<flatbuffers::String> license) {
    fbb_.AddOffset(ModelMetadata::VT_LICENSE, license);
  }
  void add_associated_files(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files) {
    fbb_.AddOffset(ModelMetadata::VT_ASSOCIATED_FILES, associated_files);
  }
  explicit ModelMetadataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ModelMetadataBuilder &operator=(const ModelMetadataBuilder &);
  flatbuffers::Offset<ModelMetadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ModelMetadata>(end);
    return o;
  }
};

inline flatbuffers::Offset<ModelMetadata> CreateModelMetadata(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    flatbuffers::Offset<flatbuffers::String> version = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraphMetadata>>> subgraph_metadata = 0,
    flatbuffers::Offset<flatbuffers::String> author = 0,
    flatbuffers::Offset<flatbuffers::String> license = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<AssociatedFile>>> associated_files = 0) {
  ModelMetadataBuilder builder_(_fbb);
  builder_.add_associated_files(associated_files);
  builder_.add_license(license);
  builder_.add_author(author);
  builder_.add_subgraph_metadata(subgraph_metadata);
  builder_.add_version(version);
  builder_.add_description(description);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<ModelMetadata> CreateModelMetadataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const char *description = nullptr,
    const char *version = nullptr,
    const std::vector<flatbuffers::Offset<SubGraphMetadata>> *subgraph_metadata = nullptr,
    const char *author = nullptr,
    const char *license = nullptr,
    const std::vector<flatbuffers::Offset<AssociatedFile>> *associated_files = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto description__ = description ? _fbb.CreateString(description) : 0;
  auto version__ = version ? _fbb.CreateString(version) : 0;
  auto subgraph_metadata__ = subgraph_metadata ? _fbb.CreateVector<flatbuffers::Offset<SubGraphMetadata>>(*subgraph_metadata) : 0;
  auto author__ = author ? _fbb.CreateString(author) : 0;
  auto license__ = license ? _fbb.CreateString(license) : 0;
  auto associated_files__ = associated_files ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>>(*associated_files) : 0;
  return tflite::CreateModelMetadata(
      _fbb,
      name__,
      description__,
      version__,
      subgraph_metadata__,
      author__,
      license__,
      associated_files__);
}

flatbuffers::Offset<ModelMetadata> CreateModelMetadata(flatbuffers::FlatBufferBuilder &_fbb, const ModelMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline AssociatedFileT *AssociatedFile::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new AssociatedFileT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void AssociatedFile::UnPackTo(AssociatedFileT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = description(); if (_e) _o->description = _e->str(); };
  { auto _e = type(); _o->type = _e; };
  { auto _e = locale(); if (_e) _o->locale = _e->str(); };
}

inline flatbuffers::Offset<AssociatedFile> AssociatedFile::Pack(flatbuffers::FlatBufferBuilder &_fbb, const AssociatedFileT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateAssociatedFile(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<AssociatedFile> CreateAssociatedFile(flatbuffers::FlatBufferBuilder &_fbb, const AssociatedFileT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const AssociatedFileT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _description = _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
  auto _type = _o->type;
  auto _locale = _o->locale.empty() ? 0 : _fbb.CreateString(_o->locale);
  return tflite::CreateAssociatedFile(
      _fbb,
      _name,
      _description,
      _type,
      _locale);
}

inline FeaturePropertiesT *FeatureProperties::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new FeaturePropertiesT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void FeatureProperties::UnPackTo(FeaturePropertiesT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
}

inline flatbuffers::Offset<FeatureProperties> FeatureProperties::Pack(flatbuffers::FlatBufferBuilder &_fbb, const FeaturePropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateFeatureProperties(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FeatureProperties> CreateFeatureProperties(flatbuffers::FlatBufferBuilder &_fbb, const FeaturePropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const FeaturePropertiesT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  return tflite::CreateFeatureProperties(
      _fbb);
}

inline ImageSizeT *ImageSize::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ImageSizeT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ImageSize::UnPackTo(ImageSizeT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = width(); _o->width = _e; };
  { auto _e = height(); _o->height = _e; };
}

inline flatbuffers::Offset<ImageSize> ImageSize::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ImageSizeT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateImageSize(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ImageSize> CreateImageSize(flatbuffers::FlatBufferBuilder &_fbb, const ImageSizeT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ImageSizeT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _width = _o->width;
  auto _height = _o->height;
  return tflite::CreateImageSize(
      _fbb,
      _width,
      _height);
}

inline ImagePropertiesT *ImageProperties::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ImagePropertiesT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ImageProperties::UnPackTo(ImagePropertiesT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = color_space(); _o->color_space = _e; };
  { auto _e = default_size(); if (_e) _o->default_size = std::unique_ptr<ImageSizeT>(_e->UnPack(_resolver)); };
}

inline flatbuffers::Offset<ImageProperties> ImageProperties::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ImagePropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateImageProperties(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ImageProperties> CreateImageProperties(flatbuffers::FlatBufferBuilder &_fbb, const ImagePropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ImagePropertiesT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _color_space = _o->color_space;
  auto _default_size = _o->default_size ? CreateImageSize(_fbb, _o->default_size.get(), _rehasher) : 0;
  return tflite::CreateImageProperties(
      _fbb,
      _color_space,
      _default_size);
}

inline BoundingBoxPropertiesT *BoundingBoxProperties::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new BoundingBoxPropertiesT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void BoundingBoxProperties::UnPackTo(BoundingBoxPropertiesT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = index(); if (_e) { _o->index.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->index[_i] = _e->Get(_i); } } };
  { auto _e = type(); _o->type = _e; };
  { auto _e = coordinate_type(); _o->coordinate_type = _e; };
}

inline flatbuffers::Offset<BoundingBoxProperties> BoundingBoxProperties::Pack(flatbuffers::FlatBufferBuilder &_fbb, const BoundingBoxPropertiesT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateBoundingBoxProperties(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<BoundingBoxProperties> CreateBoundingBoxProperties(flatbuffers::FlatBufferBuilder &_fbb, const BoundingBoxPropertiesT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const BoundingBoxPropertiesT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _index = _o->index.size() ? _fbb.CreateVector(_o->index) : 0;
  auto _type = _o->type;
  auto _coordinate_type = _o->coordinate_type;
  return tflite::CreateBoundingBoxProperties(
      _fbb,
      _index,
      _type,
      _coordinate_type);
}

inline ValueRangeT *ValueRange::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ValueRangeT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ValueRange::UnPackTo(ValueRangeT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = min(); _o->min = _e; };
  { auto _e = max(); _o->max = _e; };
}

inline flatbuffers::Offset<ValueRange> ValueRange::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ValueRangeT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateValueRange(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ValueRange> CreateValueRange(flatbuffers::FlatBufferBuilder &_fbb, const ValueRangeT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ValueRangeT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _min = _o->min;
  auto _max = _o->max;
  return tflite::CreateValueRange(
      _fbb,
      _min,
      _max);
}

inline ContentT *Content::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ContentT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Content::UnPackTo(ContentT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = content_properties_type(); _o->content_properties.type = _e; };
  { auto _e = content_properties(); if (_e) _o->content_properties.value = ContentPropertiesUnion::UnPack(_e, content_properties_type(), _resolver); };
  { auto _e = range(); if (_e) _o->range = std::unique_ptr<ValueRangeT>(_e->UnPack(_resolver)); };
}

inline flatbuffers::Offset<Content> Content::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ContentT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateContent(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Content> CreateContent(flatbuffers::FlatBufferBuilder &_fbb, const ContentT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ContentT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _content_properties_type = _o->content_properties.type;
  auto _content_properties = _o->content_properties.Pack(_fbb);
  auto _range = _o->range ? CreateValueRange(_fbb, _o->range.get(), _rehasher) : 0;
  return tflite::CreateContent(
      _fbb,
      _content_properties_type,
      _content_properties,
      _range);
}

inline NormalizationOptionsT *NormalizationOptions::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new NormalizationOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void NormalizationOptions::UnPackTo(NormalizationOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = mean(); if (_e) { _o->mean.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->mean[_i] = _e->Get(_i); } } };
  { auto _e = std(); if (_e) { _o->std.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->std[_i] = _e->Get(_i); } } };
}

inline flatbuffers::Offset<NormalizationOptions> NormalizationOptions::Pack(flatbuffers::FlatBufferBuilder &_fbb, const NormalizationOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateNormalizationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<NormalizationOptions> CreateNormalizationOptions(flatbuffers::FlatBufferBuilder &_fbb, const NormalizationOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const NormalizationOptionsT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _mean = _o->mean.size() ? _fbb.CreateVector(_o->mean) : 0;
  auto _std = _o->std.size() ? _fbb.CreateVector(_o->std) : 0;
  return tflite::CreateNormalizationOptions(
      _fbb,
      _mean,
      _std);
}

inline ScoreCalibrationOptionsT *ScoreCalibrationOptions::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ScoreCalibrationOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ScoreCalibrationOptions::UnPackTo(ScoreCalibrationOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = score_transformation(); _o->score_transformation = _e; };
  { auto _e = default_score(); _o->default_score = _e; };
}

inline flatbuffers::Offset<ScoreCalibrationOptions> ScoreCalibrationOptions::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ScoreCalibrationOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateScoreCalibrationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ScoreCalibrationOptions> CreateScoreCalibrationOptions(flatbuffers::FlatBufferBuilder &_fbb, const ScoreCalibrationOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ScoreCalibrationOptionsT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _score_transformation = _o->score_transformation;
  auto _default_score = _o->default_score;
  return tflite::CreateScoreCalibrationOptions(
      _fbb,
      _score_transformation,
      _default_score);
}

inline ScoreThresholdingOptionsT *ScoreThresholdingOptions::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ScoreThresholdingOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ScoreThresholdingOptions::UnPackTo(ScoreThresholdingOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = global_score_threshold(); _o->global_score_threshold = _e; };
}

inline flatbuffers::Offset<ScoreThresholdingOptions> ScoreThresholdingOptions::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ScoreThresholdingOptionsT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateScoreThresholdingOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ScoreThresholdingOptions> CreateScoreThresholdingOptions(flatbuffers::FlatBufferBuilder &_fbb, const ScoreThresholdingOptionsT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ScoreThresholdingOptionsT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _global_score_threshold = _o->global_score_threshold;
  return tflite::CreateScoreThresholdingOptions(
      _fbb,
      _global_score_threshold);
}

inline ProcessUnitT *ProcessUnit::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ProcessUnitT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ProcessUnit::UnPackTo(ProcessUnitT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = options_type(); _o->options.type = _e; };
  { auto _e = options(); if (_e) _o->options.value = ProcessUnitOptionsUnion::UnPack(_e, options_type(), _resolver); };
}

inline flatbuffers::Offset<ProcessUnit> ProcessUnit::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ProcessUnitT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateProcessUnit(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ProcessUnit> CreateProcessUnit(flatbuffers::FlatBufferBuilder &_fbb, const ProcessUnitT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ProcessUnitT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _options_type = _o->options.type;
  auto _options = _o->options.Pack(_fbb);
  return tflite::CreateProcessUnit(
      _fbb,
      _options_type,
      _options);
}

inline StatsT *Stats::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new StatsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Stats::UnPackTo(StatsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = max(); if (_e) { _o->max.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->max[_i] = _e->Get(_i); } } };
  { auto _e = min(); if (_e) { _o->min.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->min[_i] = _e->Get(_i); } } };
}

inline flatbuffers::Offset<Stats> Stats::Pack(flatbuffers::FlatBufferBuilder &_fbb, const StatsT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateStats(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Stats> CreateStats(flatbuffers::FlatBufferBuilder &_fbb, const StatsT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const StatsT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _max = _o->max.size() ? _fbb.CreateVector(_o->max) : 0;
  auto _min = _o->min.size() ? _fbb.CreateVector(_o->min) : 0;
  return tflite::CreateStats(
      _fbb,
      _max,
      _min);
}

inline TensorMetadataT *TensorMetadata::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new TensorMetadataT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void TensorMetadata::UnPackTo(TensorMetadataT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = description(); if (_e) _o->description = _e->str(); };
  { auto _e = dimension_names(); if (_e) { _o->dimension_names.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->dimension_names[_i] = _e->Get(_i)->str(); } } };
  { auto _e = content(); if (_e) _o->content = std::unique_ptr<ContentT>(_e->UnPack(_resolver)); };
  { auto _e = process_units(); if (_e) { _o->process_units.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->process_units[_i] = std::unique_ptr<ProcessUnitT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = stats(); if (_e) _o->stats = std::unique_ptr<StatsT>(_e->UnPack(_resolver)); };
  { auto _e = associated_files(); if (_e) { _o->associated_files.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->associated_files[_i] = std::unique_ptr<AssociatedFileT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<TensorMetadata> TensorMetadata::Pack(flatbuffers::FlatBufferBuilder &_fbb, const TensorMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateTensorMetadata(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<TensorMetadata> CreateTensorMetadata(flatbuffers::FlatBufferBuilder &_fbb, const TensorMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const TensorMetadataT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _description = _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
  auto _dimension_names = _o->dimension_names.size() ? _fbb.CreateVectorOfStrings(_o->dimension_names) : 0;
  auto _content = _o->content ? CreateContent(_fbb, _o->content.get(), _rehasher) : 0;
  auto _process_units = _o->process_units.size() ? _fbb.CreateVector<flatbuffers::Offset<ProcessUnit>> (_o->process_units.size(), [](size_t i, _VectorArgs *__va) { return CreateProcessUnit(*__va->__fbb, __va->__o->process_units[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _stats = _o->stats ? CreateStats(_fbb, _o->stats.get(), _rehasher) : 0;
  auto _associated_files = _o->associated_files.size() ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>> (_o->associated_files.size(), [](size_t i, _VectorArgs *__va) { return CreateAssociatedFile(*__va->__fbb, __va->__o->associated_files[i].get(), __va->__rehasher); }, &_va ) : 0;
  return tflite::CreateTensorMetadata(
      _fbb,
      _name,
      _description,
      _dimension_names,
      _content,
      _process_units,
      _stats,
      _associated_files);
}

inline SubGraphMetadataT *SubGraphMetadata::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SubGraphMetadataT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SubGraphMetadata::UnPackTo(SubGraphMetadataT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = description(); if (_e) _o->description = _e->str(); };
  { auto _e = input_tensor_metadata(); if (_e) { _o->input_tensor_metadata.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->input_tensor_metadata[_i] = std::unique_ptr<TensorMetadataT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = output_tensor_metadata(); if (_e) { _o->output_tensor_metadata.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->output_tensor_metadata[_i] = std::unique_ptr<TensorMetadataT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = associated_files(); if (_e) { _o->associated_files.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->associated_files[_i] = std::unique_ptr<AssociatedFileT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<SubGraphMetadata> SubGraphMetadata::Pack(flatbuffers::FlatBufferBuilder &_fbb, const SubGraphMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSubGraphMetadata(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SubGraphMetadata> CreateSubGraphMetadata(flatbuffers::FlatBufferBuilder &_fbb, const SubGraphMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const SubGraphMetadataT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _description = _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
  auto _input_tensor_metadata = _o->input_tensor_metadata.size() ? _fbb.CreateVector<flatbuffers::Offset<TensorMetadata>> (_o->input_tensor_metadata.size(), [](size_t i, _VectorArgs *__va) { return CreateTensorMetadata(*__va->__fbb, __va->__o->input_tensor_metadata[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _output_tensor_metadata = _o->output_tensor_metadata.size() ? _fbb.CreateVector<flatbuffers::Offset<TensorMetadata>> (_o->output_tensor_metadata.size(), [](size_t i, _VectorArgs *__va) { return CreateTensorMetadata(*__va->__fbb, __va->__o->output_tensor_metadata[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _associated_files = _o->associated_files.size() ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>> (_o->associated_files.size(), [](size_t i, _VectorArgs *__va) { return CreateAssociatedFile(*__va->__fbb, __va->__o->associated_files[i].get(), __va->__rehasher); }, &_va ) : 0;
  return tflite::CreateSubGraphMetadata(
      _fbb,
      _name,
      _description,
      _input_tensor_metadata,
      _output_tensor_metadata,
      _associated_files);
}

inline ModelMetadataT *ModelMetadata::UnPack(const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ModelMetadataT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ModelMetadata::UnPackTo(ModelMetadataT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); };
  { auto _e = description(); if (_e) _o->description = _e->str(); };
  { auto _e = version(); if (_e) _o->version = _e->str(); };
  { auto _e = subgraph_metadata(); if (_e) { _o->subgraph_metadata.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->subgraph_metadata[_i] = std::unique_ptr<SubGraphMetadataT>(_e->Get(_i)->UnPack(_resolver)); } } };
  { auto _e = author(); if (_e) _o->author = _e->str(); };
  { auto _e = license(); if (_e) _o->license = _e->str(); };
  { auto _e = associated_files(); if (_e) { _o->associated_files.resize(_e->size()); for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->associated_files[_i] = std::unique_ptr<AssociatedFileT>(_e->Get(_i)->UnPack(_resolver)); } } };
}

inline flatbuffers::Offset<ModelMetadata> ModelMetadata::Pack(flatbuffers::FlatBufferBuilder &_fbb, const ModelMetadataT* _o, const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateModelMetadata(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ModelMetadata> CreateModelMetadata(flatbuffers::FlatBufferBuilder &_fbb, const ModelMetadataT *_o, const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { flatbuffers::FlatBufferBuilder *__fbb; const ModelMetadataT* __o; const flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _description = _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
  auto _version = _o->version.empty() ? 0 : _fbb.CreateString(_o->version);
  auto _subgraph_metadata = _o->subgraph_metadata.size() ? _fbb.CreateVector<flatbuffers::Offset<SubGraphMetadata>> (_o->subgraph_metadata.size(), [](size_t i, _VectorArgs *__va) { return CreateSubGraphMetadata(*__va->__fbb, __va->__o->subgraph_metadata[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _author = _o->author.empty() ? 0 : _fbb.CreateString(_o->author);
  auto _license = _o->license.empty() ? 0 : _fbb.CreateString(_o->license);
  auto _associated_files = _o->associated_files.size() ? _fbb.CreateVector<flatbuffers::Offset<AssociatedFile>> (_o->associated_files.size(), [](size_t i, _VectorArgs *__va) { return CreateAssociatedFile(*__va->__fbb, __va->__o->associated_files[i].get(), __va->__rehasher); }, &_va ) : 0;
  return tflite::CreateModelMetadata(
      _fbb,
      _name,
      _description,
      _version,
      _subgraph_metadata,
      _author,
      _license,
      _associated_files);
}

inline bool VerifyContentProperties(flatbuffers::Verifier &verifier, const void *obj, ContentProperties type) {
  switch (type) {
    case ContentProperties_NONE: {
      return true;
    }
    case ContentProperties_FeatureProperties: {
      auto ptr = reinterpret_cast<const FeatureProperties *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case ContentProperties_ImageProperties: {
      auto ptr = reinterpret_cast<const ImageProperties *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case ContentProperties_BoundingBoxProperties: {
      auto ptr = reinterpret_cast<const BoundingBoxProperties *>(obj);
      return verifier.VerifyTable(ptr);
    }
    default: return true;
  }
}

inline bool VerifyContentPropertiesVector(flatbuffers::Verifier &verifier, const flatbuffers::Vector<flatbuffers::Offset<void>> *values, const flatbuffers::Vector<uint8_t> *types) {
  if (!values || !types) return !values && !types;
  if (values->size() != types->size()) return false;
  for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyContentProperties(
        verifier,  values->Get(i), types->GetEnum<ContentProperties>(i))) {
      return false;
    }
  }
  return true;
}

inline void *ContentPropertiesUnion::UnPack(const void *obj, ContentProperties type, const flatbuffers::resolver_function_t *resolver) {
  switch (type) {
    case ContentProperties_FeatureProperties: {
      auto ptr = reinterpret_cast<const FeatureProperties *>(obj);
      return ptr->UnPack(resolver);
    }
    case ContentProperties_ImageProperties: {
      auto ptr = reinterpret_cast<const ImageProperties *>(obj);
      return ptr->UnPack(resolver);
    }
    case ContentProperties_BoundingBoxProperties: {
      auto ptr = reinterpret_cast<const BoundingBoxProperties *>(obj);
      return ptr->UnPack(resolver);
    }
    default: return nullptr;
  }
}

inline flatbuffers::Offset<void> ContentPropertiesUnion::Pack(flatbuffers::FlatBufferBuilder &_fbb, const flatbuffers::rehasher_function_t *_rehasher) const {
  switch (type) {
    case ContentProperties_FeatureProperties: {
      auto ptr = reinterpret_cast<const FeaturePropertiesT *>(value);
      return CreateFeatureProperties(_fbb, ptr, _rehasher).Union();
    }
    case ContentProperties_ImageProperties: {
      auto ptr = reinterpret_cast<const ImagePropertiesT *>(value);
      return CreateImageProperties(_fbb, ptr, _rehasher).Union();
    }
    case ContentProperties_BoundingBoxProperties: {
      auto ptr = reinterpret_cast<const BoundingBoxPropertiesT *>(value);
      return CreateBoundingBoxProperties(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
  }
}

inline ContentPropertiesUnion::ContentPropertiesUnion(const ContentPropertiesUnion &u) FLATBUFFERS_NOEXCEPT : type(u.type), value(nullptr) {
  switch (type) {
    case ContentProperties_FeatureProperties: {
      value = new FeaturePropertiesT(*reinterpret_cast<FeaturePropertiesT *>(u.value));
      break;
    }
    case ContentProperties_ImageProperties: {
      FLATBUFFERS_ASSERT(false);  // ImagePropertiesT not copyable.
      break;
    }
    case ContentProperties_BoundingBoxProperties: {
      value = new BoundingBoxPropertiesT(*reinterpret_cast<BoundingBoxPropertiesT *>(u.value));
      break;
    }
    default:
      break;
  }
}

inline void ContentPropertiesUnion::Reset() {
  switch (type) {
    case ContentProperties_FeatureProperties: {
      auto ptr = reinterpret_cast<FeaturePropertiesT *>(value);
      delete ptr;
      break;
    }
    case ContentProperties_ImageProperties: {
      auto ptr = reinterpret_cast<ImagePropertiesT *>(value);
      delete ptr;
      break;
    }
    case ContentProperties_BoundingBoxProperties: {
      auto ptr = reinterpret_cast<BoundingBoxPropertiesT *>(value);
      delete ptr;
      break;
    }
    default: break;
  }
  value = nullptr;
  type = ContentProperties_NONE;
}

inline bool VerifyProcessUnitOptions(flatbuffers::Verifier &verifier, const void *obj, ProcessUnitOptions type) {
  switch (type) {
    case ProcessUnitOptions_NONE: {
      return true;
    }
    case ProcessUnitOptions_NormalizationOptions: {
      auto ptr = reinterpret_cast<const NormalizationOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case ProcessUnitOptions_ScoreCalibrationOptions: {
      auto ptr = reinterpret_cast<const ScoreCalibrationOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case ProcessUnitOptions_ScoreThresholdingOptions: {
      auto ptr = reinterpret_cast<const ScoreThresholdingOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    default: return true;
  }
}

inline bool VerifyProcessUnitOptionsVector(flatbuffers::Verifier &verifier, const flatbuffers::Vector<flatbuffers::Offset<void>> *values, const flatbuffers::Vector<uint8_t> *types) {
  if (!values || !types) return !values && !types;
  if (values->size() != types->size()) return false;
  for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyProcessUnitOptions(
        verifier,  values->Get(i), types->GetEnum<ProcessUnitOptions>(i))) {
      return false;
    }
  }
  return true;
}

inline void *ProcessUnitOptionsUnion::UnPack(const void *obj, ProcessUnitOptions type, const flatbuffers::resolver_function_t *resolver) {
  switch (type) {
    case ProcessUnitOptions_NormalizationOptions: {
      auto ptr = reinterpret_cast<const NormalizationOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case ProcessUnitOptions_ScoreCalibrationOptions: {
      auto ptr = reinterpret_cast<const ScoreCalibrationOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case ProcessUnitOptions_ScoreThresholdingOptions: {
      auto ptr = reinterpret_cast<const ScoreThresholdingOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    default: return nullptr;
  }
}

inline flatbuffers::Offset<void> ProcessUnitOptionsUnion::Pack(flatbuffers::FlatBufferBuilder &_fbb, const flatbuffers::rehasher_function_t *_rehasher) const {
  switch (type) {
    case ProcessUnitOptions_NormalizationOptions: {
      auto ptr = reinterpret_cast<const NormalizationOptionsT *>(value);
      return CreateNormalizationOptions(_fbb, ptr, _rehasher).Union();
    }
    case ProcessUnitOptions_ScoreCalibrationOptions: {
      auto ptr = reinterpret_cast<const ScoreCalibrationOptionsT *>(value);
      return CreateScoreCalibrationOptions(_fbb, ptr, _rehasher).Union();
    }
    case ProcessUnitOptions_ScoreThresholdingOptions: {
      auto ptr = reinterpret_cast<const ScoreThresholdingOptionsT *>(value);
      return CreateScoreThresholdingOptions(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
  }
}

inline ProcessUnitOptionsUnion::ProcessUnitOptionsUnion(const ProcessUnitOptionsUnion &u) FLATBUFFERS_NOEXCEPT : type(u.type), value(nullptr) {
  switch (type) {
    case ProcessUnitOptions_NormalizationOptions: {
      value = new NormalizationOptionsT(*reinterpret_cast<NormalizationOptionsT *>(u.value));
      break;
    }
    case ProcessUnitOptions_ScoreCalibrationOptions: {
      value = new ScoreCalibrationOptionsT(*reinterpret_cast<ScoreCalibrationOptionsT *>(u.value));
      break;
    }
    case ProcessUnitOptions_ScoreThresholdingOptions: {
      value = new ScoreThresholdingOptionsT(*reinterpret_cast<ScoreThresholdingOptionsT *>(u.value));
      break;
    }
    default:
      break;
  }
}

inline void ProcessUnitOptionsUnion::Reset() {
  switch (type) {
    case ProcessUnitOptions_NormalizationOptions: {
      auto ptr = reinterpret_cast<NormalizationOptionsT *>(value);
      delete ptr;
      break;
    }
    case ProcessUnitOptions_ScoreCalibrationOptions: {
      auto ptr = reinterpret_cast<ScoreCalibrationOptionsT *>(value);
      delete ptr;
      break;
    }
    case ProcessUnitOptions_ScoreThresholdingOptions: {
      auto ptr = reinterpret_cast<ScoreThresholdingOptionsT *>(value);
      delete ptr;
      break;
    }
    default: break;
  }
  value = nullptr;
  type = ProcessUnitOptions_NONE;
}

inline const tflite::ModelMetadata *GetModelMetadata(const void *buf) {
  return flatbuffers::GetRoot<tflite::ModelMetadata>(buf);
}

inline const tflite::ModelMetadata *GetSizePrefixedModelMetadata(const void *buf) {
  return flatbuffers::GetSizePrefixedRoot<tflite::ModelMetadata>(buf);
}

inline const char *ModelMetadataIdentifier() {
  return "M001";
}

inline bool ModelMetadataBufferHasIdentifier(const void *buf) {
  return flatbuffers::BufferHasIdentifier(
      buf, ModelMetadataIdentifier());
}

inline bool VerifyModelMetadataBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<tflite::ModelMetadata>(ModelMetadataIdentifier());
}

inline bool VerifySizePrefixedModelMetadataBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<tflite::ModelMetadata>(ModelMetadataIdentifier());
}

inline const char *ModelMetadataExtension() {
  return "tflitemeta";
}

inline void FinishModelMetadataBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<tflite::ModelMetadata> root) {
  fbb.Finish(root, ModelMetadataIdentifier());
}

inline void FinishSizePrefixedModelMetadataBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<tflite::ModelMetadata> root) {
  fbb.FinishSizePrefixed(root, ModelMetadataIdentifier());
}

inline std::unique_ptr<ModelMetadataT> UnPackModelMetadata(
    const void *buf,
    const flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<ModelMetadataT>(GetModelMetadata(buf)->UnPack(res));
}

}  // namespace tflite

#endif  // FLATBUFFERS_GENERATED_METADATASCHEMA_TFLITE_H_
