/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructRecordAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructClass
extends StructMember {
    public final String qualifiedName;
    public final PrimitiveConstant superClass;
    private final boolean own;
    private final LazyLoader loader;
    private final int minorVersion;
    private final int majorVersion;
    private final int[] interfaces;
    private final String[] interfaceNames;
    private final VBStyleCollection<StructField, String> fields;
    private final VBStyleCollection<StructMethod, String> methods;
    private ConstantPool pool;

    public static StructClass create(DataInputFullStream in, boolean own, LazyLoader loader) throws IOException {
        in.discard(4);
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        int bytecodeVersion = Math.max(majorVersion, 48);
        ConstantPool pool = new ConstantPool(in);
        int accessFlags = in.readUnsignedShort();
        int thisClassIdx = in.readUnsignedShort();
        int superClassIdx = in.readUnsignedShort();
        String qualifiedName = pool.getPrimitiveConstant(thisClassIdx).getString();
        PrimitiveConstant superClass = pool.getPrimitiveConstant(superClassIdx);
        int length = in.readUnsignedShort();
        int[] interfaces = new int[length];
        String[] interfaceNames = new String[length];
        for (int i = 0; i < length; ++i) {
            interfaces[i] = in.readUnsignedShort();
            interfaceNames[i] = pool.getPrimitiveConstant(interfaces[i]).getString();
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructField, String> fields = new VBStyleCollection<StructField, String>(length);
        for (int i = 0; i < length; ++i) {
            StructField field = StructField.create(in, pool, qualifiedName);
            fields.addWithKey(field, InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor()));
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructMethod, String> methods = new VBStyleCollection<StructMethod, String>(length);
        for (int i = 0; i < length; ++i) {
            StructMethod method = StructMethod.create(in, pool, qualifiedName, bytecodeVersion, own);
            methods.addWithKey(method, InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor()));
        }
        Map<String, StructGeneralAttribute> attributes = StructClass.readAttributes(in, pool);
        StructClass cl = new StructClass(accessFlags, attributes, qualifiedName, superClass, own, loader, minorVersion, majorVersion, interfaces, interfaceNames, fields, methods);
        if (loader == null) {
            cl.pool = pool;
        }
        return cl;
    }

    private StructClass(int accessFlags, Map<String, StructGeneralAttribute> attributes, String qualifiedName, PrimitiveConstant superClass, boolean own, LazyLoader loader, int minorVersion, int majorVersion, int[] interfaces, String[] interfaceNames, VBStyleCollection<StructField, String> fields, VBStyleCollection<StructMethod, String> methods) {
        super(accessFlags, attributes);
        this.qualifiedName = qualifiedName;
        this.superClass = superClass;
        this.own = own;
        this.loader = loader;
        this.minorVersion = minorVersion;
        this.majorVersion = majorVersion;
        this.interfaces = interfaces;
        this.interfaceNames = interfaceNames;
        this.fields = fields;
        this.methods = methods;
    }

    public boolean hasField(String name, String descriptor) {
        return this.getField(name, descriptor) != null;
    }

    public StructField getField(String name, String descriptor) {
        return this.fields.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethod(String key) {
        return this.methods.getWithKey(key);
    }

    public StructMethod getMethod(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public String getInterface(int i) {
        return this.interfaceNames[i];
    }

    public void releaseResources() {
        if (this.loader != null) {
            this.pool = null;
        }
    }

    public ConstantPool getPool() {
        if (this.pool == null && this.loader != null) {
            this.pool = this.loader.loadPool(this.qualifiedName);
        }
        return this.pool;
    }

    public List<StructRecordComponent> getRecordComponents() {
        StructRecordAttribute recordAttr = this.getAttribute(StructGeneralAttribute.ATTRIBUTE_RECORD);
        if (recordAttr == null) {
            return null;
        }
        return recordAttr.getComponents();
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public VBStyleCollection<StructMethod, String> getMethods() {
        return this.methods;
    }

    public VBStyleCollection<StructField, String> getFields() {
        return this.fields;
    }

    public boolean isOwn() {
        return this.own;
    }

    public LazyLoader getLoader() {
        return this.loader;
    }

    public boolean isVersion5() {
        return this.majorVersion > 48 || this.majorVersion == 48 && this.minorVersion > 0;
    }

    public boolean isVersion8() {
        return this.majorVersion >= 52;
    }

    public String toString() {
        return this.qualifiedName;
    }
}

