import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access level for the project access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `master`. Default is `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token#access_level ProjectAccessToken#access_level}
    */
    readonly accessLevel?: string;
    /**
    * Time the token will expire it, YYYY-MM-DD format. Will not expire per default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token#expires_at ProjectAccessToken#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * A name to describe the project access token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token#name ProjectAccessToken#name}
    */
    readonly name: string;
    /**
    * The id of the project to add the project access token to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token#project ProjectAccessToken#project}
    */
    readonly project: string;
    /**
    * Valid values: `api`, `read_api`, `read_repository`, `write_repository`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token#scopes ProjectAccessToken#scopes}
    */
    readonly scopes: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token gitlab_project_access_token}
*/
export declare class ProjectAccessToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_access_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_access_token gitlab_project_access_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectAccessTokenConfig
    */
    constructor(scope: Construct, id: string, config: ProjectAccessTokenConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get revoked(): cdktf.IResolvable;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    get token(): string;
    get userId(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
