import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The public email address of the user. **Note**: before GitLab 14.8 the lookup was based on the users primary email address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user#email DataGitlabUser#email}
    */
    readonly email?: string;
    /**
    * The ID of the user's namespace. Requires admin token to access this field. Available since GitLab 14.10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user#namespace_id DataGitlabUser#namespace_id}
    */
    readonly namespaceId?: number;
    /**
    * The ID of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user#user_id DataGitlabUser#user_id}
    */
    readonly userId?: number;
    /**
    * The username of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user#username DataGitlabUser#username}
    */
    readonly username?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/user gitlab_user}
*/
export declare class DataGitlabUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/user gitlab_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabUserConfig);
    get avatarUrl(): string;
    get bio(): string;
    get canCreateGroup(): cdktf.IResolvable;
    get canCreateProject(): cdktf.IResolvable;
    get colorSchemeId(): number;
    get createdAt(): string;
    get currentSignInAt(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get externUid(): string;
    get external(): cdktf.IResolvable;
    get id(): string;
    get isAdmin(): cdktf.IResolvable;
    get lastSignInAt(): string;
    get linkedin(): string;
    get location(): string;
    get name(): string;
    private _namespaceId?;
    get namespaceId(): number;
    set namespaceId(value: number);
    resetNamespaceId(): void;
    get namespaceIdInput(): number | undefined;
    get note(): string;
    get organization(): string;
    get projectsLimit(): number;
    get skype(): string;
    get state(): string;
    get themeId(): number;
    get twitter(): string;
    get twoFactorEnabled(): cdktf.IResolvable;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
    get userProvider(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    get websiteUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
