import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabRepositoryFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full path of the file. It must be relative to the root of the project without a leading slash `/`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_file#file_path DataGitlabRepositoryFile#file_path}
    */
    readonly filePath: string;
    /**
    * The name or ID of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_file#project DataGitlabRepositoryFile#project}
    */
    readonly project: string;
    /**
    * The name of branch, tag or commit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_file#ref DataGitlabRepositoryFile#ref}
    */
    readonly ref: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/repository_file gitlab_repository_file}
*/
export declare class DataGitlabRepositoryFile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_repository_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/repository_file gitlab_repository_file} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabRepositoryFileConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabRepositoryFileConfig);
    get blobId(): string;
    get commitId(): string;
    get content(): string;
    get contentSha256(): string;
    get encoding(): string;
    get executeFilemode(): cdktf.IResolvable;
    get fileName(): string;
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    get filePathInput(): string | undefined;
    get id(): string;
    get lastCommitId(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _ref?;
    get ref(): string;
    set ref(value: string);
    get refInput(): string | undefined;
    get size(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
