# FileXdb-Python
FileXdb is a lightweight local NoSQL database, optimized for best coding experience.

It's written in Core Python and has no external dependencies. The target is to reduce the complexity of installing external SQL Database & data handling. 

> #### FileXdb is:
> - A local, File-based, lightweight, horizontally scaled NoSQL Database.
> - Designed to be simple and interesting to use by providing simple and clean APIs.
> - A `Collection` & `Document` oriented approach.
> - Works on all modern versions of Python and PyPy.


# Supported Python Versions
Since newer versions of Python are often faster, have more features and are better supported, the latest version of Python 3 is recommended for **FileXdb**. You may use it on older versions as well.

# Installation
Install FileXdb using _**[pip](https://pip.pypa.io/en/stable/getting-started/)**_ :

#### Windows:
    python -m pip install filexdb

#### Linux / MAC:
    python3 -m pip install filexdb

# Getting Start
```python
from filexdb import FileXdb

db = FileXdb("db-name", "path/to/data/dir")
new_coll = db.collection("collection-name")

new_coll.insert({"name": "Sam", "skills": ["Python", "C++"]})
```


### Insert Multiple Documents
```python
data = [
    {
        "name": "Jack",
        "dept": "CSE"
    },
    {
        "name": "Rocky", 
        "address": {
            "PO": "Bongaon", 
            "PS": "Kolkata"
        }, 
        "skills": [
            "Game Dev"
        ]
    },
    {
        "name": "Rahul"
    }
]

new_coll.insert_all(data)           # `data` should be a List of  JSON Object
```


### Find Documents

```python
query = {"name": "Sam"}

# Returns all Documents.
new_coll.find()  

# Returns all Documents matches the ``_query``.
new_coll.find(query=query)  

# Returns doc[1] to doc[2] matches the ``_query``.
new_coll.find(query=query, limit=(1, 3))  

# Returns doc[1] to doc[9] of all Documents.
new_coll.find(limit=(3, 50))
```


### Update Documents
```python
query = {
    "name": "Rocky"
}

updated_data = {
    "name": "Rocky Bhai",
    "skills": [
        "Game Dev", 
        "C++", 
        "Python"
    ]
}

new_coll.update(updated_data, query)
```


### Delete Documents
```python
query = {
    "name": "Rocky Bhai", 
    "dept": "ECE"
}

new_coll.delete(query)
```

# More Features
_FileXdb_ is in `Beta` stage. Currently we have above features only. We will come back to you with other advanced features soon.

You may also contribute in this journey.



# Contributing

Thank you for investing your time in [contributing](https://github.com/FileXdb/FileXdb-Python/blob/master/CONTRIBUTING.md) to our project! Whether it's a bug report, new feature, correction, or additional documentation, we greatly value feedback and contributions from our community. Any contribution you make will be reflected on `github.com/FileXdb/FileXdb-Python`✨.

Contributions to _FileXdb_ are welcome! Here's how to get started:

- Open an [issue](https://github.com/FileXdb/FileXdb-Python/issues) or find for related issues to start a discussion around a feature idea or a bug.
- Fork the [repository](https://github.com/FileXdb/FileXdb-Python) on GitHub.
- Create a new branch of the master branch and start making your changes.
- Make a meaning-full commit.
- Write a test, which shows that the bug is fixed or the feature works as expected.
- Send a pull request and wait until it gets merged and published.
