"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobQueue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const batch_generated_1 = require("./batch.generated");
/**
 * Batch Job Queue.
 *
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 */
class JobQueue extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.jobQueueName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_batch_JobQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JobQueue);
            }
            throw error;
        }
        if (props.computeEnvironments.length === 0) {
            throw new Error('computeEnvironments must be non-empty');
        }
        const jobQueue = new batch_generated_1.CfnJobQueue(this, 'Resource', {
            computeEnvironmentOrder: props.computeEnvironments.map(cp => ({
                computeEnvironment: cp.computeEnvironment.computeEnvironmentArn,
                order: cp.order,
            })),
            jobQueueName: this.physicalName,
            priority: props.priority || 1,
            state: props.enabled === undefined ? 'ENABLED' : (props.enabled ? 'ENABLED' : 'DISABLED'),
        });
        this.jobQueueArn = this.getResourceArnAttribute(jobQueue.ref, {
            service: 'batch',
            resource: 'job-queue',
            resourceName: this.physicalName,
        });
        this.jobQueueName = this.getResourceNameAttribute(jobQueue.ref);
    }
    /**
     * Fetches an existing batch job queue by its amazon resource name.
     *
     * @param scope
     * @param id
     * @param jobQueueArn
     */
    static fromJobQueueArn(scope, id, jobQueueArn) {
        const stack = core_1.Stack.of(scope);
        const jobQueueName = stack.splitArn(jobQueueArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.jobQueueArn = jobQueueArn;
                this.jobQueueName = jobQueueName;
            }
        }
        return new Import(scope, id);
    }
}
exports.JobQueue = JobQueue;
_a = JSII_RTTI_SYMBOL_1;
JobQueue[_a] = { fqn: "@aws-cdk/aws-batch.JobQueue", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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