"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnRoute = exports.ClientVpnRouteTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * Target for a client VPN route.
 *
 * @stability stable
 */
class ClientVpnRouteTarget {
    /**
     * Subnet.
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     *
     * @stability stable
     */
    static subnet(subnet) {
        return { subnetId: subnet.subnetId };
    }
    /**
     * Local network.
     *
     * @stability stable
     */
    static local() {
        return { subnetId: 'local' };
    }
}
exports.ClientVpnRouteTarget = ClientVpnRouteTarget;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnRouteTarget[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRouteTarget", version: "1.96.0" };
/**
 * A client VPN route.
 *
 * @stability stable
 */
class ClientVpnRoute extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const route = new ec2_generated_1.CfnClientVpnRoute(this, 'Resource', {
            clientVpnEndpointId: props.clientVpnEndoint.endpointId,
            description: props.description,
            destinationCidrBlock: props.cidr,
            targetVpcSubnetId: props.target.subnetId,
        });
        // See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
        route.node.addDependency(props.clientVpnEndoint.targetNetworksAssociated);
    }
}
exports.ClientVpnRoute = ClientVpnRoute;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnRoute[_b] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRoute", version: "1.96.0" };
//# sourceMappingURL=data:application/json;base64,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