# Теория вероятности и комбинаторика

def factorial(n):
    """
    Вычисляет факториал числа n.

    :param n: Неп отрицательное целое число.
    :return: Факториал числа n (n!).
    """
    if n == 0:
        return 1  # Факториал нуля равен 1

    result = 1
    for i in range(1, n + 1):
        result *= i  # Умножаем результат на текущее значение i

    return result


def permutations(n, r):
    """
    Вычисляет количество перестановок из n элементов по r.

    :param n: Общее количество элементов.
    :param r: Количество выбираемых элементов.
    :return: Количество перестановок (n! / (n - r)!).
    """
    if r > n:
        return 0
    return factorial(n) / factorial(n - r)


def permutationsWithRepetion(n, r):
    """
    Вычисляет количество перестановок из n элементов с повторениями по r.

    :param n: Общее количество элементов.
    :param r: Количество выбираемых элементов.
    :return: Количество перестановок с повторениями (n^r).
    """
    if r > n:
        return 0
    return n ** r


def combinations(n, r):
    """
    Вычисляет количество комбинаций из n элементов по r.

    :param n: Общее количество элементов.
    :param r: Количество выбираемых элементов.
    :return: Количество комбинаций (n! / (r! * (n - r)!)).
    """
    if r > n:
        return 0
    return factorial(n) / (factorial(r) * factorial(n - r))


def combinationsWithRepetion(n, r):
    """
    Вычисляет количество комбинаций из n элементов с повторениями по r.

    :param n: Общее количество элементов.
    :param r: Количество выбираемых элементов.
    :return: Количество комбинаций с повторениями ((n + r - 1)! / (r! * (n - 1)!)).
    """
    if r > n:
        return 0
    return factorial(n + r - 1) / (factorial(r) * factorial(n - 1))


def Bernoulli(m, n, p):
    """
    Вычисляет вероятность m успехов в n испытаниях по распределению Бернулли.

    :param m: Количество успехов.
    :param n: Общее количество испытаний.
    :param p: Вероятность успеха в одном испытании.
    :return: Вероятность m успехов в n испытаниях.
    """
    if m > n:
        return 0
    return combinations(n, m) * (p ** m) * ((1 - p) ** (n - m))


def Poisson(n, m, p):
    """
    Вычисляет вероятность события по распределению Пуассона.

    :param n: Среднее количество событий за фиксированный интервал времени или пространства.
    :param m: Фиксированное количество событий.
    :param p: Вероятность события.
    :return: Вероятность наблюдения m событий при среднем количестве событий n * p.
    """

    return ((n * p) ** m) / factorial(m) * (2.71828 ** (-(n * p)))
