"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualRouterListener = void 0;
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualRouter.
 *
 * @experimental
 */
class VirtualRouterListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP, port);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http2(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP2, port);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static grpc(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.GRPC, port);
    }
    /**
     * (experimental) Returns a TCP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static tcp(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.TCP, port);
    }
}
exports.VirtualRouterListener = VirtualRouterListener;
class VirtualRouterListenerImpl extends VirtualRouterListener {
    constructor(protocol, port) {
        super();
        this.protocol = protocol;
        this.port = port !== null && port !== void 0 ? port : 8080;
    }
    bind(_scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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