# BillingAccount



# Description 

This page displays a table of billing accounts. The table shows the name, description, address, and code of each billing account. Buttons are available to refresh the list, create a new billing account, and search the list for a specific account. The user can select a billing account from the table, and delete the selected account using the delete button under the Actions column. 

# Instructions 

To refresh the list of billing accounts, click on the "Refresh List" button. To create a new billing account, click on the "Create" button. To search for a specific account, enter a search term in the Search field at the top of the page. 

To select a billing account from the table, click on the desired row. To delete a selected billing account, click on the "Delete" button under the Actions column. A confirmation dialog will appear, click "Confirm" to delete the selected account or "Cancel" to keep the account. 

To view the details of a selected billing account, click on the desired row. This will open a new page with more details about the account, such as associated products or services.

## BABillingAccount



## Description
This page displays information related to the billing account. The page is divided into four sections: Basic Information, Address, Status, and Assigned Persons. The Basic Information section displays the basic details of the billing account such as the account number, account holder name, and the account balance. The Address section displays the billing address associated with the account. The Status section displays the current status of the billing account, whether it is active or inactive. The Assigned Persons section displays the list of individuals or organizations assigned to handle the billing account.

## Instructions
To view the information of a particular section, click on the relevant tab on the page. By default, the Basic Information section is displayed. 
* To view the address information, click on the Address tab. 
* To view the status information, click on the Status tab.
* To view the list of assigned persons, click on the Assigned Persons tab.

Any changes made to the billing account information must be done through the appropriate channels, and users who are not authorized should avoid making any changes to this page.

## BABillingAccountBasicInfo



# Page Description:
This page is used to edit the basic information of a billing account.

# Instructions:
1. Name: Enter the name of the billing account in the field provided. This field is required.
2. Organization: Enter the organization associated with the billing account in the field provided. As you start typing, suggestions will be displayed to choose from. You can also select the organization from the dropdown list. This field is required.
3. Description: Enter a brief description of the billing account in the field provided.
4. Cancel: Click on the "Cancel" button to discard any changes made to the billing account and go back to the previous page.
5. Save: Click on the "Save" button to save any changes made to the billing account. This button will be disabled if the form is invalid or if no changes have been made.

## BABillingAccount$adr



## Description

The page shows a form to edit the address details of a billing account. The form includes fields for the country, place name, post number, post name, street name, home number, home letter, and formatted address. It also includes cancel and save buttons.

## Instructions

1. Fill in the required fields for the country, place name, post number, post name, street name, home number, and home letter.
2. The formatted address will be automatically generated based on the information provided in the form fields.
3. Review the formatted address.
4. Click the "Cancel" button to discard changes and return to the previous page.
5. Click the "Save" button to save the changes made to the billing account's address details. The "Save" button is disabled until all required fields are filled and the form is valid.

## BABillingAccountStatus



## Description

This page allows users to edit the billing account status information for an account.

## Instructions

1. To edit a billing account status, first, select a status from the 'Status' dropdown list.
2. Select a 'Valid From' and 'Valid Until' dates from the respective date picker fields.
3. If you know the 'ID' of the billing account status, you can enter it in the 'Id' field. However, this field is not editable.
4. Enter a 'Code' for the billing account status in the 'Code' field.
5. Once you have entered all the required fields, click on the 'Save' button to save the changes made or click on the 'Cancel' button to discard any changes made.

## BABillingAccountAssignedPersons



# Description
This page displays a table of assigned persons to billing accounts with the ability to create new records and delete existing ones. The table is responsive and supports pagination and sorting.

# Instructions
To refresh the table, click the "Refresh List" button. If the table is currently loading data, the button will be disabled.

To create a new record, click the "Create" button. If you are already adding a new record, the button will be disabled.

To delete a record, click the trash icon in the corresponding row.

To select a row, click anywhere on the row. Only a single row can be selected at a time.

If a row is selected, additional details will be displayed below the table at the "Assigned Person Details" tab.

## BABAAssignedPersonDet



# Page Description
This page displays a form for editing details of a person's assignment.

# Instructions
1. Enter the person's name in the 'Person' field or use the dropdown to select a person.
2. Select the status of the person's assignment from the 'Status' dropdown.
3. Select the start date of the person's assignment from the 'Valid From' calendar.
4. Select the end date of the person's assignment from the 'Valid Until' calendar.
5. Click the 'Cancel' button to discard changes and return to the previous page.
6. Click the 'Save' button to save changes. The button will be disabled until all required fields are filled and there were changes made in the form.

## BABAAssignedPersonRoles



# User documentation for BABA Assigned Person Roles Page

The BABA Assigned Person Roles page displays a table containing a list of assigned roles for a person in an organization. The table can be sorted based on various fields and can be paginated to control the number of records displayed per page. The user can also create, edit, or delete records from the table.

## Using the BABA Assigned Person Roles Page

To use this page, follow the steps below:

1. To refresh the list of BABA assigned person roles, click on the "Refresh" button located at top left of the page. Clicking on this button will fetch the latest data from the server and update the table.

2. To create a new BABA assigned person role, click on the "Create" button located at top left of the page. This button will open the "Create BABA Assigned Person Role" dialog box, where you can enter the details and save the new record.

3. To edit an existing BABA assigned person role, select the record from the table by clicking on any row. This will highlight the selected row and enable the "Edit" and "Delete" buttons located at the right side of the table. Click on the "Edit" button to open the "Edit BABA Assigned Person Role" dialog box, where you can modify the existing details and save the changes.

4. To delete an existing BABA assigned person role, select the record from the table by clicking on any row. This will highlight the selected row and enable the "Edit" and "Delete" buttons located at the right side of the table. Click on the "Delete" button to delete the selected record. A confirmation dialog box will appear to confirm the action.

5. The table can be sorted based on various fields such as org role, status, valid from, and valid until. Click on the column header of the field you want to sort by to sort the table in ascending or descending order.

6. The table is paginated to control the number of records displayed per page. Use the pagination controls at the bottom of the table to navigate between pages or to change the number of records displayed per page.

7. To view the details of a selected BABA assigned person role, click on any row in the table. The details of the selected record will be displayed in a separate section below the table.

## BABAAssignedPersonRoleDet



# Edit Assigned Person Role Details Page

The Edit Assigned Person Role Details page allows you to modify an assigned person role's organizational role, status, and validity dates.

To edit an assigned person role, follow these steps:

1. On the page, locate the **Orgrole** field and type the name of the desired organizational role. The field includes an autocomplete functionality to help you find the desired option quickly.

2. In the **Status** field, select the desired status for the assigned person role from the dropdown list.

3. In the **Valid From** field, select the start date of the assigned person role using the calendar tool.

4. In the **Valid Until** field, select the end date of the assigned person role using the calendar tool.

5. Click the "**Cancel**" button to discard your changes and return to the previous page.

6. Click the "**Save**" button to save your changes. Note that the button will be disabled until all required fields are completed and the form is valid.

## CAServiceAccounts



# CA Service Accounts Page

The CA Service Accounts page displays a table of all service accounts. Service accounts are used to establish a connection between the user's computer and the CA/Browser Forum's Certificate Transparency logs in order to monitor and detect improperly issued certificates. 

## Using the page

1. To refresh the list of service accounts, click the "Refresh List" button.
2. To create a new service account, click the "Create" button.
3. To view details of a service account, select it from the table and click the "Details" button.
4. To delete a service account, select it from the table and click the "Delete" button on the right side of the row.
5. To search for a specific service account, use the search box above the table.
6. To navigate through the pages of the table, use the pagination controls at the bottom of the table. 

Note: If a service account is currently being edited, its details will display in the JHI CA BA Tabs section below the table.

## CaBaAccordtion



# User Perspective

The page consists of two tabs: Basic Information and Status. Each tab displays different information related to a CA-BA entity.

# Instructions

To view the Basic Information tab, click on the header that reads "CA-BA Basic Information". To view the Status tab, click on the header that reads "CA-BA Status". The selected tab will highlight in blue.

Once the desired tab is selected, the related information will be displayed.

## CaBaBasicInfo



# Edit Basic Information Form

The Edit Basic Information Form allows the user to edit the basic information of a record. The form contains fields for Code, Name, Organization, and Description. 

## Instructions

1. Enter the details you want to edit
2. Check that the Code and Name fields are not empty. These fields are mandatory.
3. Click on the Cancel button to discard any changes
4. Click on the Save button to save the changes made to the record. The record will be updated with the information you have entered in the form.

## CaBaStatus



# Edit Status Form Page

This page is used to edit the status details of a record.

## Instructions 

1. Select the `Status` field and choose the desired status from the dropdown options.
2. Select the `Valid From` field and choose a valid date and time from the calendar pop-up.
3. Select the `Valid Until` field and choose a valid date and time from the calendar pop-up.
4. Once you have entered all the required details, click on the `Save` button to save the changes made to the record's status.
5. If you do not want to save the changes, you can click on the `Cancel` button to exit the form.

