# Copyright (C) 2022 Panther Labs Inc
#
# Panther Enterprise is licensed under the terms of a commercial license available from
# Panther Labs Inc ("Panther Commercial License") by contacting contact@runpanther.com.
# All use, distribution, and/or modification of this software, whether commercial or non-commercial,
# falls under the Panther Commercial License to the extent it is permitted.

# coding=utf-8
# *** WARNING: generated file
import typing
import dataclasses

"""
The detection module provides classes representing Panther detections: Rules, Policies, Scheduled Rules and more
"""

from .. import _utilities

__all__ = [
    "DynamicField",
    "_BaseFilter",
    "PythonFilter",
    "_BaseUnitTest",
    "JSONUnitTest",
    "DictUnitTest",
    "Rule",
    "SeverityLow",
    "SeverityInfo",
    "SeverityMedium",
    "SeverityHigh",
    "SeverityCritical",
    "ReportKeyMITRE",
]


SeverityLow = "LOW"
SeverityInfo = "INFO"
SeverityMedium = "MEDIUM"
SeverityHigh = "HIGH"
SeverityCritical = "CRITICAL"
ReportKeyMITRE = "MITRE ATT&CK"


@dataclasses.dataclass(frozen=True)
class DynamicField(_utilities.ConfigNode):
    """Make a field dynamic based on the detection input

    Attributes:
        - func -- Dynamic handler (required)
        - fallback -- Fallback value in case the dynamic handler fails (optional, default: "")

    """

    # required
    func: typing.Callable[[typing.Any], bool]

    # optional
    fallback: str = ""

    # internal private methods
    def _typename(self) -> str:
        return "DynamicField"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return ["func", "fallback"]


@dataclasses.dataclass(frozen=True)
class _BaseFilter(_utilities.ConfigNode):
    """Base filter"""

    # internal private methods
    def _typename(self) -> str:
        return "_BaseFilter"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return []


@dataclasses.dataclass(frozen=True)
class PythonFilter(_BaseFilter):
    """Custom python filter

    Attributes:
        - func -- Custom python filter (required)
        - params -- Custom python filter (optional, default: None)

    """

    # required
    func: typing.Callable[
        [
            typing.Any,
            typing.Optional[typing.Dict[str, typing.Union[str, int, float, bool]]],
        ],
        bool,
    ]

    # optional
    params: typing.Optional[
        typing.Dict[str, typing.Union[str, int, float, bool]]
    ] = None

    # internal private methods
    def _typename(self) -> str:
        return "PythonFilter"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return ["func", "params"]


@dataclasses.dataclass(frozen=True)
class _BaseUnitTest(_utilities.ConfigNode):
    """Base unit test"""

    # internal private methods
    def _typename(self) -> str:
        return "_BaseUnitTest"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return []


@dataclasses.dataclass(frozen=True)
class JSONUnitTest(_BaseUnitTest):
    """Unit test with json content

    Attributes:
        - data -- json data (required)
        - name -- name of the unit test (required)

    """

    # required
    data: str

    # required
    name: str

    # internal private methods
    def _typename(self) -> str:
        return "JSONUnitTest"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return ["data", "name"]


@dataclasses.dataclass(frozen=True)
class DictUnitTest(_BaseUnitTest):
    """Unit test with python dict content

    Attributes:
        - data -- json data (required)

    """

    # required
    data: typing.Dict[str, typing.Any]

    # internal private methods
    def _typename(self) -> str:
        return "DictUnitTest"

    def _output_key(self) -> str:
        return ""

    def _fields(self) -> typing.List[str]:
        return ["data"]


@dataclasses.dataclass(frozen=True)
class Rule(_utilities.ConfigNode):
    """Define a rule

    Attributes:
        - filters -- Define event filters for the rule (required)
        - log_types -- Log Types to associate with this rule (required)
        - rule_id -- ID for the rule (required)
        - severity -- Severity for the rule (required)
        - alert_context -- Optional JSON to attach to alerts generated by this rule (optional, default: None)
        - enabled -- Short description for the query (optional, default: True)
        - name -- Display name for the rule (optional, default: "")
        - reference -- Reference for the rule (optional, default: "")
        - reports -- Report mappings for the rule (optional, default: None)
        - runbook -- Runbook for the rule (optional, default: "")
        - summary_attrs -- Summary Attributes for the rule (optional, default: None)
        - tags -- Tags for the rule (optional, default: None)
        - unit_tests -- Define event filters for the rule (optional, default: None)

    """

    # required
    filters: typing.Union[_BaseFilter, typing.List[_BaseFilter]]

    # required
    log_types: typing.Union[str, typing.List[str]]

    # required
    rule_id: str

    # required
    severity: str

    # optional
    alert_context: typing.Optional[typing.Callable[[typing.Any], str]] = None

    # optional
    enabled: bool = True

    # optional
    name: typing.Optional[typing.Union[str, DynamicField]] = ""

    # optional
    reference: typing.Optional[typing.Union[str, DynamicField]] = ""

    # optional
    reports: typing.Optional[typing.Dict[str, typing.List[str]]] = None

    # optional
    runbook: typing.Optional[typing.Union[str, DynamicField]] = ""

    # optional
    summary_attrs: typing.Optional[typing.List[str]] = None

    # optional
    tags: typing.Optional[typing.Union[str, typing.List[str]]] = None

    # optional
    unit_tests: typing.Optional[
        typing.Union[_BaseFilter, typing.List[_BaseFilter]]
    ] = None

    # internal private methods
    def _typename(self) -> str:
        return "Rule"

    def _output_key(self) -> str:
        return "config-node:rule"

    def _fields(self) -> typing.List[str]:
        return [
            "filters",
            "log_types",
            "rule_id",
            "severity",
            "alert_context",
            "enabled",
            "name",
            "reference",
            "reports",
            "runbook",
            "summary_attrs",
            "tags",
            "unit_tests",
        ]
