# Panther Config SDK
The Panther Config module allows you to configure detections for your [Panther](https://panther.com) instance.

## Install
The Panther Config SDK can be installed using PIP.

```sh
pip3 install panther-config==0.0.7
```


## query module

### CronSchedule
Cron expression based schedule definition for a query

| Field | Type | Description |
| ----- | ---- | ----------- |
| `expression` | `str` | Defines how often queries using this schedule run |
| `timeout_minutes` | `int` | Defines the timeout applied to queries with this schedule |


### IntervalSchedule
Interval based schedule definition for a query

| Field | Type | Description |
| ----- | ---- | ----------- |
| `rate_minutes` | `int` | Defines how often queries using this schedule run |
| `timeout_minutes` | `int` | Defines the timeout applied to queries with this schedule |


### Query
A saved or scheduled query

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | `str` | Unique name for the query |
| `description` | `str` | Short description for the query |
| `default_database` | `str` | Default database for the query |
| `sql` | `str` | SQL statement |
| `enabled` | `bool` | Short description for the query |
| `tags` | `typing.Optional[typing.Union[str, typing.List[str]]]` | Tags for the query |
| `schedule` | `typing.Optional[typing.Optional[typing.Union[IntervalSchedule, CronSchedule]]]` | Schedule attached to the query |

## detection module

### DynamicField
Make a field dynamic based on the detection input

| Field | Type | Description |
| ----- | ---- | ----------- |
| `fallback` | `str` | Fallback value in case the dynamic handler fails |
| `func` | `typing.Callable[[typing.Any], bool]` | Dynamic handler |



### PythonFilter
Custom python filter

| Field | Type | Description |
| ----- | ---- | ----------- |
| `func` | `typing.Callable[[typing.Any, typing.Optional[typing.Dict[str, typing.Union[str, int, float, bool]]]], bool]` | Custom python filter |
| `params` | `typing.Optional[typing.Dict[str, typing.Union[str, int, float, bool]]]` | Custom python filter |



### JSONUnitTest
Unit test with json content

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | `str` | name of the unit test |
| `data` | `str` | json data |


### DictUnitTest
Unit test with python dict content

| Field | Type | Description |
| ----- | ---- | ----------- |
| `data` | `typing.Dict[str, typing.Any]` | json data |


### Rule
Define a rule

| Field | Type | Description |
| ----- | ---- | ----------- |
| `rule_id` | `str` | ID for the rule |
| `severity` | `str` | Severity for the rule |
| `name` | `typing.Optional[typing.Union[str, DynamicField]]` | Display name for the rule |
| `log_types` | `typing.Union[str, typing.List[str]]` | Log Types to associate with this rule |
| `filters` | `typing.Union[_BaseFilter, typing.List[_BaseFilter]]` | Define event filters for the rule |
| `enabled` | `bool` | Short description for the query |
| `unit_tests` | `typing.Optional[typing.Union[_BaseFilter, typing.List[_BaseFilter]]]` | Define event filters for the rule |
| `tags` | `typing.Optional[typing.Union[str, typing.List[str]]]` | Tags for the rule |
| `reference` | `typing.Optional[typing.Union[str, DynamicField]]` | Reference for the rule |
| `runbook` | `typing.Optional[typing.Union[str, DynamicField]]` | Runbook for the rule |
| `summary_attrs` | `typing.Optional[typing.List[str]]` | Summary Attributes for the rule |
| `reports` | `typing.Optional[typing.Dict[str, typing.List[str]]]` | Report mappings for the rule |
| `alert_context` | `typing.Optional[typing.Callable[[typing.Any], str]]` | Optional JSON to attach to alerts generated by this rule |
