# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PermissionGroupArgs', 'PermissionGroup']

@pulumi.input_type
class PermissionGroupArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 accesstype: Optional[pulumi.Input[str]] = None,
                 can_createorupdate_config: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_environment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_segment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_setting: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_tag: Optional[pulumi.Input[bool]] = None,
                 can_delete_config: Optional[pulumi.Input[bool]] = None,
                 can_delete_environment: Optional[pulumi.Input[bool]] = None,
                 can_delete_segment: Optional[pulumi.Input[bool]] = None,
                 can_delete_setting: Optional[pulumi.Input[bool]] = None,
                 can_delete_tag: Optional[pulumi.Input[bool]] = None,
                 can_manage_integrations: Optional[pulumi.Input[bool]] = None,
                 can_manage_members: Optional[pulumi.Input[bool]] = None,
                 can_manage_product_preferences: Optional[pulumi.Input[bool]] = None,
                 can_manage_webhook: Optional[pulumi.Input[bool]] = None,
                 can_rotate_sdkkey: Optional[pulumi.Input[bool]] = None,
                 can_tag_setting: Optional[pulumi.Input[bool]] = None,
                 can_use_exportimport: Optional[pulumi.Input[bool]] = None,
                 can_view_product_auditlog: Optional[pulumi.Input[bool]] = None,
                 can_view_product_statistics: Optional[pulumi.Input[bool]] = None,
                 can_view_sdkkey: Optional[pulumi.Input[bool]] = None,
                 environment_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_environment_accesstype: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PermissionGroup resource.
        :param pulumi.Input[str] product_id: The ID of the Product.
        :param pulumi.Input[str] accesstype: Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        :param pulumi.Input[bool] can_createorupdate_config: Group members can create/update Configs. Default: false.
        :param pulumi.Input[bool] can_createorupdate_environment: Group members can create/update Environments. Default: false.
        :param pulumi.Input[bool] can_createorupdate_setting: Group members can create/update Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_createorupdate_tag: Group members can create/update Tags. Default: false.
        :param pulumi.Input[bool] can_delete_config: Group members can delete Configs. Default: false.
        :param pulumi.Input[bool] can_delete_environment: Group members can delete Environments. Default: false.
        :param pulumi.Input[bool] can_delete_setting: Group members can delete Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_delete_tag: Group members can delete Tags. Default: false.
        :param pulumi.Input[bool] can_manage_integrations: Group members can add and configure integrations. Default: false.
        :param pulumi.Input[bool] can_manage_members: Group members can manage team members. Default: false.
        :param pulumi.Input[bool] can_manage_product_preferences: Group members can update Product preferences. Default: false.
        :param pulumi.Input[bool] can_manage_webhook: Group members can create/update/delete Webhooks. Default: false.
        :param pulumi.Input[bool] can_rotate_sdkkey: Group members can rotate SDK keys. Default: false.
        :param pulumi.Input[bool] can_tag_setting: Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_use_exportimport: Group members can use the export/import feature. Default: false.
        :param pulumi.Input[bool] can_view_product_auditlog: Group members has access to audit logs. Default: false.
        :param pulumi.Input[bool] can_view_product_statistics: Group members has access to product statistics. Default: false.
        :param pulumi.Input[bool] can_view_sdkkey: Group members has access to SDK keys. Default: false.
        :param pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]] environment_accesses: The environment specific permissions list block defined as below.
        :param pulumi.Input[str] name: The name of the Permission Group.
        :param pulumi.Input[str] new_environment_accesstype: Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        """
        pulumi.set(__self__, "product_id", product_id)
        if accesstype is not None:
            pulumi.set(__self__, "accesstype", accesstype)
        if can_createorupdate_config is not None:
            pulumi.set(__self__, "can_createorupdate_config", can_createorupdate_config)
        if can_createorupdate_environment is not None:
            pulumi.set(__self__, "can_createorupdate_environment", can_createorupdate_environment)
        if can_createorupdate_segment is not None:
            pulumi.set(__self__, "can_createorupdate_segment", can_createorupdate_segment)
        if can_createorupdate_setting is not None:
            pulumi.set(__self__, "can_createorupdate_setting", can_createorupdate_setting)
        if can_createorupdate_tag is not None:
            pulumi.set(__self__, "can_createorupdate_tag", can_createorupdate_tag)
        if can_delete_config is not None:
            pulumi.set(__self__, "can_delete_config", can_delete_config)
        if can_delete_environment is not None:
            pulumi.set(__self__, "can_delete_environment", can_delete_environment)
        if can_delete_segment is not None:
            pulumi.set(__self__, "can_delete_segment", can_delete_segment)
        if can_delete_setting is not None:
            pulumi.set(__self__, "can_delete_setting", can_delete_setting)
        if can_delete_tag is not None:
            pulumi.set(__self__, "can_delete_tag", can_delete_tag)
        if can_manage_integrations is not None:
            pulumi.set(__self__, "can_manage_integrations", can_manage_integrations)
        if can_manage_members is not None:
            pulumi.set(__self__, "can_manage_members", can_manage_members)
        if can_manage_product_preferences is not None:
            pulumi.set(__self__, "can_manage_product_preferences", can_manage_product_preferences)
        if can_manage_webhook is not None:
            pulumi.set(__self__, "can_manage_webhook", can_manage_webhook)
        if can_rotate_sdkkey is not None:
            pulumi.set(__self__, "can_rotate_sdkkey", can_rotate_sdkkey)
        if can_tag_setting is not None:
            pulumi.set(__self__, "can_tag_setting", can_tag_setting)
        if can_use_exportimport is not None:
            pulumi.set(__self__, "can_use_exportimport", can_use_exportimport)
        if can_view_product_auditlog is not None:
            pulumi.set(__self__, "can_view_product_auditlog", can_view_product_auditlog)
        if can_view_product_statistics is not None:
            pulumi.set(__self__, "can_view_product_statistics", can_view_product_statistics)
        if can_view_sdkkey is not None:
            pulumi.set(__self__, "can_view_sdkkey", can_view_sdkkey)
        if environment_accesses is not None:
            pulumi.set(__self__, "environment_accesses", environment_accesses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_environment_accesstype is not None:
            pulumi.set(__self__, "new_environment_accesstype", new_environment_accesstype)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def accesstype(self) -> Optional[pulumi.Input[str]]:
        """
        Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        """
        return pulumi.get(self, "accesstype")

    @accesstype.setter
    def accesstype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accesstype", value)

    @property
    @pulumi.getter(name="canCreateorupdateConfig")
    def can_createorupdate_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Configs. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_config")

    @can_createorupdate_config.setter
    def can_createorupdate_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_config", value)

    @property
    @pulumi.getter(name="canCreateorupdateEnvironment")
    def can_createorupdate_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Environments. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_environment")

    @can_createorupdate_environment.setter
    def can_createorupdate_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_environment", value)

    @property
    @pulumi.getter(name="canCreateorupdateSegment")
    def can_createorupdate_segment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "can_createorupdate_segment")

    @can_createorupdate_segment.setter
    def can_createorupdate_segment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_segment", value)

    @property
    @pulumi.getter(name="canCreateorupdateSetting")
    def can_createorupdate_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_setting")

    @can_createorupdate_setting.setter
    def can_createorupdate_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_setting", value)

    @property
    @pulumi.getter(name="canCreateorupdateTag")
    def can_createorupdate_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Tags. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_tag")

    @can_createorupdate_tag.setter
    def can_createorupdate_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_tag", value)

    @property
    @pulumi.getter(name="canDeleteConfig")
    def can_delete_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Configs. Default: false.
        """
        return pulumi.get(self, "can_delete_config")

    @can_delete_config.setter
    def can_delete_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_config", value)

    @property
    @pulumi.getter(name="canDeleteEnvironment")
    def can_delete_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Environments. Default: false.
        """
        return pulumi.get(self, "can_delete_environment")

    @can_delete_environment.setter
    def can_delete_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_environment", value)

    @property
    @pulumi.getter(name="canDeleteSegment")
    def can_delete_segment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "can_delete_segment")

    @can_delete_segment.setter
    def can_delete_segment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_segment", value)

    @property
    @pulumi.getter(name="canDeleteSetting")
    def can_delete_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_delete_setting")

    @can_delete_setting.setter
    def can_delete_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_setting", value)

    @property
    @pulumi.getter(name="canDeleteTag")
    def can_delete_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Tags. Default: false.
        """
        return pulumi.get(self, "can_delete_tag")

    @can_delete_tag.setter
    def can_delete_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_tag", value)

    @property
    @pulumi.getter(name="canManageIntegrations")
    def can_manage_integrations(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can add and configure integrations. Default: false.
        """
        return pulumi.get(self, "can_manage_integrations")

    @can_manage_integrations.setter
    def can_manage_integrations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_integrations", value)

    @property
    @pulumi.getter(name="canManageMembers")
    def can_manage_members(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can manage team members. Default: false.
        """
        return pulumi.get(self, "can_manage_members")

    @can_manage_members.setter
    def can_manage_members(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_members", value)

    @property
    @pulumi.getter(name="canManageProductPreferences")
    def can_manage_product_preferences(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can update Product preferences. Default: false.
        """
        return pulumi.get(self, "can_manage_product_preferences")

    @can_manage_product_preferences.setter
    def can_manage_product_preferences(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_product_preferences", value)

    @property
    @pulumi.getter(name="canManageWebhook")
    def can_manage_webhook(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update/delete Webhooks. Default: false.
        """
        return pulumi.get(self, "can_manage_webhook")

    @can_manage_webhook.setter
    def can_manage_webhook(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_webhook", value)

    @property
    @pulumi.getter(name="canRotateSdkkey")
    def can_rotate_sdkkey(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can rotate SDK keys. Default: false.
        """
        return pulumi.get(self, "can_rotate_sdkkey")

    @can_rotate_sdkkey.setter
    def can_rotate_sdkkey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_rotate_sdkkey", value)

    @property
    @pulumi.getter(name="canTagSetting")
    def can_tag_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_tag_setting")

    @can_tag_setting.setter
    def can_tag_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_tag_setting", value)

    @property
    @pulumi.getter(name="canUseExportimport")
    def can_use_exportimport(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can use the export/import feature. Default: false.
        """
        return pulumi.get(self, "can_use_exportimport")

    @can_use_exportimport.setter
    def can_use_exportimport(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_use_exportimport", value)

    @property
    @pulumi.getter(name="canViewProductAuditlog")
    def can_view_product_auditlog(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to audit logs. Default: false.
        """
        return pulumi.get(self, "can_view_product_auditlog")

    @can_view_product_auditlog.setter
    def can_view_product_auditlog(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_product_auditlog", value)

    @property
    @pulumi.getter(name="canViewProductStatistics")
    def can_view_product_statistics(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to product statistics. Default: false.
        """
        return pulumi.get(self, "can_view_product_statistics")

    @can_view_product_statistics.setter
    def can_view_product_statistics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_product_statistics", value)

    @property
    @pulumi.getter(name="canViewSdkkey")
    def can_view_sdkkey(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to SDK keys. Default: false.
        """
        return pulumi.get(self, "can_view_sdkkey")

    @can_view_sdkkey.setter
    def can_view_sdkkey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_sdkkey", value)

    @property
    @pulumi.getter(name="environmentAccesses")
    def environment_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]]:
        """
        The environment specific permissions list block defined as below.
        """
        return pulumi.get(self, "environment_accesses")

    @environment_accesses.setter
    def environment_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]]):
        pulumi.set(self, "environment_accesses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Permission Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newEnvironmentAccesstype")
    def new_environment_accesstype(self) -> Optional[pulumi.Input[str]]:
        """
        Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        """
        return pulumi.get(self, "new_environment_accesstype")

    @new_environment_accesstype.setter
    def new_environment_accesstype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_environment_accesstype", value)


@pulumi.input_type
class _PermissionGroupState:
    def __init__(__self__, *,
                 accesstype: Optional[pulumi.Input[str]] = None,
                 can_createorupdate_config: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_environment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_segment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_setting: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_tag: Optional[pulumi.Input[bool]] = None,
                 can_delete_config: Optional[pulumi.Input[bool]] = None,
                 can_delete_environment: Optional[pulumi.Input[bool]] = None,
                 can_delete_segment: Optional[pulumi.Input[bool]] = None,
                 can_delete_setting: Optional[pulumi.Input[bool]] = None,
                 can_delete_tag: Optional[pulumi.Input[bool]] = None,
                 can_manage_integrations: Optional[pulumi.Input[bool]] = None,
                 can_manage_members: Optional[pulumi.Input[bool]] = None,
                 can_manage_product_preferences: Optional[pulumi.Input[bool]] = None,
                 can_manage_webhook: Optional[pulumi.Input[bool]] = None,
                 can_rotate_sdkkey: Optional[pulumi.Input[bool]] = None,
                 can_tag_setting: Optional[pulumi.Input[bool]] = None,
                 can_use_exportimport: Optional[pulumi.Input[bool]] = None,
                 can_view_product_auditlog: Optional[pulumi.Input[bool]] = None,
                 can_view_product_statistics: Optional[pulumi.Input[bool]] = None,
                 can_view_sdkkey: Optional[pulumi.Input[bool]] = None,
                 environment_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_environment_accesstype: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PermissionGroup resources.
        :param pulumi.Input[str] accesstype: Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        :param pulumi.Input[bool] can_createorupdate_config: Group members can create/update Configs. Default: false.
        :param pulumi.Input[bool] can_createorupdate_environment: Group members can create/update Environments. Default: false.
        :param pulumi.Input[bool] can_createorupdate_setting: Group members can create/update Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_createorupdate_tag: Group members can create/update Tags. Default: false.
        :param pulumi.Input[bool] can_delete_config: Group members can delete Configs. Default: false.
        :param pulumi.Input[bool] can_delete_environment: Group members can delete Environments. Default: false.
        :param pulumi.Input[bool] can_delete_setting: Group members can delete Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_delete_tag: Group members can delete Tags. Default: false.
        :param pulumi.Input[bool] can_manage_integrations: Group members can add and configure integrations. Default: false.
        :param pulumi.Input[bool] can_manage_members: Group members can manage team members. Default: false.
        :param pulumi.Input[bool] can_manage_product_preferences: Group members can update Product preferences. Default: false.
        :param pulumi.Input[bool] can_manage_webhook: Group members can create/update/delete Webhooks. Default: false.
        :param pulumi.Input[bool] can_rotate_sdkkey: Group members can rotate SDK keys. Default: false.
        :param pulumi.Input[bool] can_tag_setting: Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_use_exportimport: Group members can use the export/import feature. Default: false.
        :param pulumi.Input[bool] can_view_product_auditlog: Group members has access to audit logs. Default: false.
        :param pulumi.Input[bool] can_view_product_statistics: Group members has access to product statistics. Default: false.
        :param pulumi.Input[bool] can_view_sdkkey: Group members has access to SDK keys. Default: false.
        :param pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]] environment_accesses: The environment specific permissions list block defined as below.
        :param pulumi.Input[str] name: The name of the Permission Group.
        :param pulumi.Input[str] new_environment_accesstype: Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        :param pulumi.Input[str] product_id: The ID of the Product.
        """
        if accesstype is not None:
            pulumi.set(__self__, "accesstype", accesstype)
        if can_createorupdate_config is not None:
            pulumi.set(__self__, "can_createorupdate_config", can_createorupdate_config)
        if can_createorupdate_environment is not None:
            pulumi.set(__self__, "can_createorupdate_environment", can_createorupdate_environment)
        if can_createorupdate_segment is not None:
            pulumi.set(__self__, "can_createorupdate_segment", can_createorupdate_segment)
        if can_createorupdate_setting is not None:
            pulumi.set(__self__, "can_createorupdate_setting", can_createorupdate_setting)
        if can_createorupdate_tag is not None:
            pulumi.set(__self__, "can_createorupdate_tag", can_createorupdate_tag)
        if can_delete_config is not None:
            pulumi.set(__self__, "can_delete_config", can_delete_config)
        if can_delete_environment is not None:
            pulumi.set(__self__, "can_delete_environment", can_delete_environment)
        if can_delete_segment is not None:
            pulumi.set(__self__, "can_delete_segment", can_delete_segment)
        if can_delete_setting is not None:
            pulumi.set(__self__, "can_delete_setting", can_delete_setting)
        if can_delete_tag is not None:
            pulumi.set(__self__, "can_delete_tag", can_delete_tag)
        if can_manage_integrations is not None:
            pulumi.set(__self__, "can_manage_integrations", can_manage_integrations)
        if can_manage_members is not None:
            pulumi.set(__self__, "can_manage_members", can_manage_members)
        if can_manage_product_preferences is not None:
            pulumi.set(__self__, "can_manage_product_preferences", can_manage_product_preferences)
        if can_manage_webhook is not None:
            pulumi.set(__self__, "can_manage_webhook", can_manage_webhook)
        if can_rotate_sdkkey is not None:
            pulumi.set(__self__, "can_rotate_sdkkey", can_rotate_sdkkey)
        if can_tag_setting is not None:
            pulumi.set(__self__, "can_tag_setting", can_tag_setting)
        if can_use_exportimport is not None:
            pulumi.set(__self__, "can_use_exportimport", can_use_exportimport)
        if can_view_product_auditlog is not None:
            pulumi.set(__self__, "can_view_product_auditlog", can_view_product_auditlog)
        if can_view_product_statistics is not None:
            pulumi.set(__self__, "can_view_product_statistics", can_view_product_statistics)
        if can_view_sdkkey is not None:
            pulumi.set(__self__, "can_view_sdkkey", can_view_sdkkey)
        if environment_accesses is not None:
            pulumi.set(__self__, "environment_accesses", environment_accesses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_environment_accesstype is not None:
            pulumi.set(__self__, "new_environment_accesstype", new_environment_accesstype)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)

    @property
    @pulumi.getter
    def accesstype(self) -> Optional[pulumi.Input[str]]:
        """
        Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        """
        return pulumi.get(self, "accesstype")

    @accesstype.setter
    def accesstype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accesstype", value)

    @property
    @pulumi.getter(name="canCreateorupdateConfig")
    def can_createorupdate_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Configs. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_config")

    @can_createorupdate_config.setter
    def can_createorupdate_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_config", value)

    @property
    @pulumi.getter(name="canCreateorupdateEnvironment")
    def can_createorupdate_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Environments. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_environment")

    @can_createorupdate_environment.setter
    def can_createorupdate_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_environment", value)

    @property
    @pulumi.getter(name="canCreateorupdateSegment")
    def can_createorupdate_segment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "can_createorupdate_segment")

    @can_createorupdate_segment.setter
    def can_createorupdate_segment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_segment", value)

    @property
    @pulumi.getter(name="canCreateorupdateSetting")
    def can_createorupdate_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_setting")

    @can_createorupdate_setting.setter
    def can_createorupdate_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_setting", value)

    @property
    @pulumi.getter(name="canCreateorupdateTag")
    def can_createorupdate_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update Tags. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_tag")

    @can_createorupdate_tag.setter
    def can_createorupdate_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_createorupdate_tag", value)

    @property
    @pulumi.getter(name="canDeleteConfig")
    def can_delete_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Configs. Default: false.
        """
        return pulumi.get(self, "can_delete_config")

    @can_delete_config.setter
    def can_delete_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_config", value)

    @property
    @pulumi.getter(name="canDeleteEnvironment")
    def can_delete_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Environments. Default: false.
        """
        return pulumi.get(self, "can_delete_environment")

    @can_delete_environment.setter
    def can_delete_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_environment", value)

    @property
    @pulumi.getter(name="canDeleteSegment")
    def can_delete_segment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "can_delete_segment")

    @can_delete_segment.setter
    def can_delete_segment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_segment", value)

    @property
    @pulumi.getter(name="canDeleteSetting")
    def can_delete_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_delete_setting")

    @can_delete_setting.setter
    def can_delete_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_setting", value)

    @property
    @pulumi.getter(name="canDeleteTag")
    def can_delete_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can delete Tags. Default: false.
        """
        return pulumi.get(self, "can_delete_tag")

    @can_delete_tag.setter
    def can_delete_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete_tag", value)

    @property
    @pulumi.getter(name="canManageIntegrations")
    def can_manage_integrations(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can add and configure integrations. Default: false.
        """
        return pulumi.get(self, "can_manage_integrations")

    @can_manage_integrations.setter
    def can_manage_integrations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_integrations", value)

    @property
    @pulumi.getter(name="canManageMembers")
    def can_manage_members(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can manage team members. Default: false.
        """
        return pulumi.get(self, "can_manage_members")

    @can_manage_members.setter
    def can_manage_members(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_members", value)

    @property
    @pulumi.getter(name="canManageProductPreferences")
    def can_manage_product_preferences(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can update Product preferences. Default: false.
        """
        return pulumi.get(self, "can_manage_product_preferences")

    @can_manage_product_preferences.setter
    def can_manage_product_preferences(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_product_preferences", value)

    @property
    @pulumi.getter(name="canManageWebhook")
    def can_manage_webhook(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can create/update/delete Webhooks. Default: false.
        """
        return pulumi.get(self, "can_manage_webhook")

    @can_manage_webhook.setter
    def can_manage_webhook(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage_webhook", value)

    @property
    @pulumi.getter(name="canRotateSdkkey")
    def can_rotate_sdkkey(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can rotate SDK keys. Default: false.
        """
        return pulumi.get(self, "can_rotate_sdkkey")

    @can_rotate_sdkkey.setter
    def can_rotate_sdkkey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_rotate_sdkkey", value)

    @property
    @pulumi.getter(name="canTagSetting")
    def can_tag_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_tag_setting")

    @can_tag_setting.setter
    def can_tag_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_tag_setting", value)

    @property
    @pulumi.getter(name="canUseExportimport")
    def can_use_exportimport(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members can use the export/import feature. Default: false.
        """
        return pulumi.get(self, "can_use_exportimport")

    @can_use_exportimport.setter
    def can_use_exportimport(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_use_exportimport", value)

    @property
    @pulumi.getter(name="canViewProductAuditlog")
    def can_view_product_auditlog(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to audit logs. Default: false.
        """
        return pulumi.get(self, "can_view_product_auditlog")

    @can_view_product_auditlog.setter
    def can_view_product_auditlog(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_product_auditlog", value)

    @property
    @pulumi.getter(name="canViewProductStatistics")
    def can_view_product_statistics(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to product statistics. Default: false.
        """
        return pulumi.get(self, "can_view_product_statistics")

    @can_view_product_statistics.setter
    def can_view_product_statistics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_product_statistics", value)

    @property
    @pulumi.getter(name="canViewSdkkey")
    def can_view_sdkkey(self) -> Optional[pulumi.Input[bool]]:
        """
        Group members has access to SDK keys. Default: false.
        """
        return pulumi.get(self, "can_view_sdkkey")

    @can_view_sdkkey.setter
    def can_view_sdkkey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_view_sdkkey", value)

    @property
    @pulumi.getter(name="environmentAccesses")
    def environment_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]]:
        """
        The environment specific permissions list block defined as below.
        """
        return pulumi.get(self, "environment_accesses")

    @environment_accesses.setter
    def environment_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupEnvironmentAccessArgs']]]]):
        pulumi.set(self, "environment_accesses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Permission Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newEnvironmentAccesstype")
    def new_environment_accesstype(self) -> Optional[pulumi.Input[str]]:
        """
        Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        """
        return pulumi.get(self, "new_environment_accesstype")

    @new_environment_accesstype.setter
    def new_environment_accesstype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_environment_accesstype", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)


class PermissionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accesstype: Optional[pulumi.Input[str]] = None,
                 can_createorupdate_config: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_environment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_segment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_setting: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_tag: Optional[pulumi.Input[bool]] = None,
                 can_delete_config: Optional[pulumi.Input[bool]] = None,
                 can_delete_environment: Optional[pulumi.Input[bool]] = None,
                 can_delete_segment: Optional[pulumi.Input[bool]] = None,
                 can_delete_setting: Optional[pulumi.Input[bool]] = None,
                 can_delete_tag: Optional[pulumi.Input[bool]] = None,
                 can_manage_integrations: Optional[pulumi.Input[bool]] = None,
                 can_manage_members: Optional[pulumi.Input[bool]] = None,
                 can_manage_product_preferences: Optional[pulumi.Input[bool]] = None,
                 can_manage_webhook: Optional[pulumi.Input[bool]] = None,
                 can_rotate_sdkkey: Optional[pulumi.Input[bool]] = None,
                 can_tag_setting: Optional[pulumi.Input[bool]] = None,
                 can_use_exportimport: Optional[pulumi.Input[bool]] = None,
                 can_view_product_auditlog: Optional[pulumi.Input[bool]] = None,
                 can_view_product_statistics: Optional[pulumi.Input[bool]] = None,
                 can_view_sdkkey: Optional[pulumi.Input[bool]] = None,
                 environment_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionGroupEnvironmentAccessArgs', 'PermissionGroupEnvironmentAccessArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_environment_accesstype: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # PermissionGroup Resource

        Creates and manages a **Permission Group**. [What is a Permission Group in ConfigCat?](https://configcat.com/docs/advanced/team-management/team-management-basics/#permissions--permission-groups-product-level)

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_configcat as configcat
        import pulumiverse_configcat as configcat

        my_products = configcat.get_products(name_filter_regex="ConfigCat's product")
        my_permission_group = configcat.PermissionGroup("my_permission_group",
            product_id=my_products.products[0].product_id,
            name="Administrators",
            accesstype="full",
            can_manage_members=True,
            can_createorupdate_config=True,
            can_delete_config=True,
            can_createorupdate_environment=True,
            can_delete_environment=True,
            can_createorupdate_setting=True,
            can_tag_setting=True,
            can_delete_setting=True,
            can_createorupdate_tag=True,
            can_delete_tag=True,
            can_manage_webhook=True,
            can_use_exportimport=True,
            can_manage_product_preferences=True,
            can_manage_integrations=True,
            can_view_sdkkey=True,
            can_rotate_sdkkey=True,
            can_createorupdate_segment=True,
            can_delete_segment=True,
            can_view_product_auditlog=True,
            can_view_product_statistics=True)
        pulumi.export("permissionGroupId", my_permission_group.id)
        ```

        ```python
        import pulumi
        import pulumi_configcat as configcat
        import pulumiverse_configcat as configcat

        my_products = configcat.get_products(name_filter_regex="ConfigCat's product")
        my_test_environments = configcat.get_environments(name_filter_regex="Test")
        my_production_environments = configcat.get_environments(name_filter_regex="Production")
        my_permission_group = configcat.PermissionGroup("my_permission_group",
            product_id=my_products.products[0].product_id,
            name="Read only except Test environment",
            accesstype="custom",
            environment_accesses=[
                {
                    "environment_id": my_test_environments.environments[0].environment_id,
                    "environment_accesstype": "full",
                },
                {
                    "environment_id": my_production_environments.environments[0].environment_id,
                    "environment_accesstype": "none",
                },
            ])
        pulumi.export("permissionGroupId", my_permission_group.id)
        ```

        ## Endpoints used

        * [Get Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/get-permission-group)
        * [Create Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/create-permission-group)
        * [Update Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/update-permission-group)
        * [Delete Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/delete-permission-group)

        ## Import

        Permission Groups can be imported using the PermissionGroupId. Get the PermissionGroupId using the [List Permission Groups API](https://api.configcat.com/docs/#tag/Permission-Groups/operation/get-permission-groups) for example.

        ```sh
        $ pulumi import configcat:index/permissionGroup:PermissionGroup example 123
        ```
        Read more about importing.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accesstype: Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        :param pulumi.Input[bool] can_createorupdate_config: Group members can create/update Configs. Default: false.
        :param pulumi.Input[bool] can_createorupdate_environment: Group members can create/update Environments. Default: false.
        :param pulumi.Input[bool] can_createorupdate_setting: Group members can create/update Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_createorupdate_tag: Group members can create/update Tags. Default: false.
        :param pulumi.Input[bool] can_delete_config: Group members can delete Configs. Default: false.
        :param pulumi.Input[bool] can_delete_environment: Group members can delete Environments. Default: false.
        :param pulumi.Input[bool] can_delete_setting: Group members can delete Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_delete_tag: Group members can delete Tags. Default: false.
        :param pulumi.Input[bool] can_manage_integrations: Group members can add and configure integrations. Default: false.
        :param pulumi.Input[bool] can_manage_members: Group members can manage team members. Default: false.
        :param pulumi.Input[bool] can_manage_product_preferences: Group members can update Product preferences. Default: false.
        :param pulumi.Input[bool] can_manage_webhook: Group members can create/update/delete Webhooks. Default: false.
        :param pulumi.Input[bool] can_rotate_sdkkey: Group members can rotate SDK keys. Default: false.
        :param pulumi.Input[bool] can_tag_setting: Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_use_exportimport: Group members can use the export/import feature. Default: false.
        :param pulumi.Input[bool] can_view_product_auditlog: Group members has access to audit logs. Default: false.
        :param pulumi.Input[bool] can_view_product_statistics: Group members has access to product statistics. Default: false.
        :param pulumi.Input[bool] can_view_sdkkey: Group members has access to SDK keys. Default: false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PermissionGroupEnvironmentAccessArgs', 'PermissionGroupEnvironmentAccessArgsDict']]]] environment_accesses: The environment specific permissions list block defined as below.
        :param pulumi.Input[str] name: The name of the Permission Group.
        :param pulumi.Input[str] new_environment_accesstype: Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        :param pulumi.Input[str] product_id: The ID of the Product.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # PermissionGroup Resource

        Creates and manages a **Permission Group**. [What is a Permission Group in ConfigCat?](https://configcat.com/docs/advanced/team-management/team-management-basics/#permissions--permission-groups-product-level)

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_configcat as configcat
        import pulumiverse_configcat as configcat

        my_products = configcat.get_products(name_filter_regex="ConfigCat's product")
        my_permission_group = configcat.PermissionGroup("my_permission_group",
            product_id=my_products.products[0].product_id,
            name="Administrators",
            accesstype="full",
            can_manage_members=True,
            can_createorupdate_config=True,
            can_delete_config=True,
            can_createorupdate_environment=True,
            can_delete_environment=True,
            can_createorupdate_setting=True,
            can_tag_setting=True,
            can_delete_setting=True,
            can_createorupdate_tag=True,
            can_delete_tag=True,
            can_manage_webhook=True,
            can_use_exportimport=True,
            can_manage_product_preferences=True,
            can_manage_integrations=True,
            can_view_sdkkey=True,
            can_rotate_sdkkey=True,
            can_createorupdate_segment=True,
            can_delete_segment=True,
            can_view_product_auditlog=True,
            can_view_product_statistics=True)
        pulumi.export("permissionGroupId", my_permission_group.id)
        ```

        ```python
        import pulumi
        import pulumi_configcat as configcat
        import pulumiverse_configcat as configcat

        my_products = configcat.get_products(name_filter_regex="ConfigCat's product")
        my_test_environments = configcat.get_environments(name_filter_regex="Test")
        my_production_environments = configcat.get_environments(name_filter_regex="Production")
        my_permission_group = configcat.PermissionGroup("my_permission_group",
            product_id=my_products.products[0].product_id,
            name="Read only except Test environment",
            accesstype="custom",
            environment_accesses=[
                {
                    "environment_id": my_test_environments.environments[0].environment_id,
                    "environment_accesstype": "full",
                },
                {
                    "environment_id": my_production_environments.environments[0].environment_id,
                    "environment_accesstype": "none",
                },
            ])
        pulumi.export("permissionGroupId", my_permission_group.id)
        ```

        ## Endpoints used

        * [Get Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/get-permission-group)
        * [Create Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/create-permission-group)
        * [Update Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/update-permission-group)
        * [Delete Permission Group](https://api.configcat.com/docs/#tag/Permission-Groups/operation/delete-permission-group)

        ## Import

        Permission Groups can be imported using the PermissionGroupId. Get the PermissionGroupId using the [List Permission Groups API](https://api.configcat.com/docs/#tag/Permission-Groups/operation/get-permission-groups) for example.

        ```sh
        $ pulumi import configcat:index/permissionGroup:PermissionGroup example 123
        ```
        Read more about importing.

        :param str resource_name: The name of the resource.
        :param PermissionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accesstype: Optional[pulumi.Input[str]] = None,
                 can_createorupdate_config: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_environment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_segment: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_setting: Optional[pulumi.Input[bool]] = None,
                 can_createorupdate_tag: Optional[pulumi.Input[bool]] = None,
                 can_delete_config: Optional[pulumi.Input[bool]] = None,
                 can_delete_environment: Optional[pulumi.Input[bool]] = None,
                 can_delete_segment: Optional[pulumi.Input[bool]] = None,
                 can_delete_setting: Optional[pulumi.Input[bool]] = None,
                 can_delete_tag: Optional[pulumi.Input[bool]] = None,
                 can_manage_integrations: Optional[pulumi.Input[bool]] = None,
                 can_manage_members: Optional[pulumi.Input[bool]] = None,
                 can_manage_product_preferences: Optional[pulumi.Input[bool]] = None,
                 can_manage_webhook: Optional[pulumi.Input[bool]] = None,
                 can_rotate_sdkkey: Optional[pulumi.Input[bool]] = None,
                 can_tag_setting: Optional[pulumi.Input[bool]] = None,
                 can_use_exportimport: Optional[pulumi.Input[bool]] = None,
                 can_view_product_auditlog: Optional[pulumi.Input[bool]] = None,
                 can_view_product_statistics: Optional[pulumi.Input[bool]] = None,
                 can_view_sdkkey: Optional[pulumi.Input[bool]] = None,
                 environment_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionGroupEnvironmentAccessArgs', 'PermissionGroupEnvironmentAccessArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_environment_accesstype: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionGroupArgs.__new__(PermissionGroupArgs)

            __props__.__dict__["accesstype"] = accesstype
            __props__.__dict__["can_createorupdate_config"] = can_createorupdate_config
            __props__.__dict__["can_createorupdate_environment"] = can_createorupdate_environment
            __props__.__dict__["can_createorupdate_segment"] = can_createorupdate_segment
            __props__.__dict__["can_createorupdate_setting"] = can_createorupdate_setting
            __props__.__dict__["can_createorupdate_tag"] = can_createorupdate_tag
            __props__.__dict__["can_delete_config"] = can_delete_config
            __props__.__dict__["can_delete_environment"] = can_delete_environment
            __props__.__dict__["can_delete_segment"] = can_delete_segment
            __props__.__dict__["can_delete_setting"] = can_delete_setting
            __props__.__dict__["can_delete_tag"] = can_delete_tag
            __props__.__dict__["can_manage_integrations"] = can_manage_integrations
            __props__.__dict__["can_manage_members"] = can_manage_members
            __props__.__dict__["can_manage_product_preferences"] = can_manage_product_preferences
            __props__.__dict__["can_manage_webhook"] = can_manage_webhook
            __props__.__dict__["can_rotate_sdkkey"] = can_rotate_sdkkey
            __props__.__dict__["can_tag_setting"] = can_tag_setting
            __props__.__dict__["can_use_exportimport"] = can_use_exportimport
            __props__.__dict__["can_view_product_auditlog"] = can_view_product_auditlog
            __props__.__dict__["can_view_product_statistics"] = can_view_product_statistics
            __props__.__dict__["can_view_sdkkey"] = can_view_sdkkey
            __props__.__dict__["environment_accesses"] = environment_accesses
            __props__.__dict__["name"] = name
            __props__.__dict__["new_environment_accesstype"] = new_environment_accesstype
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
        super(PermissionGroup, __self__).__init__(
            'configcat:index/permissionGroup:PermissionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accesstype: Optional[pulumi.Input[str]] = None,
            can_createorupdate_config: Optional[pulumi.Input[bool]] = None,
            can_createorupdate_environment: Optional[pulumi.Input[bool]] = None,
            can_createorupdate_segment: Optional[pulumi.Input[bool]] = None,
            can_createorupdate_setting: Optional[pulumi.Input[bool]] = None,
            can_createorupdate_tag: Optional[pulumi.Input[bool]] = None,
            can_delete_config: Optional[pulumi.Input[bool]] = None,
            can_delete_environment: Optional[pulumi.Input[bool]] = None,
            can_delete_segment: Optional[pulumi.Input[bool]] = None,
            can_delete_setting: Optional[pulumi.Input[bool]] = None,
            can_delete_tag: Optional[pulumi.Input[bool]] = None,
            can_manage_integrations: Optional[pulumi.Input[bool]] = None,
            can_manage_members: Optional[pulumi.Input[bool]] = None,
            can_manage_product_preferences: Optional[pulumi.Input[bool]] = None,
            can_manage_webhook: Optional[pulumi.Input[bool]] = None,
            can_rotate_sdkkey: Optional[pulumi.Input[bool]] = None,
            can_tag_setting: Optional[pulumi.Input[bool]] = None,
            can_use_exportimport: Optional[pulumi.Input[bool]] = None,
            can_view_product_auditlog: Optional[pulumi.Input[bool]] = None,
            can_view_product_statistics: Optional[pulumi.Input[bool]] = None,
            can_view_sdkkey: Optional[pulumi.Input[bool]] = None,
            environment_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionGroupEnvironmentAccessArgs', 'PermissionGroupEnvironmentAccessArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_environment_accesstype: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None) -> 'PermissionGroup':
        """
        Get an existing PermissionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accesstype: Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        :param pulumi.Input[bool] can_createorupdate_config: Group members can create/update Configs. Default: false.
        :param pulumi.Input[bool] can_createorupdate_environment: Group members can create/update Environments. Default: false.
        :param pulumi.Input[bool] can_createorupdate_setting: Group members can create/update Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_createorupdate_tag: Group members can create/update Tags. Default: false.
        :param pulumi.Input[bool] can_delete_config: Group members can delete Configs. Default: false.
        :param pulumi.Input[bool] can_delete_environment: Group members can delete Environments. Default: false.
        :param pulumi.Input[bool] can_delete_setting: Group members can delete Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_delete_tag: Group members can delete Tags. Default: false.
        :param pulumi.Input[bool] can_manage_integrations: Group members can add and configure integrations. Default: false.
        :param pulumi.Input[bool] can_manage_members: Group members can manage team members. Default: false.
        :param pulumi.Input[bool] can_manage_product_preferences: Group members can update Product preferences. Default: false.
        :param pulumi.Input[bool] can_manage_webhook: Group members can create/update/delete Webhooks. Default: false.
        :param pulumi.Input[bool] can_rotate_sdkkey: Group members can rotate SDK keys. Default: false.
        :param pulumi.Input[bool] can_tag_setting: Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        :param pulumi.Input[bool] can_use_exportimport: Group members can use the export/import feature. Default: false.
        :param pulumi.Input[bool] can_view_product_auditlog: Group members has access to audit logs. Default: false.
        :param pulumi.Input[bool] can_view_product_statistics: Group members has access to product statistics. Default: false.
        :param pulumi.Input[bool] can_view_sdkkey: Group members has access to SDK keys. Default: false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PermissionGroupEnvironmentAccessArgs', 'PermissionGroupEnvironmentAccessArgsDict']]]] environment_accesses: The environment specific permissions list block defined as below.
        :param pulumi.Input[str] name: The name of the Permission Group.
        :param pulumi.Input[str] new_environment_accesstype: Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        :param pulumi.Input[str] product_id: The ID of the Product.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionGroupState.__new__(_PermissionGroupState)

        __props__.__dict__["accesstype"] = accesstype
        __props__.__dict__["can_createorupdate_config"] = can_createorupdate_config
        __props__.__dict__["can_createorupdate_environment"] = can_createorupdate_environment
        __props__.__dict__["can_createorupdate_segment"] = can_createorupdate_segment
        __props__.__dict__["can_createorupdate_setting"] = can_createorupdate_setting
        __props__.__dict__["can_createorupdate_tag"] = can_createorupdate_tag
        __props__.__dict__["can_delete_config"] = can_delete_config
        __props__.__dict__["can_delete_environment"] = can_delete_environment
        __props__.__dict__["can_delete_segment"] = can_delete_segment
        __props__.__dict__["can_delete_setting"] = can_delete_setting
        __props__.__dict__["can_delete_tag"] = can_delete_tag
        __props__.__dict__["can_manage_integrations"] = can_manage_integrations
        __props__.__dict__["can_manage_members"] = can_manage_members
        __props__.__dict__["can_manage_product_preferences"] = can_manage_product_preferences
        __props__.__dict__["can_manage_webhook"] = can_manage_webhook
        __props__.__dict__["can_rotate_sdkkey"] = can_rotate_sdkkey
        __props__.__dict__["can_tag_setting"] = can_tag_setting
        __props__.__dict__["can_use_exportimport"] = can_use_exportimport
        __props__.__dict__["can_view_product_auditlog"] = can_view_product_auditlog
        __props__.__dict__["can_view_product_statistics"] = can_view_product_statistics
        __props__.__dict__["can_view_sdkkey"] = can_view_sdkkey
        __props__.__dict__["environment_accesses"] = environment_accesses
        __props__.__dict__["name"] = name
        __props__.__dict__["new_environment_accesstype"] = new_environment_accesstype
        __props__.__dict__["product_id"] = product_id
        return PermissionGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accesstype(self) -> pulumi.Output[Optional[str]]:
        """
        Represent the Feature Management permission. Possible values: readOnly, full, custom. Default: custom
        """
        return pulumi.get(self, "accesstype")

    @property
    @pulumi.getter(name="canCreateorupdateConfig")
    def can_createorupdate_config(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can create/update Configs. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_config")

    @property
    @pulumi.getter(name="canCreateorupdateEnvironment")
    def can_createorupdate_environment(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can create/update Environments. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_environment")

    @property
    @pulumi.getter(name="canCreateorupdateSegment")
    def can_createorupdate_segment(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "can_createorupdate_segment")

    @property
    @pulumi.getter(name="canCreateorupdateSetting")
    def can_createorupdate_setting(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can create/update Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_setting")

    @property
    @pulumi.getter(name="canCreateorupdateTag")
    def can_createorupdate_tag(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can create/update Tags. Default: false.
        """
        return pulumi.get(self, "can_createorupdate_tag")

    @property
    @pulumi.getter(name="canDeleteConfig")
    def can_delete_config(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can delete Configs. Default: false.
        """
        return pulumi.get(self, "can_delete_config")

    @property
    @pulumi.getter(name="canDeleteEnvironment")
    def can_delete_environment(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can delete Environments. Default: false.
        """
        return pulumi.get(self, "can_delete_environment")

    @property
    @pulumi.getter(name="canDeleteSegment")
    def can_delete_segment(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "can_delete_segment")

    @property
    @pulumi.getter(name="canDeleteSetting")
    def can_delete_setting(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can delete Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_delete_setting")

    @property
    @pulumi.getter(name="canDeleteTag")
    def can_delete_tag(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can delete Tags. Default: false.
        """
        return pulumi.get(self, "can_delete_tag")

    @property
    @pulumi.getter(name="canManageIntegrations")
    def can_manage_integrations(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can add and configure integrations. Default: false.
        """
        return pulumi.get(self, "can_manage_integrations")

    @property
    @pulumi.getter(name="canManageMembers")
    def can_manage_members(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can manage team members. Default: false.
        """
        return pulumi.get(self, "can_manage_members")

    @property
    @pulumi.getter(name="canManageProductPreferences")
    def can_manage_product_preferences(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can update Product preferences. Default: false.
        """
        return pulumi.get(self, "can_manage_product_preferences")

    @property
    @pulumi.getter(name="canManageWebhook")
    def can_manage_webhook(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can create/update/delete Webhooks. Default: false.
        """
        return pulumi.get(self, "can_manage_webhook")

    @property
    @pulumi.getter(name="canRotateSdkkey")
    def can_rotate_sdkkey(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can rotate SDK keys. Default: false.
        """
        return pulumi.get(self, "can_rotate_sdkkey")

    @property
    @pulumi.getter(name="canTagSetting")
    def can_tag_setting(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can attach/detach Tags to Feature Flags and Settings. Default: false.
        """
        return pulumi.get(self, "can_tag_setting")

    @property
    @pulumi.getter(name="canUseExportimport")
    def can_use_exportimport(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members can use the export/import feature. Default: false.
        """
        return pulumi.get(self, "can_use_exportimport")

    @property
    @pulumi.getter(name="canViewProductAuditlog")
    def can_view_product_auditlog(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members has access to audit logs. Default: false.
        """
        return pulumi.get(self, "can_view_product_auditlog")

    @property
    @pulumi.getter(name="canViewProductStatistics")
    def can_view_product_statistics(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members has access to product statistics. Default: false.
        """
        return pulumi.get(self, "can_view_product_statistics")

    @property
    @pulumi.getter(name="canViewSdkkey")
    def can_view_sdkkey(self) -> pulumi.Output[Optional[bool]]:
        """
        Group members has access to SDK keys. Default: false.
        """
        return pulumi.get(self, "can_view_sdkkey")

    @property
    @pulumi.getter(name="environmentAccesses")
    def environment_accesses(self) -> pulumi.Output[Optional[Sequence['outputs.PermissionGroupEnvironmentAccess']]]:
        """
        The environment specific permissions list block defined as below.
        """
        return pulumi.get(self, "environment_accesses")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Permission Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newEnvironmentAccesstype")
    def new_environment_accesstype(self) -> pulumi.Output[Optional[str]]:
        """
        Represent the environment specific Feature Management permission for new Environments and for those that are not specified in the environment_access list. Possible values: full, readOnly, none. Default: none.
        """
        return pulumi.get(self, "new_environment_accesstype")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

