/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <return_get_area.h>

// Default constructor
return_get_area::return_get_area() :
        WirePortable(),
        retval(false),
        area()
{
}

// Constructor with field values
return_get_area::return_get_area(const bool retval,
                                 const yarp::dev::Nav2D::Map2DArea& area) :
        WirePortable(),
        retval(retval),
        area(area)
{
}

// Read structure on a Wire
bool return_get_area::read(yarp::os::idl::WireReader& reader)
{
    if (!read_retval(reader)) {
        return false;
    }
    if (!read_area(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool return_get_area::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(2)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool return_get_area::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_retval(writer)) {
        return false;
    }
    if (!write_area(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool return_get_area::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string return_get_area::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
return_get_area::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new return_get_area;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
return_get_area::Editor::Editor(return_get_area& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
return_get_area::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool return_get_area::Editor::edit(return_get_area& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool return_get_area::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
return_get_area& return_get_area::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void return_get_area::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void return_get_area::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: retval setter
void return_get_area::Editor::set_retval(const bool retval)
{
    will_set_retval();
    obj->retval = retval;
    mark_dirty_retval();
    communicate();
    did_set_retval();
}

// Editor: retval getter
bool return_get_area::Editor::get_retval() const
{
    return obj->retval;
}

// Editor: retval will_set
bool return_get_area::Editor::will_set_retval()
{
    return true;
}

// Editor: retval did_set
bool return_get_area::Editor::did_set_retval()
{
    return true;
}

// Editor: area setter
void return_get_area::Editor::set_area(const yarp::dev::Nav2D::Map2DArea& area)
{
    will_set_area();
    obj->area = area;
    mark_dirty_area();
    communicate();
    did_set_area();
}

// Editor: area getter
const yarp::dev::Nav2D::Map2DArea& return_get_area::Editor::get_area() const
{
    return obj->area;
}

// Editor: area will_set
bool return_get_area::Editor::will_set_area()
{
    return true;
}

// Editor: area did_set
bool return_get_area::Editor::did_set_area()
{
    return true;
}

// Editor: clean
void return_get_area::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool return_get_area::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "retval") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("bool retval")) {
                    return false;
                }
            }
            if (field == "area") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("yarp::dev::Nav2D::Map2DArea area")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(3)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("retval");
        writer.writeString("area");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "retval") {
            will_set_retval();
            if (!obj->nested_read_retval(reader)) {
                return false;
            }
            did_set_retval();
        } else if (key == "area") {
            will_set_area();
            if (!obj->nested_read_area(reader)) {
                return false;
            }
            did_set_area();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool return_get_area::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_retval) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("retval")) {
            return false;
        }
        if (!obj->nested_write_retval(writer)) {
            return false;
        }
    }
    if (is_dirty_area) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("area")) {
            return false;
        }
        if (!obj->nested_write_area(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void return_get_area::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void return_get_area::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: retval mark_dirty
void return_get_area::Editor::mark_dirty_retval()
{
    if (is_dirty_retval) {
        return;
    }
    dirty_count++;
    is_dirty_retval = true;
    mark_dirty();
}

// Editor: area mark_dirty
void return_get_area::Editor::mark_dirty_area()
{
    if (is_dirty_area) {
        return;
    }
    dirty_count++;
    is_dirty_area = true;
    mark_dirty();
}

// Editor: dirty_flags
void return_get_area::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_retval = flag;
    is_dirty_area = flag;
    dirty_count = flag ? 2 : 0;
}

// read retval field
bool return_get_area::read_retval(yarp::os::idl::WireReader& reader)
{
    if (!reader.readBool(retval)) {
        retval = 0;
    }
    return true;
}

// write retval field
bool return_get_area::write_retval(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeBool(retval)) {
        return false;
    }
    return true;
}

// read (nested) retval field
bool return_get_area::nested_read_retval(yarp::os::idl::WireReader& reader)
{
    if (!reader.readBool(retval)) {
        retval = 0;
    }
    return true;
}

// write (nested) retval field
bool return_get_area::nested_write_retval(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeBool(retval)) {
        return false;
    }
    return true;
}

// read area field
bool return_get_area::read_area(yarp::os::idl::WireReader& reader)
{
    if (!reader.read(area)) {
        reader.fail();
        return false;
    }
    return true;
}

// write area field
bool return_get_area::write_area(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.write(area)) {
        return false;
    }
    return true;
}

// read (nested) area field
bool return_get_area::nested_read_area(yarp::os::idl::WireReader& reader)
{
    if (!reader.readNested(area)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) area field
bool return_get_area::nested_write_area(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeNested(area)) {
        return false;
    }
    return true;
}
