# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in pyDARN and
DAWG a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and expression,
level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members
* Please see [communication guidelines](https://pydarn.readthedocs.io/en/latest/dev/communication/) for more examples

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
 advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
 address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
 professional setting

## Our Responsibilities

[PyDARN/DAWG leaders/chairs](https://superdarn.github.io/dawg/about) (please see [DAWG charter](https://superdarn.github.io/dawg/documents/DAWG_Charter/) on pyDARN/DAWG leaders) are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

[PyDARN/DAWG leaders/chairs](https://superdarn.github.io/dawg/about) have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, README edits, readthedocs edits,
issues, and other contributions that are not aligned to this Code of Conduct or the scope of pyDARN,
or to ban temporarily or permanently any contributor for other behaviors that
they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within pyDARN spaces and in public spaces
when an individual is representing the pyDARN/DAWG or its community. Examples of
representing pyDARN or DAWG include: using an official pyDARN name or logo,
publishing work in an official journal or conference, posting via an official website or online conference, 
or acting as an appointed representative at an online or offline conference or workshop. 
Representation of pyDARN may be further defined and clarified by pyDARN maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the [pydarn team lead at or contacting
the DAWG chairs](https://superdarn.github.io/dawg/about). All complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The pyDARN team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.
Please see [communication guidelines](https://pydarn.readthedocs.io/en/latest/dev/communication/) and [reporting guidelines](https://pydarn.readthedocs.io/en/latest/dev/communication/#disputes-procedure) for more information.

pyDARN developers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by [DAWG chairs](https://superdarn.github.io/dawg/about).

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html

[homepage]: https://www.contributor-covenant.org

For answers to common questions about this code of conduct, see
https://www.contributor-covenant.org/faq
