[Home](../README.md) / Getting Started

# Getting Started with TripWire

New to TripWire? Start here to get up and running quickly.

---

## Quick Navigation

- **[Installation](installation.md)** - Install TripWire and verify setup
- **[Quick Start](quick-start.md)** - Get running in 5 minutes
- **[Your First Project](your-first-project.md)** - Step-by-step tutorial

---

## Learning Path

### 1. Installation (5 minutes)

Install TripWire and verify it's working:

```bash
pip install tripwire-py
tripwire --version
```

**[Read the installation guide →](installation.md)**

### 2. Quick Start (5 minutes)

Initialize a project and start using TripWire:

```bash
tripwire init
```

Learn the basics:
- Required vs optional variables
- Type inference
- Format validation
- Import-time validation

**[Read the quick start guide →](quick-start.md)**

### 3. Your First Project (15 minutes)

Build a complete application with:
- Database configuration
- API key management
- Validation testing
- Secret scanning
- Team synchronization

**[Read the tutorial →](your-first-project.md)**

---

## After Getting Started

Once you've completed these guides, explore:

### Essential Features
- **[CLI Reference](../guides/cli-reference.md)** - All CLI commands
- **[Secret Management](../guides/secret-management.md)** - Detect and audit secrets
- **[Configuration as Code](../guides/configuration-as-code.md)** - Schema-based validation

### Framework Integration
- **[Framework Integration](../guides/framework-integration.md)** - FastAPI, Django, Flask
- **[CI/CD Integration](../guides/ci-cd-integration.md)** - GitHub Actions, GitLab CI

### Advanced Topics
- **[Type System](../advanced/type-system.md)** - Deep dive into type inference
- **[Custom Validators](../advanced/custom-validators.md)** - Write your own
- **[Git Audit](../advanced/git-audit.md)** - Secret leak detection

---

## Need Help?

- **Stuck?** See [Troubleshooting Guide](../advanced/troubleshooting.md)
- **Questions?** Check [GitHub Discussions](https://github.com/Daily-Nerd/TripWire/discussions)
- **Bug?** [Report an issue](https://github.com/Daily-Nerd/TripWire/issues)

---

**[Back to Documentation Home](../README.md)**
