"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQuestionProps = (item, index) => {
    let answer = item.answer;
    if (item.type === 'FILL' && !Array.isArray(answer)) {
        answer = [answer];
    }
    return {
        id: item.id,
        title: item.title,
        number: index + 1,
        type: item.type,
        score: item.score,
        options: item.options,
        answer,
        hint: item.hint,
    };
};
exports.getQuizResult = (questions, values) => {
    return questions.map(question => {
        const value = values[question.id];
        if (question.type === 'SELECT') {
            return question.answer === value;
        }
        return;
    });
};
//# sourceMappingURL=util.js.map