/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;

public class SqlWindowTableFunction
extends SqlFunction {
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = opBinding -> {
        RelDataType inputRowType = opBinding.getOperandType(0);
        ArrayList<RelDataTypeField> newFields = new ArrayList<RelDataTypeField>(inputRowType.getFieldList());
        RelDataType timestampType = opBinding.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
        RelDataTypeFieldImpl windowStartField = new RelDataTypeFieldImpl("window_start", newFields.size(), timestampType);
        newFields.add(windowStartField);
        RelDataTypeFieldImpl windowEndField = new RelDataTypeFieldImpl("window_end", newFields.size(), timestampType);
        newFields.add(windowEndField);
        return new RelRecordType(inputRowType.getStructKind(), newFields);
    };

    public SqlWindowTableFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ARG0_TABLE_FUNCTION_WINDOWING, null, null, SqlFunctionCategory.SYSTEM);
    }

    protected boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    protected void validateColumnNames(SqlValidator validator, List<String> fieldNames, List<SqlNode> unvalidatedColumnNames) {
        for (SqlNode descOperand : unvalidatedColumnNames) {
            String colName = ((SqlIdentifier)descOperand).getSimple();
            boolean matches = false;
            for (String field : fieldNames) {
                if (!validator.getCatalogReader().nameMatcher().matches(field, colName)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            throw SqlUtil.newContextException(descOperand.getParserPosition(), Static.RESOURCE.unknownIdentifier(colName));
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }
}

