/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.calcite.util.SimpleNamespaceContext;
import org.apache.calcite.util.Static;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlFunctions {
    private static final ThreadLocal<XPathFactory> XPATH_FACTORY = ThreadLocal.withInitial(XPathFactory::newInstance);
    private static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY = ThreadLocal.withInitial(TransformerFactory::newInstance);
    private static final Pattern VALID_NAMESPACE_PATTERN = Pattern.compile("^(([0-9a-zA-Z:_-]+=\"[^\"]*\")( [0-9a-zA-Z:_-]+=\"[^\"]*\")*)$");
    private static final Pattern EXTRACT_NAMESPACE_PATTERN = Pattern.compile("([0-9a-zA-Z:_-]+)=(['\"])((?!\\2).+?)\\2");

    private XmlFunctions() {
    }

    public static String extractValue(String input, String xpath) {
        if (input == null || xpath == null) {
            return null;
        }
        try {
            XPathExpression xpathExpression = XPATH_FACTORY.get().newXPath().compile(xpath);
            try {
                NodeList nodes = (NodeList)xpathExpression.evaluate(new InputSource(new StringReader(input)), XPathConstants.NODESET);
                ArrayList<String> result = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    result.add(nodes.item(i).getFirstChild().getTextContent());
                }
                return StringUtils.join(result, " ");
            }
            catch (XPathExpressionException e) {
                return xpathExpression.evaluate(new InputSource(new StringReader(input)));
            }
        }
        catch (XPathExpressionException ex) {
            throw Static.RESOURCE.invalidInputForExtractValue(input, xpath).ex();
        }
    }

    public static String xmlTransform(String xml, String xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        try {
            StreamSource xsltSource = new StreamSource(new StringReader(xslt));
            StreamSource xmlSource = new StreamSource(new StringReader(xml));
            Transformer transformer = TRANSFORMER_FACTORY.get().newTransformer(xsltSource);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(xmlSource, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw Static.RESOURCE.illegalXslt(xslt).ex();
        }
        catch (TransformerException e) {
            throw Static.RESOURCE.invalidInputForXmlTransform(xml).ex();
        }
    }

    public static String extractXml(String xml, String xpath) {
        return XmlFunctions.extractXml(xml, xpath, null);
    }

    public static String extractXml(String xml, String xpath, String namespace) {
        if (xml == null || xpath == null) {
            return null;
        }
        try {
            XPath xPath = XPATH_FACTORY.get().newXPath();
            if (namespace != null) {
                xPath.setNamespaceContext(XmlFunctions.extractNamespaceContext(namespace));
            }
            XPathExpression xpathExpression = xPath.compile(xpath);
            try {
                ArrayList<String> result = new ArrayList<String>();
                NodeList nodes = (NodeList)xpathExpression.evaluate(new InputSource(new StringReader(xml)), XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    result.add(XmlFunctions.convertNodeToString(nodes.item(i)));
                }
                return StringUtils.join(result, "");
            }
            catch (XPathExpressionException e) {
                Node node = (Node)xpathExpression.evaluate(new InputSource(new StringReader(xml)), XPathConstants.NODE);
                return XmlFunctions.convertNodeToString(node);
            }
        }
        catch (IllegalArgumentException | TransformerException | XPathExpressionException ex) {
            throw Static.RESOURCE.invalidInputForExtractXml(xpath, namespace).ex();
        }
    }

    public static Integer existsNode(String xml, String xpath) {
        return XmlFunctions.existsNode(xml, xpath, null);
    }

    public static Integer existsNode(String xml, String xpath, String namespace) {
        if (xml == null || xpath == null) {
            return null;
        }
        XPath xPath = XPATH_FACTORY.get().newXPath();
        if (namespace != null) {
            xPath.setNamespaceContext(XmlFunctions.extractNamespaceContext(namespace));
        }
        XPathExpression xpathExpression = xPath.compile(xpath);
        try {
            NodeList nodes = (NodeList)xpathExpression.evaluate(new InputSource(new StringReader(xml)), XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                return 1;
            }
            return 0;
        }
        catch (XPathExpressionException e) {
            try {
                Node node = (Node)xpathExpression.evaluate(new InputSource(new StringReader(xml)), XPathConstants.NODE);
                if (node != null) {
                    return 1;
                }
                return 0;
            }
            catch (IllegalArgumentException | XPathExpressionException ex) {
                throw Static.RESOURCE.invalidInputForExistsNode(xpath, namespace).ex();
            }
        }
    }

    private static SimpleNamespaceContext extractNamespaceContext(String namespace) {
        if (!VALID_NAMESPACE_PATTERN.matcher(namespace).find()) {
            throw new IllegalArgumentException("Invalid namespace " + namespace);
        }
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        Matcher matcher = EXTRACT_NAMESPACE_PATTERN.matcher(namespace);
        while (matcher.find()) {
            namespaceMap.put(matcher.group(1), matcher.group(3));
        }
        return new SimpleNamespaceContext(namespaceMap);
    }

    private static String convertNodeToString(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TRANSFORMER_FACTORY.get().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }
}

