/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;

public class ProjectSortTransposeRule
extends RelOptRule
implements TransformationRule {
    public static final ProjectSortTransposeRule INSTANCE = new ProjectSortTransposeRule(Project.class, Sort.class, RelFactories.LOGICAL_BUILDER);

    private ProjectSortTransposeRule(Class<Project> projectClass, Class<Sort> sortClass, RelBuilderFactory relBuilderFactory) {
        this(ProjectSortTransposeRule.operand(projectClass, ProjectSortTransposeRule.operand(sortClass, ProjectSortTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Deprecated
    protected ProjectSortTransposeRule(RelOptRuleOperand operand) {
        this(operand, RelFactories.LOGICAL_BUILDER, null);
    }

    protected ProjectSortTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Sort sort = (Sort)call.rel(1);
        if (sort.getClass() != Sort.class) {
            return;
        }
        RelNode newProject = project.copy(project.getTraitSet(), ImmutableList.of(sort.getInput()));
        Sort newSort = sort.copy(sort.getTraitSet(), newProject, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(newSort);
    }
}

