/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateProjectMergeRule
extends RelOptRule
implements TransformationRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public AggregateProjectMergeRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(AggregateProjectMergeRule.operand(aggregateClass, AggregateProjectMergeRule.operand(projectClass, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        Set<Integer> interestingFields = RelOptUtil.getAllFields(aggregate);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int source : interestingFields) {
            RexNode rex = project.getProjects().get(source);
            if (!(rex instanceof RexInputRef)) {
                return null;
            }
            map.put(source, ((RexInputRef)rex).getIndex());
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        int sourceCount = aggregate.getInput().getRowType().getFieldCount();
        int targetCount = project.getInput().getRowType().getFieldCount();
        Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, targetCount);
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            aggCalls.add(aggregateCall.transform(targetMapping));
        }
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newAggregate);
        List newKeys = Lists.transform(aggregate.getGroupSet().asList(), map::get);
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = new ArrayList<Integer>();
            Iterator iterator = newKeys.iterator();
            while (iterator.hasNext()) {
                int newKey = (Integer)iterator.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            for (int i = newAggregate.getGroupCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project(relBuilder.fields((List<? extends Number>)posList));
        }
        return relBuilder.build();
    }
}

