/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;

public class RelMetadataQuery
extends RelMetadataQueryBase {
    private static final RelMetadataQuery EMPTY = new RelMetadataQuery(false);
    private BuiltInMetadata.Collation.Handler collationHandler;
    private BuiltInMetadata.ColumnOrigin.Handler columnOriginHandler;
    private BuiltInMetadata.ExpressionLineage.Handler expressionLineageHandler;
    private BuiltInMetadata.TableReferences.Handler tableReferencesHandler;
    private BuiltInMetadata.ColumnUniqueness.Handler columnUniquenessHandler;
    private BuiltInMetadata.CumulativeCost.Handler cumulativeCostHandler;
    private BuiltInMetadata.DistinctRowCount.Handler distinctRowCountHandler;
    private BuiltInMetadata.Distribution.Handler distributionHandler;
    private BuiltInMetadata.ExplainVisibility.Handler explainVisibilityHandler;
    private BuiltInMetadata.MaxRowCount.Handler maxRowCountHandler;
    private BuiltInMetadata.MinRowCount.Handler minRowCountHandler;
    private BuiltInMetadata.Memory.Handler memoryHandler;
    private BuiltInMetadata.NonCumulativeCost.Handler nonCumulativeCostHandler;
    private BuiltInMetadata.Parallelism.Handler parallelismHandler;
    private BuiltInMetadata.PercentageOriginalRows.Handler percentageOriginalRowsHandler;
    private BuiltInMetadata.PopulationSize.Handler populationSizeHandler;
    private BuiltInMetadata.Predicates.Handler predicatesHandler;
    private BuiltInMetadata.AllPredicates.Handler allPredicatesHandler;
    private BuiltInMetadata.NodeTypes.Handler nodeTypesHandler;
    private BuiltInMetadata.RowCount.Handler rowCountHandler;
    private BuiltInMetadata.Selectivity.Handler selectivityHandler;
    private BuiltInMetadata.Size.Handler sizeHandler;
    private BuiltInMetadata.UniqueKeys.Handler uniqueKeysHandler;

    protected RelMetadataQuery() {
        this((JaninoRelMetadataProvider)THREAD_PROVIDERS.get(), EMPTY);
    }

    private RelMetadataQuery(boolean dummy) {
        super(null);
        this.collationHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Collation.Handler.class);
        this.columnOriginHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnOrigin.Handler.class);
        this.expressionLineageHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ExpressionLineage.Handler.class);
        this.tableReferencesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.TableReferences.Handler.class);
        this.columnUniquenessHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnUniqueness.Handler.class);
        this.cumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.CumulativeCost.Handler.class);
        this.distinctRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.DistinctRowCount.Handler.class);
        this.distributionHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Distribution.Handler.class);
        this.explainVisibilityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ExplainVisibility.Handler.class);
        this.maxRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.MaxRowCount.Handler.class);
        this.minRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.MinRowCount.Handler.class);
        this.memoryHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Memory.Handler.class);
        this.nonCumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.NonCumulativeCost.Handler.class);
        this.parallelismHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Parallelism.Handler.class);
        this.percentageOriginalRowsHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PercentageOriginalRows.Handler.class);
        this.populationSizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PopulationSize.Handler.class);
        this.predicatesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Predicates.Handler.class);
        this.allPredicatesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.AllPredicates.Handler.class);
        this.nodeTypesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.NodeTypes.Handler.class);
        this.rowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.RowCount.Handler.class);
        this.selectivityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Selectivity.Handler.class);
        this.sizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Size.Handler.class);
        this.uniqueKeysHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.UniqueKeys.Handler.class);
    }

    private RelMetadataQuery(JaninoRelMetadataProvider metadataProvider, RelMetadataQuery prototype) {
        super(Objects.requireNonNull(metadataProvider));
        this.collationHandler = prototype.collationHandler;
        this.columnOriginHandler = prototype.columnOriginHandler;
        this.expressionLineageHandler = prototype.expressionLineageHandler;
        this.tableReferencesHandler = prototype.tableReferencesHandler;
        this.columnUniquenessHandler = prototype.columnUniquenessHandler;
        this.cumulativeCostHandler = prototype.cumulativeCostHandler;
        this.distinctRowCountHandler = prototype.distinctRowCountHandler;
        this.distributionHandler = prototype.distributionHandler;
        this.explainVisibilityHandler = prototype.explainVisibilityHandler;
        this.maxRowCountHandler = prototype.maxRowCountHandler;
        this.minRowCountHandler = prototype.minRowCountHandler;
        this.memoryHandler = prototype.memoryHandler;
        this.nonCumulativeCostHandler = prototype.nonCumulativeCostHandler;
        this.parallelismHandler = prototype.parallelismHandler;
        this.percentageOriginalRowsHandler = prototype.percentageOriginalRowsHandler;
        this.populationSizeHandler = prototype.populationSizeHandler;
        this.predicatesHandler = prototype.predicatesHandler;
        this.allPredicatesHandler = prototype.allPredicatesHandler;
        this.nodeTypesHandler = prototype.nodeTypesHandler;
        this.rowCountHandler = prototype.rowCountHandler;
        this.selectivityHandler = prototype.selectivityHandler;
        this.sizeHandler = prototype.sizeHandler;
        this.uniqueKeysHandler = prototype.uniqueKeysHandler;
    }

    public static RelMetadataQuery instance() {
        return new RelMetadataQuery();
    }

    /*
     * Loose catch block
     */
    public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelNode rel) {
        while (true) {
            try {
                return this.nodeTypesHandler.getNodeTypes(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.nodeTypesHandler = (BuiltInMetadata.NodeTypes.Handler)this.revise(e.relClass, BuiltInMetadata.NodeTypes.DEF);
                continue;
            }
            break;
        }
        catch (CyclicMetadataException e) {
            return null;
        }
    }

    public Double getRowCount(RelNode rel) {
        while (true) {
            try {
                Double result = this.rowCountHandler.getRowCount(rel, this);
                return RelMdUtil.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.rowCountHandler = (BuiltInMetadata.RowCount.Handler)this.revise(e.relClass, BuiltInMetadata.RowCount.DEF);
                continue;
            }
            break;
        }
    }

    public Double getMaxRowCount(RelNode rel) {
        while (true) {
            try {
                return this.maxRowCountHandler.getMaxRowCount(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.maxRowCountHandler = (BuiltInMetadata.MaxRowCount.Handler)this.revise(e.relClass, BuiltInMetadata.MaxRowCount.DEF);
                continue;
            }
            break;
        }
    }

    public Double getMinRowCount(RelNode rel) {
        while (true) {
            try {
                return this.minRowCountHandler.getMinRowCount(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.minRowCountHandler = (BuiltInMetadata.MinRowCount.Handler)this.revise(e.relClass, BuiltInMetadata.MinRowCount.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptCost getCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.cumulativeCostHandler.getCumulativeCost(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.cumulativeCostHandler = (BuiltInMetadata.CumulativeCost.Handler)this.revise(e.relClass, BuiltInMetadata.CumulativeCost.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptCost getNonCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.nonCumulativeCostHandler.getNonCumulativeCost(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.nonCumulativeCostHandler = (BuiltInMetadata.NonCumulativeCost.Handler)this.revise(e.relClass, BuiltInMetadata.NonCumulativeCost.DEF);
                continue;
            }
            break;
        }
    }

    public Double getPercentageOriginalRows(RelNode rel) {
        while (true) {
            try {
                Double result = this.percentageOriginalRowsHandler.getPercentageOriginalRows(rel, this);
                return RelMdUtil.validatePercentage(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.percentageOriginalRowsHandler = (BuiltInMetadata.PercentageOriginalRows.Handler)this.revise(e.relClass, BuiltInMetadata.PercentageOriginalRows.DEF);
                continue;
            }
            break;
        }
    }

    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int column) {
        while (true) {
            try {
                return this.columnOriginHandler.getColumnOrigins(rel, this, column);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnOriginHandler = (BuiltInMetadata.ColumnOrigin.Handler)this.revise(e.relClass, BuiltInMetadata.ColumnOrigin.DEF);
                continue;
            }
            break;
        }
    }

    public RelColumnOrigin getColumnOrigin(RelNode rel, int column) {
        Set<RelColumnOrigin> origins = this.getColumnOrigins(rel, column);
        if (origins == null || origins.size() != 1) {
            return null;
        }
        RelColumnOrigin origin = Iterables.getOnlyElement(origins);
        return origin.isDerived() ? null : origin;
    }

    public Set<RexNode> getExpressionLineage(RelNode rel, RexNode expression) {
        while (true) {
            try {
                return this.expressionLineageHandler.getExpressionLineage(rel, this, expression);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.expressionLineageHandler = (BuiltInMetadata.ExpressionLineage.Handler)this.revise(e.relClass, BuiltInMetadata.ExpressionLineage.DEF);
                continue;
            }
            break;
        }
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(RelNode rel) {
        while (true) {
            try {
                return this.tableReferencesHandler.getTableReferences(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.tableReferencesHandler = (BuiltInMetadata.TableReferences.Handler)this.revise(e.relClass, BuiltInMetadata.TableReferences.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptTable getTableOrigin(RelNode rel) {
        if (rel.getRowType().getFieldCount() == 0) {
            return null;
        }
        Set<RelColumnOrigin> colOrigins = this.getColumnOrigins(rel, 0);
        if (colOrigins == null || colOrigins.size() == 0) {
            return null;
        }
        return colOrigins.iterator().next().getOriginTable();
    }

    public Double getSelectivity(RelNode rel, RexNode predicate) {
        while (true) {
            try {
                Double result = this.selectivityHandler.getSelectivity(rel, this, predicate);
                return RelMdUtil.validatePercentage(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.selectivityHandler = (BuiltInMetadata.Selectivity.Handler)this.revise(e.relClass, BuiltInMetadata.Selectivity.DEF);
                continue;
            }
            break;
        }
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel) {
        return this.getUniqueKeys(rel, false);
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        while (true) {
            try {
                return this.uniqueKeysHandler.getUniqueKeys(rel, this, ignoreNulls);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.uniqueKeysHandler = (BuiltInMetadata.UniqueKeys.Handler)this.revise(e.relClass, BuiltInMetadata.UniqueKeys.DEF);
                continue;
            }
            break;
        }
    }

    public Boolean areRowsUnique(RelNode rel) {
        ImmutableBitSet columns = ImmutableBitSet.range(rel.getRowType().getFieldCount());
        return this.areColumnsUnique(rel, columns, false);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns) {
        return this.areColumnsUnique(rel, columns, false);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        while (true) {
            try {
                return this.columnUniquenessHandler.areColumnsUnique(rel, this, columns, ignoreNulls);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnUniquenessHandler = (BuiltInMetadata.ColumnUniqueness.Handler)this.revise(e.relClass, BuiltInMetadata.ColumnUniqueness.DEF);
                continue;
            }
            break;
        }
    }

    public ImmutableList<RelCollation> collations(RelNode rel) {
        while (true) {
            try {
                return this.collationHandler.collations(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.collationHandler = (BuiltInMetadata.Collation.Handler)this.revise(e.relClass, BuiltInMetadata.Collation.DEF);
                continue;
            }
            break;
        }
    }

    public RelDistribution distribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.distribution(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distributionHandler = (BuiltInMetadata.Distribution.Handler)this.revise(e.relClass, BuiltInMetadata.Distribution.DEF);
                continue;
            }
            break;
        }
    }

    public Double getPopulationSize(RelNode rel, ImmutableBitSet groupKey) {
        while (true) {
            try {
                Double result = this.populationSizeHandler.getPopulationSize(rel, this, groupKey);
                return RelMdUtil.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.populationSizeHandler = (BuiltInMetadata.PopulationSize.Handler)this.revise(e.relClass, BuiltInMetadata.PopulationSize.DEF);
                continue;
            }
            break;
        }
    }

    public Double getAverageRowSize(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageRowSize(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.sizeHandler = (BuiltInMetadata.Size.Handler)this.revise(e.relClass, BuiltInMetadata.Size.DEF);
                continue;
            }
            break;
        }
    }

    public List<Double> getAverageColumnSizes(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageColumnSizes(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.sizeHandler = (BuiltInMetadata.Size.Handler)this.revise(e.relClass, BuiltInMetadata.Size.DEF);
                continue;
            }
            break;
        }
    }

    public List<Double> getAverageColumnSizesNotNull(RelNode rel) {
        List<Double> averageColumnSizes = this.getAverageColumnSizes(rel);
        return averageColumnSizes == null ? Collections.nCopies(rel.getRowType().getFieldCount(), null) : averageColumnSizes;
    }

    public Boolean isPhaseTransition(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.isPhaseTransition(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.parallelismHandler = (BuiltInMetadata.Parallelism.Handler)this.revise(e.relClass, BuiltInMetadata.Parallelism.DEF);
                continue;
            }
            break;
        }
    }

    public Integer splitCount(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.splitCount(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.parallelismHandler = (BuiltInMetadata.Parallelism.Handler)this.revise(e.relClass, BuiltInMetadata.Parallelism.DEF);
                continue;
            }
            break;
        }
    }

    public Double memory(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.memory(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double cumulativeMemoryWithinPhase(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhase(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double cumulativeMemoryWithinPhaseSplit(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhaseSplit(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        while (true) {
            try {
                Double result = this.distinctRowCountHandler.getDistinctRowCount(rel, this, groupKey, predicate);
                return RelMdUtil.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distinctRowCountHandler = (BuiltInMetadata.DistinctRowCount.Handler)this.revise(e.relClass, BuiltInMetadata.DistinctRowCount.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptPredicateList getPulledUpPredicates(RelNode rel) {
        while (true) {
            try {
                return this.predicatesHandler.getPredicates(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.predicatesHandler = (BuiltInMetadata.Predicates.Handler)this.revise(e.relClass, BuiltInMetadata.Predicates.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptPredicateList getAllPredicates(RelNode rel) {
        while (true) {
            try {
                return this.allPredicatesHandler.getAllPredicates(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.allPredicatesHandler = (BuiltInMetadata.AllPredicates.Handler)this.revise(e.relClass, BuiltInMetadata.AllPredicates.DEF);
                continue;
            }
            break;
        }
    }

    public boolean isVisibleInExplain(RelNode rel, SqlExplainLevel explainLevel) {
        while (true) {
            try {
                Boolean b = this.explainVisibilityHandler.isVisibleInExplain(rel, this, explainLevel);
                return b == null || b != false;
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.explainVisibilityHandler = (BuiltInMetadata.ExplainVisibility.Handler)this.revise(e.relClass, BuiltInMetadata.ExplainVisibility.DEF);
                continue;
            }
            break;
        }
    }

    public RelDistribution getDistribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.distribution(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distributionHandler = (BuiltInMetadata.Distribution.Handler)this.revise(e.relClass, BuiltInMetadata.Distribution.DEF);
                continue;
            }
            break;
        }
    }
}

