/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apiguardian.api.API;
import org.slf4j.Logger;

@API(since="1.23", status=API.Status.INTERNAL)
abstract class OptimizeTask {
    static final Logger LOGGER = CalciteTrace.getPlannerTaskTracer();
    final VolcanoPlanner planner;
    final int id;

    static OptimizeTask create(RelNode node) {
        if (node instanceof RelSubset) {
            return new RelSubsetOptTask((RelSubset)node);
        }
        return new RelNodeOptTask(node);
    }

    OptimizeTask(RelNode node) {
        this.planner = (VolcanoPlanner)node.getCluster().getPlanner();
        this.id = this.planner.nextTaskId++;
        LOGGER.debug("Scheduled task(id={}) for {}", (Object)this.id, (Object)node);
    }

    abstract boolean hasSubTask();

    abstract OptimizeTask nextSubTask();

    abstract void execute();

    static class RelSubsetOptTask
    extends OptimizeTask {
        final RelSubset subset;
        final Set<RelSubset> deliveredSubsets = new HashSet<RelSubset>();

        RelSubsetOptTask(RelSubset subset) {
            super(subset);
            this.subset = subset;
            subset.taskState = State.SCHEDULED;
            this.propagateTraits();
        }

        private void propagateTraits() {
            int size = this.subset.set.getSeedSize();
            for (int i = 0; i < size; ++i) {
                RelNode node;
                RelNode rel = this.subset.set.rels.get(i);
                if (!(rel instanceof PhysicalNode) || rel.getConvention() == Convention.NONE || rel.getTraitSet().satisfies(this.subset.getTraitSet()) || (node = ((PhysicalNode)rel).passThrough(this.subset.getTraitSet())) == null || this.planner.isRegistered(node)) continue;
                RelSubset newSubset = this.planner.register(node, this.subset);
                this.deliveredSubsets.add(newSubset);
            }
        }

        @Override
        boolean hasSubTask() {
            return this.subset.set.hasNextPhysicalNode();
        }

        @Override
        OptimizeTask nextSubTask() {
            RelNode rel = this.subset.set.nextPhysicalNode();
            return new RelNodeOptTask(rel);
        }

        @Override
        void execute() {
            this.subset.taskState = State.EXECUTING;
            this.subset.set.addConverters(this.subset, true, false);
            for (RelSubset delivered : this.deliveredSubsets) {
                this.subset.set.addConverters(delivered, false, false);
            }
            this.subset.taskState = State.COMPLETED;
            LOGGER.debug("Completed task(id={}) for {}", (Object)this.id, (Object)this.subset);
        }

        public String toString() {
            return "Task#" + this.id + ":{ " + this.subset + " }";
        }
    }

    static class RelNodeOptTask
    extends OptimizeTask {
        final RelNode node;
        int nextId = 0;

        RelNodeOptTask(RelNode node) {
            super(node);
            this.node = node;
        }

        @Override
        boolean hasSubTask() {
            int size = this.node.getInputs().size();
            while (this.nextId < size) {
                RelSubset subset = (RelSubset)this.node.getInput(this.nextId);
                if (subset.taskState == null) {
                    return true;
                }
                ++this.nextId;
            }
            return false;
        }

        @Override
        OptimizeTask nextSubTask() {
            RelNode child = this.node.getInput(this.nextId++);
            return new RelSubsetOptTask((RelSubset)child);
        }

        @Override
        void execute() {
            if (!(this.node instanceof PhysicalNode) || ((PhysicalNode)this.node).getDeriveMode() == DeriveMode.PROHIBITED || !this.planner.isSeedNode(this.node)) {
                LOGGER.debug("Completed task(id={}) for {}", (Object)this.id, (Object)this.node);
                return;
            }
            PhysicalNode rel = (PhysicalNode)this.node;
            DeriveMode mode = rel.getDeriveMode();
            int arity = this.node.getInputs().size();
            ArrayList<List<RelTraitSet>> inputTraits = new ArrayList<List<RelTraitSet>>(arity);
            for (int i = 0; i < arity; ++i) {
                int childId = i;
                if (mode == DeriveMode.RIGHT_FIRST) {
                    childId = arity - i - 1;
                }
                RelSubset input = (RelSubset)this.node.getInput(childId);
                ArrayList<RelTraitSet> traits = new ArrayList<RelTraitSet>();
                inputTraits.add(traits);
                int numSubset = input.set.subsets.size();
                for (int j = 0; j < numSubset; ++j) {
                    RelSubset subset = input.set.subsets.get(j);
                    if (!subset.isDelivered() || this.equalsSansConvention(subset.getTraitSet(), rel.getCluster().traitSet())) continue;
                    if (mode == DeriveMode.OMAKASE) {
                        traits.add(subset.getTraitSet());
                        continue;
                    }
                    RelNode newRel = rel.derive(subset.getTraitSet(), childId);
                    if (newRel == null || this.planner.isRegistered(newRel)) continue;
                    RelSubset relSubset = this.planner.register(newRel, this.node);
                    assert (relSubset.set == this.planner.getSubset((RelNode)this.node).set);
                }
                if (mode == DeriveMode.LEFT_FIRST || mode == DeriveMode.RIGHT_FIRST) break;
            }
            if (mode == DeriveMode.OMAKASE) {
                List<RelNode> relList = rel.derive(inputTraits);
                for (RelNode relNode : relList) {
                    if (this.planner.isRegistered(relNode)) continue;
                    this.planner.register(relNode, this.node);
                }
            }
            LOGGER.debug("Completed task(id={}) for {}", (Object)this.id, (Object)this.node);
        }

        private boolean equalsSansConvention(RelTraitSet ts1, RelTraitSet ts2) {
            assert (ts1.size() == ts2.size());
            for (int i = 0; i < ts1.size(); ++i) {
                RelTrait trait = ts1.getTrait(i);
                if (trait.getTraitDef() == ConventionTraitDef.INSTANCE || trait.equals(ts2.getTrait(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Task#" + this.id + ":{ " + this.node + " }";
        }
    }

    public static enum State {
        SCHEDULED,
        EXECUTING,
        COMPLETED;

    }
}

