/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class EnumerableSortedAggregate
extends Aggregate
implements EnumerableRel {
    public EnumerableSortedAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
    }

    @Override
    public EnumerableSortedAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new EnumerableSortedAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        if (!EnumerableSortedAggregate.isSimple(this)) {
            return null;
        }
        RelTraitSet inputTraits = this.getInput().getTraitSet();
        RelCollation collation = required.getTrait(RelCollationTraitDef.INSTANCE);
        ImmutableBitSet requiredKeys = ImmutableBitSet.of(RelCollations.ordinals(collation));
        ImmutableBitSet groupKeys = ImmutableBitSet.range(this.groupSet.cardinality());
        Mapping mapping = Mappings.source(this.groupSet.toList(), this.input.getRowType().getFieldCount());
        if (requiredKeys.equals(groupKeys)) {
            RelCollation inputCollation = RexUtil.apply((Mappings.TargetMapping)mapping, collation);
            return Pair.of(required, ImmutableList.of(inputTraits.replace(inputCollation)));
        }
        if (groupKeys.contains(requiredKeys)) {
            ArrayList<RelFieldCollation> list = new ArrayList<RelFieldCollation>(collation.getFieldCollations());
            groupKeys.except(requiredKeys).forEach(k -> list.add(new RelFieldCollation((int)k)));
            RelCollation aggCollation = RelCollations.of(list);
            RelCollation inputCollation = RexUtil.apply((Mappings.TargetMapping)mapping, aggCollation);
            return Pair.of(this.traitSet.replace(aggCollation), ImmutableList.of(inputTraits.replace(inputCollation)));
        }
        return null;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        throw Util.needToImplement("EnumerableSortedAggregate");
    }
}

