/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;

public final class EnumerableConvention
extends Enum<EnumerableConvention>
implements Convention {
    public static final /* enum */ EnumerableConvention INSTANCE = new EnumerableConvention();
    public static final double COST_MULTIPLIER = 1.0;
    private static final /* synthetic */ EnumerableConvention[] $VALUES;

    public static EnumerableConvention[] values() {
        return (EnumerableConvention[])$VALUES.clone();
    }

    public static EnumerableConvention valueOf(String name) {
        return Enum.valueOf(EnumerableConvention.class, name);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Class getInterface() {
        return EnumerableRel.class;
    }

    @Override
    public String getName() {
        return "ENUMERABLE";
    }

    @Override
    public RelNode enforce(RelNode input, RelTraitSet required) {
        RelCollation collation;
        RelNode rel = input;
        if (input.getConvention() != INSTANCE) {
            rel = ConventionTraitDef.INSTANCE.convert(input.getCluster().getPlanner(), input, INSTANCE, true);
        }
        if ((collation = required.getTrait(RelCollationTraitDef.INSTANCE)) != null) {
            assert (!collation.getFieldCollations().isEmpty());
            rel = EnumerableSort.create(rel, collation, null, null);
        }
        return rel;
    }

    @Override
    public RelTraitDef getTraitDef() {
        return ConventionTraitDef.INSTANCE;
    }

    @Override
    public boolean satisfies(RelTrait trait) {
        return this == trait;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean canConvertConvention(Convention toConvention) {
        return false;
    }

    @Override
    public boolean useAbstractConvertersForConversion(RelTraitSet fromTraits, RelTraitSet toTraits) {
        return true;
    }

    static {
        $VALUES = new EnumerableConvention[]{INSTANCE};
    }
}

