/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;

public class DaskTable
implements ProjectableFilterableTable {
    private final ArrayList<Pair<String, SqlTypeName>> tableColumns;
    private final String name;

    public DaskTable(String name) {
        this.name = name;
        this.tableColumns = new ArrayList();
    }

    public void addColumn(String columnName, SqlTypeName columnType) {
        this.tableColumns.add(new Pair<String, SqlTypeName>(columnName, columnType));
    }

    public String getTableName() {
        return this.name;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(relDataTypeFactory);
        for (Pair<String, SqlTypeName> column : this.tableColumns) {
            String name = column.getKey();
            SqlTypeName type = column.getValue();
            builder.add(name, relDataTypeFactory.createSqlType(type));
            builder.nullable(true);
        }
        return builder.build();
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    @Override
    public boolean isRolledUp(String string) {
        return false;
    }

    @Override
    public boolean rolledUpColumnValidInsideAgg(String string, SqlCall sc, SqlNode sn, CalciteConnectionConfig ccc) {
        throw new AssertionError((Object)"This should not be called!");
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
        return null;
    }
}

